/*
** netsoul.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Mon May 19 07:36:29 2003 Anto
** Last update Mon Jan  5 05:12:20 2004 Anto
*/

#include "netsoul.h"
#include "NoSoucy.h"
#include "conf.h"
#include "contacts.h"
#include "message.h"
#include "tab.h"
#include "request.h"
#include "utils.h"
#include "mail.h"
#include "url.h"
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#ifdef __linux
#include "md5_linux.h"
#else
#include <md5.h>
#endif
#include <time.h>
#include <ctype.h>

ns_t	*netsoul = NULL;

/* user cmd */
static void	netsoul_msg(char **);
static void	netsoul_mail(char **);
static void	netsoul_login(char **);
static void	netsoul_logout(char **);
static void	netsoul_state(char **);
static void	netsoul_who(char **);
static void	netsoul_typing_start(char **);
static void	netsoul_typing_end(char **);
/* other cmd */
static void	netsoul_salut(char **);
static void	netsoul_rep(char **);
static void	netsoul_ping(char **);

typedef struct	netsoul_cmd_s
{
  const char	*cmd;
  int		arg;
  void		(*fct)(char **);
}		netsoul_cmd_t;

static netsoul_cmd_t	netsoul_user_cmd[] = 
  {
    {"msg", 10, netsoul_msg},
    {"new_mail", 8, netsoul_mail},
    {"login", 10, netsoul_login},
    {"logout", 10, netsoul_logout},
    {"state", 10, netsoul_state},
    {"who", 10, netsoul_who},
    {"typing_start", 10, netsoul_typing_start},
    {"typing_end", 10, netsoul_typing_end},
    {"dotnetSoul_UserTyping", 10, netsoul_typing_start},
    {"dotnetSoul_UserCancelledTyping", 10, netsoul_typing_end},
    {NULL, 0, NULL},
  };

static netsoul_cmd_t	netsoul_other_cmd[] = 
  {
    {"salut ", 0, netsoul_salut},
    {"rep ", 0, netsoul_rep},
    {"ping ", 0, netsoul_ping},
    {NULL, 0, NULL},
  };

static void	netsoul_salut(char **input)
{
  if (netsoul->type != NETSOUL_TYPE_CONNECTING)
    return ;
  if (tab_len(input) != NETSOUL_CMD_SALUT_ARG)
    {
      netsoulLog("[info] : Connection : bad server answer\n");
      netsoulRestart(FALSE);
    }
  else
    {
      netsoul->time[TIME_SERVER] = atoi(input[5]);
      netsoul->time[TIME_CLIENT] = time(NULL);
      netsoul->time[TIME_DECAL] = netsoul->time[TIME_SERVER] - netsoul->time[TIME_CLIENT];
      netsoul->id = atoi(input[1]);
      asprintf(&netsoul->pass_set, "%s-%s/%s%s", input[2], input[3], input[4], conf->password);
      request_auth_ag();
    }
}

static void	netsoul_rep(char **input)
{
  if (tab_len(input) < NETSOUL_CMD_REP_ARG)
    return ;
  if (netsoul->type == NETSOUL_TYPE_FINAL && atoi(input[1]) == 33)
    {
      netsoulLog("[info] : Invalid login or password\n");
      netsoulRestart(FALSE);
    }
  else if (netsoul->type == NETSOUL_TYPE_FINAL && atoi(input[1]) == 2)
    {
      netsoul->type = NETSOUL_TYPE_EXT;
      netsoulLog("[info] : Your are logged in extern\n");
      netsoulConnected();
    }
  else if (netsoul->type == NETSOUL_TYPE_CONNECTING && atoi(input[1]) == 6)
    {
      netsoulLog("[info] : Authentification failed\n");
      netsoulRestart(FALSE);
    }
  else if (netsoul->type == NETSOUL_TYPE_CONNECTING && atoi(input[1]) == 2)
    {
      MD5_CTX	context;
      char	*password;

      netsoulLog("[info] : Authentification ...\n");
      MD5Init(&context);
      MD5Update(&context, netsoul->pass_set, strlen(netsoul->pass_set));
      password = MD5End(&context, NULL);
      request_user_log(conf->login, password, conf->location, conf->user_data);
      free(netsoul->pass_set);
      netsoul->type = NETSOUL_TYPE_FINAL;
    }
}

static void	netsoul_ping(char **input)
{
  request_ping(NULL);
}

static void	netsoul_msg(char **input)
{
  message_t	*message;
  char		*text;
  list_t	*item;
  buddy_t	*buddy = NULL;
  int		id;
  int		id_index;
  int		tablen;

  if ((tablen = tab_len(input)) < NETSOUL_CMD_MSG_ARG)
    return ;
  if (!strcmp(input[NETSOUL_CMD_MSG_MESSAGE], "dst") && 
      input[NETSOUL_CMD_MSG_MESSAGE + 1])
    text = "";
  else
    text = url_decode(input[NETSOUL_CMD_MSG_MESSAGE]);
  id = atoi(input[NETSOUL_CMD_MSG_ID]);
  if (listFind(conf->ignore, input[NETSOUL_CMD_MSG_LOGIN], strcmp))
    {
      if ((message = message_find_by_id(id)) || 
	  (message = message_find(input[NETSOUL_CMD_MSG_LOGIN])))
	message_insert_in(message, text);
      if (conf->ignore_answer && *conf->ignore_answer != '\0')
	{
	  request_cmd_msg(input[NETSOUL_CMD_MSG_LOGIN], conf->ignore_answer, id);
	  if (message)
	    message_insert_out(message, conf->ignore_answer);
	}
      netsoulLog("[info] : You have ignore a message from %s : %s\n", input[NETSOUL_CMD_MSG_LOGIN], text);
    }
  else
    {
      if ((item = listFind(conf->buddy, input[NETSOUL_CMD_MSG_LOGIN], 
			   contactsCmpBuddy)))
	buddy = (buddy_t *)item->data;
      if (!(message = message_find_by_id(id)) && 
	  !(message = message_find(input[NETSOUL_CMD_MSG_LOGIN])))
	{
	  if (buddy)
	    {
	      id_index = contactsFindBuddyId(buddy, id);
	      message = message_new(MESSAGE_TYPE_STD, buddy->login, buddy->alias, 
				    id_index != -1 ? &buddy->info[id_index] : NULL);
	    }
	  else
	    {
	      message = message_new(MESSAGE_TYPE_UNKNOWN, input[NETSOUL_CMD_MSG_LOGIN], NULL, NULL);
	      if (!listFind(netsoul->watchlog, input[NETSOUL_CMD_MSG_LOGIN], strcmp))
		putinlist(&netsoul->watchlog, strdup(input[NETSOUL_CMD_MSG_LOGIN]));
	      request_watch_log(netsoul->watchlog);
	      message_setid(message, id);
	    }
	}
      message_insert_in(message, text);
      if (conf->auto_answer == TRUE)
	{
	  list_t	*answer;
	  
	  if ((answer = listFindIndex(conf->answer, conf->default_message)) != NULL)
	    message_insert_auto_answer(message, answer->data);
	}
    }
}

static void	netsoul_mail(char **input)
{
  int		len;
  char		*from;
  char		*subject;

  len = tab_len(input);
  if (len == NETSOUL_CMD_MAIL_ARG)
    {
      asprintf(&from, "%s@%s", input[NETSOUL_CMD_MAIL_FROM], input[NETSOUL_CMD_MAIL_DOM]);
      subject = strdup(input[NETSOUL_CMD_MAIL_SUBJECT]);
    }
  else
    {
      from = strdup(input[NETSOUL_CMD_MAIL_FROM]);
      subject = strdup(input[NETSOUL_CMD_MAIL_FROM + 1]);
    }
  url_decode(subject);
  if (conf->big_mail_alert)
    mail_new(from, subject);
  NoSoucy_UIMailAlert(from, subject);
  free(from);
  free(subject);
}

static void	netsoul_login(char **input)
{
  if (tab_len(input) < NETSOUL_CMD_LOGIN_ARG)
    return ;
  if (listFind(conf->buddy, input[NETSOUL_CMD_USER_LOGIN], contactsCmpBuddy))
    {
      request_cmd_who(NULL, NULL, atoi(input[NETSOUL_CMD_USER_ID]));
      message_broadcast(input[NETSOUL_CMD_USER_LOGIN], MESSAGE_INFORMATION_LOGIN);
    }
}

static void	netsoul_logout(char **input)
{
  list_t	*list;
  message_t	*message;

  if (tab_len(input) < NETSOUL_CMD_LOGOUT_ARG)
    return ;
  if ((list = listFind(conf->buddy, input[NETSOUL_CMD_USER_LOGIN], contactsCmpBuddy)))
    {
      int	info_id;
      buddy_t	*buddy;

      buddy = (buddy_t *)list->data;
      if ((info_id = contactsFindBuddyId(buddy, atoi(input[NETSOUL_CMD_USER_ID]))) != -1)
	{
	  contactsFreeBuddyInfo(buddy, info_id);
	  contacts_UIHideBuddy(buddy, info_id);
	}
    }
  if ((message = message_find_by_id(atoi(input[NETSOUL_CMD_USER_ID]))) ||
      (message = message_find(input[NETSOUL_CMD_USER_LOGIN])))
    {
      message_information(message, MESSAGE_INFORMATION_LOGOUT);
      message_setid(message, -1);
    }
}

static void	netsoul_state(char **input)
{
  list_t	*list;

  if (tab_len(input) < NETSOUL_CMD_STATE_ARG)
    return ;
  if ((list = listFind(conf->buddy, input[NETSOUL_CMD_USER_LOGIN], contactsCmpBuddy)))
    {
      int	buddy_id;
      int	info_id;
      buddy_t	*buddy;

      buddy = (buddy_t *)list->data;
      buddy_id = atoi(input[NETSOUL_CMD_USER_ID]);
      if ((info_id = contactsFindBuddyId(buddy, buddy_id)) == -1)
	request_cmd_who(NULL, NULL, buddy_id);
      else
	{
	  contactsUpdateBuddyInfo(buddy, info_id, input + 1, 
				  BUDDY_MASK_STATE | BUDDY_MASK_TIME_STATE);
	  contacts_UIShowBuddy(buddy, info_id);
	}
    }
}

static void	netsoul_who(char **input)
{
  list_t	*list;

  if (netsoul->type == NETSOUL_TYPE_INT)
    {
      if (tab_len(input) == NETSOUL_CMD_WHO_INT_ARG)
	input += NETSOUL_CMD_WHO_INT_ARG - NETSOUL_CMD_WHO_ARG;
      else
	return ;
    }
  if (tab_len(input) != NETSOUL_CMD_WHO_ARG)
    return ;
  if ((list = listFind(conf->buddy, input[NETSOUL_CMD_WHO_LOGIN], contactsCmpBuddy)))
    {
      int	info_id;
      buddy_t	*buddy;

      buddy = (buddy_t *)list->data;
      if ((info_id = contactsFindBuddyId(buddy, atoi(input[NETSOUL_CMD_WHO_ID]))) == -1)
	info_id = contactsGetNewBuddyInfoId(buddy);
      if (info_id != -1)
	{
	  contactsUpdateBuddyInfo(buddy, info_id, input, BUDDY_MASK_ALL);
	  contacts_UIShowBuddy(buddy, info_id);
	  if (buddy->nb_log == 1 && buddy->alerte)
	    contacts_UIAlert(buddy, info_id);
	}
    }
}

static void	netsoul_typing_start(char **input)
{
  message_t	*message;
  int		id;
  
  if (tab_len(input) < NETSOUL_CMD_MSG_ARG)
    return ;
  id = atoi(input[NETSOUL_CMD_MSG_ID]);
  if ((message = message_find_by_id(id)) ||
      (message = message_find(input[NETSOUL_CMD_MSG_LOGIN])))
    message_typing(message, TRUE);
}

static void	netsoul_typing_end(char **input)
{
  message_t	*message;
  int		id;
  
  if (tab_len(input) < NETSOUL_CMD_MSG_ARG)
    return ;
  id = atoi(input[NETSOUL_CMD_MSG_ID]);
  if ((message = message_find_by_id(id)) ||
      (message = message_find(input[NETSOUL_CMD_MSG_LOGIN])))
    message_typing(message, FALSE);
}

#define isUserCmd(x) (!strncmp("user_cmd", x, 8))

void	netsoulInput(void *data, int sock, int condition)
{
  int	i;
  char	*input;
  char	**input_tab;

  input = utils_readLine(sock);
  if (input == NULL || *input == '\0')
    {
      netsoulRestart(TRUE);
      contacts_UIHideAll(conf->buddy);
      return ;
    }
  netsoulLog("[Received] : %s\n", input);
  input_tab = tab_str(input, " :@=");
  if (isUserCmd(input) && tab_len(input_tab) > 9)
    {
      for (i = 0; netsoul_user_cmd[i].cmd != NULL; i++)
	if (!strncmp(input_tab[netsoul_user_cmd[i].arg], 
		     netsoul_user_cmd[i].cmd, 
		     strlen(netsoul_user_cmd[i].cmd)))
	  {
	    netsoul_user_cmd[i].fct(input_tab);
	    break ;
	  }
    }
  else if (netsoul->type == NETSOUL_TYPE_EXT && isdigit(*input_tab[NETSOUL_CMD_WHO_ID]))
    netsoul_who(input_tab);
  else
    for (i = 0; netsoul_other_cmd[i].cmd != NULL; i++)
      if (!strncmp(input, 
		   netsoul_other_cmd[i].cmd, 
		   strlen(netsoul_other_cmd[i].cmd)))
	{
	  netsoul_other_cmd[i].fct(input_tab);
	  break ;
	}
  tab_free(input_tab);
  free(input);
}

void	netsoulNew()
{
  netsoul = calloc(1, sizeof(ns_t));
  netsoul->type = NETSOUL_TYPE_DISC;
  netsoul->sock = -1;
  netsoul->delay = 0;
  netsoul->attempt = 1;
  netsoul->watchlog = contactsMakeBuddyList(conf->buddy);
  netsoul->log = NULL;
  netsoul->tag = -1;
}

void	netsoulFree()
{
  listFree(netsoul->watchlog, free);
  free(netsoul);
  netsoul = NULL;
}

void		netsoulLog(const char *format, ...)
{
#ifdef __linux
  G_LOCK_DEFINE_STATIC(log_lock);
#endif
  static int	line = 0;
  char		*txt;
  va_list	ap;

#ifdef __linux
  G_LOCK(log_lock);
#else
  GDK_THREADS_ENTER();
#endif

  va_start(ap, format);
  vasprintf(&txt, format, ap);
  putinlist(&netsoul->log, strdup(txt));
  if (line < NETSOUL_LOG_LINE)
    line++;
  else if (netsoul->log && netsoul->log->data)
    listRemoveItem(&netsoul->log, netsoul->log->data, free);
  NoSoucy_UILog(txt);
  va_end(ap);

#ifdef __linux
  G_UNLOCK(log_lock);
#else
  GDK_THREADS_LEAVE();
#endif
}
