/*
** message.h for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Wed Aug  6 21:39:29 2003 Anto
** Last update Sun Jan  4 18:38:11 2004 Anto
*/

#ifndef _MESSAGE_H_
#define _MESSAGE_H_

#include <gtk/gtk.h>
#include "contacts.h"
#include "list.h"

#define MESSAGE_TYPE_STD	1
#define MESSAGE_TYPE_UNKNOWN	2
#define MESSAGE_TYPE_MASS	3

typedef struct	message_log_s
{
  short		x;
  short		y;
  short		width;
  short		height;
  char		pict;
  list_t	*history;
  int		limit;
}		message_log_t;

typedef struct	message_s
{
  int		type;
  char		*login;
  char		*alias;
  info_t	*info;
  short		id;
  char		auto_answered;
  GtkWidget	*window;
  char		typing;
  message_log_t	log;
}		message_t;

typedef struct	message_menu_s
{
  const char	*name;
  int		width;
  int		x_offset;
  void		(*callback)();
}		message_menu_t;

#define MESSAGE_INFORMATION_LOGOUT	"Your correspondent signed off"
#define MESSAGE_INFORMATION_LOGIN	"Your correspondent signed on"

message_t	*message_new(int, char *, char *, info_t *);
void		message_free(message_t *);
int		message_cmp(message_t *, GtkWidget *);
void		message_insert_out(message_t *, const char *);
void		message_insert_in(message_t *, const char *);
void		message_insert_history(message_t *, const char *);
int		message_insert_auto_answer(message_t *, const char *);
char		*message_insert_conv(GtkWidget *, char *, const char *, const char *);
void		message_information(message_t *, const char *);
message_t	*message_find(char *);
message_t	*message_find_by_id(int);
void		message_setid(message_t *, int);
void		message_setinfo(message_t *, info_t *);
void		message_list_reset_info(list_t *);
void		message_broadcast(char *, const char *);
void		message_typing(message_t *, char);

/* log */
void		message_log(char *, message_log_t *);
void		message_log_save(char *, message_log_t *);
void		message_log_show(char *, char *);

/* private */
void		message_paint(GtkWidget *, GdkRectangle *, gpointer);
void		on_Message_button_draw(GtkWidget *, GdkRectangle *, gpointer);
gboolean	on_Message_button_expose_event(GtkWidget *, GdkEventExpose  *, gpointer);
void		on_Message_destroy(GtkWidget *, gpointer);
gboolean	on_Message_delete_event(GtkWidget *, GdkEvent *, gpointer);
void		fake_draw_focus(GtkStyle *, GdkWindow *, GdkRectangle *, GtkWidget *,
				gchar *, gint, gint, gint, gint);
void		fake_draw_shadow(GtkStyle *, GdkWindow *, GtkStateType, GtkShadowType,
				 GdkRectangle *, GtkWidget *, gchar *, gint, gint, gint, gint);
gboolean	on_Message_key_press(GtkWidget *, GdkEventKey *, gpointer);
void		on_Message_show(GtkWidget *, gpointer);
void		on_Message_hide(GtkWidget *, gpointer);
void		on_message_history(GtkWidget *, gpointer);
void		on_message_block(GtkWidget *, gpointer);
void		on_message_expand(GtkWidget *, gpointer);
void		on_message_collapse(GtkWidget *, gpointer);
gboolean	on_Message_typing(GtkWidget *, GdkEventKey *, gpointer);

extern list_t	*message_list;

#endif /* _MESSAGE_H_ */
