/*
** log.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Tue Nov 25 23:50:39 2003 Anto
** Last update Fri Dec 12 22:46:28 2003 Anto
*/

#include "log.h"
#include <string.h>

static GtkWidget	*create_log_window(const char *);
static void		on_btnClear_clicked(GtkButton *, gpointer);

log_t	*log_new(const char *title)
{
  return (create_log_window(title));
}

void		log_add(log_t *log, const char *txt)
{
  GtkWidget	*txtLog;

  txtLog = gtk_object_get_data(GTK_OBJECT(log), "txtLog");
  gtk_text_insert(GTK_TEXT(txtLog), NULL, NULL, NULL, txt, strlen(txt));  
}

void	log_show(log_t *log)
{
  gtk_widget_show(log);
}

void	log_destroy_event(log_t *log, void (*destroy_fct)(), gpointer user_data)
{
  gtk_signal_connect (GTK_OBJECT (log), "destroy",
                      GTK_SIGNAL_FUNC (destroy_fct),
                      user_data);
}

static GtkWidget	*create_log_window(const char *title)
{
  GtkWidget		*log_window;
  GtkWidget		*table16;
  GtkWidget		*scrolledwindow4;
  GtkWidget		*txtLog;
  GtkWidget		*btnClear;
  GtkWidget		*btnClose;

  log_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (log_window), "log_window", log_window);
  gtk_window_set_title (GTK_WINDOW (log_window), title);
  gtk_window_set_position (GTK_WINDOW (log_window), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size (GTK_WINDOW (log_window), 400, 400);
  gtk_window_set_policy (GTK_WINDOW (log_window), TRUE, TRUE, FALSE);

  table16 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table16);
  gtk_object_set_data_full (GTK_OBJECT (log_window), "table16", table16,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table16);
  gtk_container_add (GTK_CONTAINER (log_window), table16);
  gtk_container_set_border_width (GTK_CONTAINER (table16), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table16), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table16), 5);

  scrolledwindow4 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow4);
  gtk_object_set_data_full (GTK_OBJECT (log_window), "scrolledwindow4", scrolledwindow4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow4);
  gtk_table_attach (GTK_TABLE (table16), scrolledwindow4, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow4), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  txtLog = gtk_text_new (NULL, NULL);
  gtk_widget_ref (txtLog);
  gtk_object_set_data_full (GTK_OBJECT (log_window), "txtLog", txtLog,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_text_set_line_wrap(GTK_TEXT(txtLog), FALSE);
  gtk_widget_show (txtLog);
  gtk_container_add (GTK_CONTAINER (scrolledwindow4), txtLog);

  btnClear = gtk_button_new_with_label ("Clear");
  gtk_widget_ref (btnClear);
  gtk_object_set_data_full (GTK_OBJECT (log_window), "btnClear", btnClear,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnClear);
  gtk_table_attach (GTK_TABLE (table16), btnClear, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  btnClose = gtk_button_new_with_label ("Close");
  gtk_widget_ref (btnClose);
  gtk_object_set_data_full (GTK_OBJECT (log_window), "btnClose", btnClose,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnClose);
  gtk_table_attach (GTK_TABLE (table16), btnClose, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_signal_connect (GTK_OBJECT (btnClear), "clicked",
                      GTK_SIGNAL_FUNC (on_btnClear_clicked),
                      txtLog);
  gtk_signal_connect_object (GTK_OBJECT (btnClose), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (log_window));
  return log_window;
}

static void	on_btnClear_clicked(GtkButton *button,
				    gpointer user_data)
{
  GtkWidget	*txtLog;

  txtLog = (GtkWidget *)user_data;
  gtk_text_set_point(GTK_TEXT(txtLog), 0);
  gtk_text_forward_delete(GTK_TEXT(txtLog), gtk_text_get_length(GTK_TEXT(txtLog)));
}
