/*
** xml.c for  in /home/dev/NoSoucy
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 15:40:59 2003 Anto
** Last update Fri Dec 19 08:08:20 2003 Anto
*/

#include "xml.h"
#include "url.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

void	xmlIntToStr(int nb, char str[])
{
  sprintf(str, "%d", nb);
}

const char	*xmlBoolToStr(int nb)
{
  if (nb == TRUE)
    return ("1");
  return ("0");
}

int		xmlGetPropInt(xmlNodePtr cur, const char *prop, int deflt)
{
  xmlChar	*key;
  
  if ((key = xmlGetProp(cur, prop)))
    {
      int	value;
      
      value = atoi(key);
      xmlFree(key);
      return (value);
    }
  return (deflt);
}

int		xmlGetPropBoolean(xmlNodePtr cur, const char *prop, int deflt)
{
  xmlChar	*key;
  
  if ((key = xmlGetProp(cur, prop)))
    {
      int	value;
      
      if (strlen(key) > 1)
	value = strcmp(key, "enabled");
      else
	value = !(*key == '1');
      xmlFree(key);
      return (!value);
    }
  return (deflt);
}

char		*xmlGetPropStr(xmlNodePtr cur, const char *prop, char *deflt)
{
  xmlChar	*key;
  
  if ((key = xmlGetProp(cur, prop)))
    {
      char	*value;
      
      value = strdup(key);
      xmlFree(key);
      return (url_decode(value));
    }
  return (deflt ? strdup(deflt) : deflt);
}

char		*xmlNodeGetString(xmlDocPtr doc, xmlNodePtr cur, char *deflt)
{
  xmlChar	*key;
  
  if ((key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1)))
    {
      char	*value;
      
      value = strdup(key);
      xmlFree(key);
      return (url_decode(value));
    }
  return (deflt ? strdup(deflt) : deflt);
}

xmlNodePtr	xmlNewChildEncoded(xmlNodePtr child, const char *name, char *value)
{
  char		*enc_value;
  xmlNodePtr	sub;
  
  enc_value = url_encode(value);
  sub = xmlNewChild(child, NULL, name, enc_value);
  free(enc_value);
  return (sub);
}

void	xmlNewPropEncoded(xmlNodePtr node, const char *name, char *value)
{
  char	*enc_value;
  
  enc_value = url_encode(value);
  xmlNewProp(node, name, enc_value);
  free(enc_value);
}
