/*
** ns_tooltip.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 22:20:04 2003 Anto
** Last update Sun Jan  4 14:31:44 2004 Anto
*/

#include "ns_tooltip.h"
#include "skin.h"
#include "url.h"
#include "utils.h"
#include "netsoul.h"
#include "env.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <gdk_imlib.h>

static GtkWidget	*create_ns_tooltip(void);
static GtkWidget	*create_ns_tooltip_info(GtkWidget *, const char *);
static gboolean		on_tooltip_item_enter_notify(GtkWidget *, GdkEventMotion *, gpointer);
static gboolean		on_tooltip_item_leave_notify(GtkWidget *, GdkEventMotion *, gpointer);
static gint		ns_tooltip_timeout(gpointer);
static gint		ns_tooltip_refresh(gpointer);

static ns_tooltip_t	*tooltip = NULL;

ns_tooltip_t	*ns_tooltip_new()
{
  tooltip = malloc(sizeof(ns_tooltip_t));
  tooltip->delay = TOOLTIP_DELAY;
  tooltip->refresh_id = 0;
  tooltip->window = create_ns_tooltip();
  gtk_widget_realize(tooltip->window);
  gdk_window_set_override_redirect(tooltip->window->window, TRUE);
  gdk_window_set_decorations(tooltip->window->window, GDK_DECOR_BORDER);
  return (tooltip);
}

void		ns_tooltip_add(buddy_t *buddy)
{
  int		i;
  
  gtk_signal_connect(GTK_OBJECT(buddy->item), "enter_notify_event",
		     GTK_SIGNAL_FUNC(on_tooltip_item_enter_notify), buddy);
  gtk_signal_connect(GTK_OBJECT(buddy->item), "leave_notify_event",
		     GTK_SIGNAL_FUNC(on_tooltip_item_leave_notify), buddy);
  for (i = 0; i < MAX_LOG; i++)
    {
      gtk_signal_connect(GTK_OBJECT(buddy->info[i].item), "enter_notify_event",
			 GTK_SIGNAL_FUNC(on_tooltip_item_enter_notify), buddy);
      gtk_signal_connect(GTK_OBJECT(buddy->info[i].item), "leave_notify_event",
			 GTK_SIGNAL_FUNC(on_tooltip_item_leave_notify), buddy);
    }
}

void		ns_tooltip_update(buddy_t *buddy, int id)
{
  GtkWidget	*login;
  GtkWidget	*alias;
  GtkWidget	*ip;
  GtkWidget	*location;
  GtkWidget	*online_time;
  GtkWidget	*state;
  GtkWidget	*user_data;
  GtkWidget	*group;
  GtkWidget	*nblog;
  char		*tmp;

  login = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblLogin");
  alias = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblAlias");
  group = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblGroup");
  nblog = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblNbLog");
  ip = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblIP");
  location = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblLocation");
  online_time = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblOnlineTime");
  state = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblState");
  user_data = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblUserData");
  gtk_label_set(GTK_LABEL(login), buddy->login);
  gtk_label_set(GTK_LABEL(alias), buddy->alias);
  gtk_label_set(GTK_LABEL(group), buddy->info[id].group);
  asprintf(&tmp, "Logs number : %d", buddy->nb_log);
  gtk_label_set(GTK_LABEL(nblog), tmp);
  free(tmp);
  gtk_label_set(GTK_LABEL(ip), buddy->info[id].ip);
  tmp = strdup(buddy->info[id].mach_loc);
  gtk_label_set(GTK_LABEL(location), url_decode(tmp));
  free(tmp);
  gtk_label_set(GTK_LABEL(state), buddy->info[id].state);
  tmp = strdup(buddy->info[id].user_data);
  gtk_label_set(GTK_LABEL(user_data), url_decode(tmp));
  free(tmp);
}

static GtkWidget	*create_ns_tooltip(void)
{
  GtkWidget		*ns_tooltip;
  GtkWidget		*vbox12;
  GtkWidget		*hbox11;
  GtkWidget		*pixmap;
  GtkWidget		*vbox13;
  GtkWidget		*lblLogin;
  GtkWidget		*lblAlias;
  GtkWidget		*lblGroup;
  GtkWidget		*lblNbLog;
  GtkWidget		*simple_info;
  GtkWidget		*simple_viewport;

  ns_tooltip = gtk_window_new (GTK_WINDOW_DIALOG );
  gtk_object_set_data (GTK_OBJECT (ns_tooltip), "ns_tooltip", ns_tooltip);
  gtk_container_set_border_width (GTK_CONTAINER (ns_tooltip), 2);
  gtk_window_set_title (GTK_WINDOW (ns_tooltip), "tooltip");
  gtk_window_set_default_size (GTK_WINDOW (ns_tooltip), 250, 190);
  gtk_window_set_policy (GTK_WINDOW (ns_tooltip), FALSE, FALSE, FALSE);
  
  vbox12 = gtk_vbox_new (FALSE, 2);
  gtk_widget_ref (vbox12);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "vbox12", vbox12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox12);
  gtk_container_add (GTK_CONTAINER (ns_tooltip), vbox12);

  hbox11 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox11);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "hbox11", hbox11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox11);
  gtk_box_pack_start (GTK_BOX (vbox12), hbox11, FALSE, FALSE, 0);

  pixmap = gtk_pixmap_new(skin->icon[SKIN_NO].pixmap, skin->icon[SKIN_NO].mask);
  gtk_widget_ref (pixmap);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "pixmap", pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_object_set_data(GTK_OBJECT(pixmap), "login", "");
  gtk_widget_show (pixmap);
  gtk_box_pack_start (GTK_BOX (hbox11), pixmap, FALSE, TRUE, 0);
  gtk_widget_set_usize (pixmap, 75, 90);

  vbox13 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox13);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "vbox13", vbox13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox13);
  gtk_box_pack_start (GTK_BOX (hbox11), vbox13, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox13), 2);

  lblLogin = gtk_label_new ("Login");
  gtk_widget_ref (lblLogin);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "lblLogin", lblLogin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblLogin);
  gtk_box_pack_start (GTK_BOX (vbox13), lblLogin, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblLogin), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblLogin), 0, 0.5);

  lblAlias = gtk_label_new ("Alias");
  gtk_widget_ref (lblAlias);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "lblAlias", lblAlias,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblAlias);
  gtk_box_pack_start (GTK_BOX (vbox13), lblAlias, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (lblAlias), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblAlias), 0, 0.5);

  lblGroup = gtk_label_new ("group");
  gtk_widget_ref (lblGroup);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "lblGroup", lblGroup,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblGroup);
  gtk_box_pack_start (GTK_BOX (vbox13), lblGroup, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (lblGroup), 0, 0.5);

  lblNbLog = gtk_label_new ("nb log");
  gtk_widget_ref (lblNbLog);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "lblNbLog", lblNbLog,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblNbLog);
  gtk_box_pack_start (GTK_BOX (vbox13), lblNbLog, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (lblNbLog), 0, 0.5);

  simple_viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (simple_viewport);
  gtk_object_set_data_full (GTK_OBJECT (ns_tooltip), "simpleViewport", simple_viewport,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_viewport_set_shadow_type(GTK_VIEWPORT(simple_viewport), GTK_SHADOW_ETCHED_IN);

  gtk_widget_show (simple_viewport);
  gtk_widget_set_usize (simple_viewport, 245, 95);
  gtk_box_pack_start (GTK_BOX (vbox12), simple_viewport, TRUE, TRUE, 0);

  simple_info = create_ns_tooltip_info(ns_tooltip, "simpleInfo");
  gtk_widget_show (simple_info);
  gtk_container_add (GTK_CONTAINER (simple_viewport), simple_info);
  gtk_widget_set_usize (simple_info, 245, 95);

  utils_setBackground(ns_tooltip, 0xE0E0E0);
  utils_setBackground(simple_viewport, 0xF0F0F0);

  return ns_tooltip;
}

static GtkWidget	*create_ns_tooltip_info(GtkWidget *window, const char *name)
{
  GtkWidget *tableInfo;
  GtkWidget *labelIP;
  GtkWidget *labelLocation;
  GtkWidget *labelonlinetime;
  GtkWidget *labelstate;
  GtkWidget *labeluserdata;
  GtkWidget *lblUserData;
  GtkWidget *lblState;
  GtkWidget *lblOnlineTime;
  GtkWidget *lblIP;
  GtkWidget *lblLocation;

  tableInfo = gtk_table_new (5, 2, FALSE);
  gtk_widget_ref (tableInfo);
  gtk_object_set_data_full(GTK_OBJECT(window), name, tableInfo,
			   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show (tableInfo);
  gtk_container_set_border_width (GTK_CONTAINER (tableInfo), 2);
  gtk_table_set_row_spacings (GTK_TABLE (tableInfo), 2);

  labelIP = gtk_label_new ("IP : ");
  gtk_widget_ref (labelIP);
  gtk_object_set_data_full (GTK_OBJECT (window), "labelIP", labelIP,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelIP);
  gtk_table_attach (GTK_TABLE (tableInfo), labelIP, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (labelIP, 75, -2);
  gtk_misc_set_alignment (GTK_MISC (labelIP), 0, 0.5);

  labelLocation = gtk_label_new ("Location : ");
  gtk_widget_ref (labelLocation);
  gtk_object_set_data_full (GTK_OBJECT (window), "labelLocation", labelLocation,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelLocation);
  gtk_table_attach (GTK_TABLE (tableInfo), labelLocation, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (labelLocation, 75, -2);
  gtk_misc_set_alignment (GTK_MISC (labelLocation), 0, 0.5);

  labelonlinetime = gtk_label_new ("Online time : ");
  gtk_widget_ref (labelonlinetime);
  gtk_object_set_data_full (GTK_OBJECT (window), "labelonlinetime", labelonlinetime,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelonlinetime);
  gtk_table_attach (GTK_TABLE (tableInfo), labelonlinetime, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (labelonlinetime, 75, -2);
  gtk_misc_set_alignment (GTK_MISC (labelonlinetime), 0, 0.5);

  labelstate = gtk_label_new ("State : ");
  gtk_widget_ref (labelstate);
  gtk_object_set_data_full (GTK_OBJECT (window), "labelstate", labelstate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelstate);
  gtk_table_attach (GTK_TABLE (tableInfo), labelstate, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (labelstate, 75, -2);
  gtk_misc_set_alignment (GTK_MISC (labelstate), 0, 0.5);

  labeluserdata = gtk_label_new ("User data : ");
  gtk_widget_ref (labeluserdata);
  gtk_object_set_data_full (GTK_OBJECT (window), "labeluserdata", labeluserdata,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labeluserdata);
  gtk_table_attach (GTK_TABLE (tableInfo), labeluserdata, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (labeluserdata, 75, -2);
  gtk_label_set_justify (GTK_LABEL (labeluserdata), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (labeluserdata), 0, 0.5);

  lblUserData = gtk_label_new ("");
  gtk_label_set_line_wrap (GTK_LABEL(lblUserData), TRUE);
  gtk_widget_ref (lblUserData);
  gtk_object_set_data_full (GTK_OBJECT (window), "lblUserData", lblUserData,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblUserData);
  gtk_table_attach (GTK_TABLE (tableInfo), lblUserData, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (lblUserData), 0, 0.5);

  lblState = gtk_label_new ("");
  gtk_widget_ref (lblState);
  gtk_object_set_data_full (GTK_OBJECT (window), "lblState", lblState,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblState);
  gtk_table_attach (GTK_TABLE (tableInfo), lblState, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lblState), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblState), 0, 0.5);

  lblOnlineTime = gtk_label_new ("");
  gtk_widget_ref (lblOnlineTime);
  gtk_object_set_data_full (GTK_OBJECT (window), "lblOnlineTime", lblOnlineTime,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblOnlineTime);
  gtk_table_attach (GTK_TABLE (tableInfo), lblOnlineTime, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (lblOnlineTime), 0, 0.5);

  lblIP = gtk_label_new ("");
  gtk_widget_ref (lblIP);
  gtk_object_set_data_full (GTK_OBJECT (window), "lblIP", lblIP,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblIP);
  gtk_table_attach (GTK_TABLE (tableInfo), lblIP, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (lblIP), 0, 0.5);

  lblLocation = gtk_label_new ("");
  gtk_label_set_line_wrap (GTK_LABEL(lblLocation), TRUE);
  gtk_widget_ref (lblLocation);
  gtk_object_set_data_full (GTK_OBJECT (window), "lblLocation", lblLocation,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblLocation);
  gtk_table_attach (GTK_TABLE (tableInfo), lblLocation, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (lblLocation), 0, 0.5);

  return (tableInfo);
}

static gboolean	on_tooltip_item_enter_notify(GtkWidget *w, GdkEventMotion *event, gpointer data)
{
  int		i;
  buddy_t	*buddy;

  buddy = (buddy_t *)data;
  for (i = 0; i < MAX_LOG; i++)
    if ((buddy->nb_log != 1 && buddy->info[i].item == w) ||
	(buddy->nb_log == 1 && buddy->info[i].id > 0))
      {
	tooltip->item_id = i;
	break ;
      }
  if (i != MAX_LOG)
    {
      tooltip->tag_id = gtk_timeout_add(tooltip->delay, ns_tooltip_timeout, buddy);
      tooltip->refresh_id = gtk_timeout_add(1000, ns_tooltip_refresh, buddy);
    }
  return (gtk_false());
}

static gboolean	on_tooltip_item_leave_notify(GtkWidget *w, GdkEventMotion *event, gpointer data)
{
  if (tooltip->tag_id)
    {
      gtk_timeout_remove(tooltip->tag_id);
      tooltip->tag_id = 0;
    }
  if (tooltip->refresh_id)
    {
      gtk_timeout_remove(tooltip->refresh_id);
      tooltip->refresh_id = 0;
    }
  gtk_widget_hide(tooltip->window);
  tooltip->item_id = -1;
  return (gtk_false());
}

static void	mkstrtime(char str[32], int temp)
{
#define S(x) ((x > 1)?"s":"")
  int		day;
  int		hour;
  int		min;
  int		sec;

  sec = temp % 60;
  temp /= 60;
  min = temp % 60;
  temp /= 60;
  hour = temp % 24;
  day = temp / 24;
  memset(str, '\0', sizeof(str));
  if (day)
    sprintf(str, "%d day%s ", day % 10, S(day));
  if (hour)
    sprintf(str, "%s%02d hour%s ", str, hour, S(hour));
  if (min)
    sprintf(str, "%s%02d min ", str, min);
  if (sec || str[0] == '\0')
    sprintf(str, "%s%02d sec", str, sec);
}

static gint	ns_tooltip_refresh(gpointer data)
{
  buddy_t	*buddy;
  time_t	now;
  GtkWidget	*state;
  GtkWidget	*onlinetime;
  char		strtime[32];
  char		*tmp = NULL;
  static time_t prev = 0;

  buddy = (buddy_t *)data;
  if (GTK_WIDGET_VISIBLE(tooltip->window) == FALSE)
    return (FALSE);
  state = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblState");
  onlinetime = gtk_object_get_data(GTK_OBJECT(tooltip->window), "lblOnlineTime");
  now = time(NULL);
  mkstrtime(strtime, now - buddy->info[tooltip->item_id].time_login + netsoul->time[TIME_DECAL]);
  asprintf(&tmp, "%s", strtime);
  gtk_label_set(GTK_LABEL(onlinetime), tmp);
  free(tmp);
  mkstrtime(strtime, now - buddy->info[tooltip->item_id].time_state + netsoul->time[TIME_DECAL]);
  asprintf(&tmp, "%s (%s)", buddy->info[tooltip->item_id].state, strtime);
  gtk_label_set(GTK_LABEL(state), tmp);
  free(tmp);
  prev = now;
  return (TRUE);
}

static gint	ns_tooltip_timeout(gpointer data)
{
  buddy_t	*buddy;

  buddy = (buddy_t *)data;
  
  if (tooltip->item_id != -1)
    {
      int		x;
      int		y;
      GtkRequisition	requ;

      ns_tooltip_update(buddy, tooltip->item_id);
      gtk_widget_size_request(buddy->item, &requ);
      gdk_window_get_pointer(NULL, &x, &y, NULL);
      if (x + 250 > gdk_screen_width())
	x = gdk_screen_width() - 250;
      if (y + 190 + requ.height > gdk_screen_height())
	y -= (requ.height + 190);
      else
	y += requ.height;
      utils_photo_set(buddy->login, 75, 90, 
		      gtk_object_get_data(GTK_OBJECT(tooltip->window), "pixmap"));
      gtk_widget_set_uposition(tooltip->window, x, y);
      gtk_widget_show(tooltip->window);
    }

  return (FALSE);
}
