# Copyright 1999-2010 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $
EAPI=3
inherit webapp depend.php


DESCRIPTION="SimpleID is a simple, personal OpenID provider written in PHP."
HOMEPAGE="http://simpleid.sourceforge.net"
SRC_URI="mirror://sourceforge/${PN}/${PV}/${P}.tar.gz"

LICENSE="GPL-2"
KEYWORDS="~amd64"
IUSE=""

DEPEND=""
RDEPEND="${DEPEND} dev-lang/php[bcmath,session,xml,hash,gmp]"

S="${WORKDIR}/${PN}"

need_httpd
need_php_httpd

pkg_setup() {
	webapp_pkg_setup
	require_php_with_use bcmath session xml hash gmp
}

src_install() {
	webapp_src_preinst

	insinto "${MY_HTDOCSDIR}"
	doins -r www/*

	insinto "${MY_HOSTROOTDIR}"
	doins -r identities cache store

	webapp_configfile "${MY_HOSTROOTDIR}/identities"
	webapp_serverowned "${MY_HOSTROOTDIR}"/{cache,store}

	webapp_src_install
}
