/*
** skin.c for  in /home/dev/xml
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 15:35:27 2003 Anto
** Last update Sun Jan  4 12:42:48 2004 Anto
*/

#include "skin.h"
#include "xml.h"
/* states */
#include "pixmap/online.xpm"
#include "pixmap/away.xpm"
#include "pixmap/lock.xpm"
#include "pixmap/idle.xpm"
#include "pixmap/connection.xpm"
#include "pixmap/server.xpm"
#include "pixmap/unknown.xpm"
#include "pixmap/offline.xpm"
#include "pixmap/multi.xpm"
/* icon */
#include "pixmap/preferences.xpm"
#include "pixmap/mail.xpm"
#include "pixmap/mail_alert.xpm"
#include "pixmap/mail_big.xpm"
#include "pixmap/mail_big_alert.xpm"
#include "pixmap/no.xpm"
#include "pixmap/message_dialog.xpm"
#include "pixmap/typing.xpm"
#include "pixmap/scrollbar.xpm"
/* menu */
#include "pixmap/add.xpm"
#include "pixmap/alert.xpm"
#include "pixmap/block.xpm"
#include "pixmap/remove.xpm"
#include "pixmap/rename.xpm"
#include "pixmap/send_file.xpm"
#include "pixmap/send_message.xpm"
#include "pixmap/show_log.xpm"
#include "pixmap/connect.xpm"
#include "pixmap/disconnect.xpm"
#include "pixmap/NoSoucy.xpm"
#include <string.h>

skin_t	*skin = NULL;

#define SKIN_RC_STATE_TEMPLATE "style '%s_style'\n{\nbg[NORMAL] = '%s'\nfg[NORMAL] = '%s'\nfont = '%s'\n}\nwidget '*%s' style '%s_style'"
#define SKIN_RC_HIGHLIGHT_TEMPLATE "style 'highlight_%s'\n{\nbg[NORMAL] = '%s'\nbg[SELECTED] = '%s'\n}\nwidget '*%s' style 'highlight_%s'"
#define SKIN_RC_BACKGROUND_TEMPLATE "style '%s_style'\n{\nbg[NORMAL] = '%s'\n}\nwidget '*%s' style '%s_style'"

static pixmap_t	default_skin_icon[SKIN_MAX_ICON] = 
  {
    /* state icon */
    {SKIN_ACTIF_TOKEN,		NULL, online_xpm,	NULL, NULL},
    {SKIN_AWAY_TOKEN,		NULL, away_xpm,		NULL, NULL},
    {SKIN_LOCK_TOKEN,		NULL, lock_xpm,		NULL, NULL},
    {SKIN_CONNECTION_TOKEN,	NULL, idle_xpm,		NULL, NULL},
    {SKIN_IDLE_TOKEN,		NULL, connection_xpm,	NULL, NULL},
    {SKIN_SERVER_TOKEN,		NULL, server_xpm,	NULL, NULL},
    {SKIN_UNKNOWN_TOKEN,	NULL, unknown_xpm,	NULL, NULL},
    {SKIN_OFFLINE_TOKEN,	NULL, offline_xpm,	NULL, NULL},
    {SKIN_MULTI_TOKEN,		NULL, multi_xpm,	NULL, NULL},
    /* icon */
    {SKIN_PREFERENCES_TOKEN,	NULL, preferences_xpm,	NULL, NULL},
    {SKIN_SEND_MESSAGE_TOKEN,	NULL, send_message_xpm, NULL, NULL},
    {SKIN_MAIL_TOKEN,		NULL, mail_xpm,		NULL, NULL},
    {SKIN_MAIL_ALERT_TOKEN,	NULL, mail_alert_xpm,	NULL, NULL},
    {SKIN_MAIL_BIG_TOKEN,	NULL, mail_big_xpm,	NULL, NULL},
    {SKIN_MAIL_BIG_ALERT_TOKEN, NULL, mail_big_alert_xpm, NULL, NULL},
    {SKIN_NO_TOKEN,		NULL, no_xpm,		NULL, NULL},
    {SKIN_MESSAGE_DIALOG_TOKEN, NULL, message_dialog_xpm, NULL, NULL},
    {SKIN_SCROLLBAR_TOKEN,	NULL, scrollbar_xpm,	NULL, NULL},
    {SKIN_ADD_TOKEN,		NULL, add_xpm,		NULL, NULL},
    {SKIN_ALERT_TOKEN,		NULL, alert_xpm,	NULL, NULL},
    {SKIN_BLOCK_TOKEN,		NULL, block_xpm,	NULL, NULL},
    {SKIN_REMOVE_TOKEN,		NULL, remove_xpm,	NULL, NULL},
    {SKIN_RENAME_TOKEN,		NULL, rename_xpm,	NULL, NULL},
    {SKIN_SEND_FILE_TOKEN,	NULL, send_file_xpm,	NULL, NULL},
    {SKIN_SHOW_LOG_TOKEN,	NULL, show_log_xpm,	NULL, NULL},
    {SKIN_CONNECT_TOKEN,	NULL, connect_xpm,	NULL, NULL},
    {SKIN_DISCONNECT_TOKEN,	NULL, disconnect_xpm,	NULL, NULL},
    {SKIN_NOSOUCY_TOKEN,	NULL, NoSoucy_xpm,	NULL, NULL},
    {SKIN_TYPING_TOKEN,		NULL, typing_xpm,	NULL, NULL}
  };

static skin_g_t	default_skin_state[SKIN_MAX_STATE + 1] =
  {
    /* states */
    {SKIN_ACTIF_TOKEN,   "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*", "#000000"},
    {SKIN_AWAY_TOKEN,    "-adobe-helvetica-medium-o-*-*-12-*-*-*-*-*-*-*", "#000000"},
    {SKIN_LOCK_TOKEN,    "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*", "#000000"},
    {SKIN_IDLE_TOKEN,	 "-adobe-helvetica-medium-o-*-*-12-*-*-*-*-*-*-*", "#939393"},
    {SKIN_CONNECTION_TOKEN, "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*", "#000000"},
    {SKIN_SERVER_TOKEN,	 "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*", "#000000"},
    {SKIN_UNKNOWN_TOKEN, "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*", "#939393"},
    {SKIN_OFFLINE_TOKEN, "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*", "#939393"},
    {SKIN_MULTI_TOKEN,   "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*", "#000000"},
    /* group */
    {SKIN_GROUP_TOKEN,	 "-adobe-helvetica-bold-r-*-*-12-*-*-*-*-*-*-*", "#000000"}
  };

static void	skinParseState(xmlDocPtr doc, xmlNodePtr cur, int state_id)
{
  cur = cur->xmlChildrenNode;
  while (cur != NULL)
    {
      if ((!xmlStrcmp(cur->name, (const xmlChar *)"font")))
	skin->state[state_id].font = xmlNodeGetString(doc, cur, default_skin_state[state_id].font);
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"color")))
	skin->state[state_id].color = xmlNodeGetString(doc, cur, default_skin_state[state_id].color);
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"pixmap")))
	skin->icon[state_id].filename = xmlNodeGetString(doc, cur, default_skin_icon[state_id].filename);
      cur = cur->next;
    }
}

static void	skinParseColors(xmlDocPtr doc, xmlNodePtr cur)
{
  cur = cur->xmlChildrenNode;
  while (cur != NULL)
    {
      if ((!xmlStrcmp(cur->name, (const xmlChar *)"highlight_buddy")))
	skin->highlight_buddy_color = xmlNodeGetString(doc, cur, SKIN_DEFAULT_HIGHLIGHT_BUDDY_COLOR);
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"highlight_group")))
	skin->highlight_group_color = xmlNodeGetString(doc, cur, SKIN_DEFAULT_HIGHLIGHT_GROUP_COLOR);
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"background")))
	skin->background_color = xmlNodeGetString(doc, cur, SKIN_DEFAULT_BACKGROUND_COLOR);
      cur = cur->next;
    }
}

static void	skinParseIcons(xmlDocPtr doc, xmlNodePtr cur)
{
  int		icon_id;

  cur = cur->xmlChildrenNode;
  while (cur != NULL)
    {
      for (icon_id = SKIN_MAX_STATE; icon_id < SKIN_MAX_ICON; icon_id++)
	if ((!xmlStrcmp(cur->name, (const xmlChar *)skin->icon[icon_id].token)))
	  {
	    skin->icon[icon_id].filename = xmlNodeGetString(doc, cur, default_skin_icon[icon_id].filename);
	    break ;
	  }
      cur = cur->next;
    }
  
}

static void	skinLoadIconPixmap(char *path)
{
  char		*fullname;
  int		icon_id;
  
  for (icon_id = 0; icon_id < SKIN_MAX_ICON; icon_id++)
    {
      if (skin->icon[icon_id].filename)
	{
	  asprintf(&fullname, "%s/%s", path, skin->icon[icon_id].filename);
	  skin->icon[icon_id].pixmap = 
	    gdk_pixmap_colormap_create_from_xpm(NULL, gdk_colormap_get_system(),
						&skin->icon[icon_id].mask,
						NULL, fullname);
	  free(fullname);
	}
      if (!skin->icon[icon_id].pixmap)
	skin->icon[icon_id].pixmap = 
	  gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(),
						&skin->icon[icon_id].mask,
						NULL, default_skin_icon[icon_id].data);
    }
}

static void	skinSetRcStyle()
{
  char		*rc_style_string;
  int		state_id;

  for (state_id = 0; state_id < SKIN_MAX_STATE; state_id++)
    {
      asprintf(&rc_style_string, SKIN_RC_STATE_TEMPLATE, 
	       default_skin_state[state_id].name,
	       skin->background_color,
	       default_skin_state[state_id].color,
	       default_skin_state[state_id].font,
	       default_skin_state[state_id].name,
	       default_skin_state[state_id].name);
      gtk_rc_parse_string(rc_style_string);
      free(rc_style_string);
    }
  asprintf(&rc_style_string, SKIN_RC_STATE_TEMPLATE, 
	   default_skin_state[SKIN_MAX_STATE].name,
	   skin->background_color,
	   default_skin_state[SKIN_MAX_STATE].color,
	   default_skin_state[SKIN_MAX_STATE].font,
	   default_skin_state[SKIN_MAX_STATE].name,
	   default_skin_state[SKIN_MAX_STATE].name);
  gtk_rc_parse_string(rc_style_string);
  free(rc_style_string);
  asprintf(&rc_style_string, SKIN_RC_HIGHLIGHT_TEMPLATE, 
	   "group", skin->background_color, skin->highlight_group_color, "group", "group");
  gtk_rc_parse_string(rc_style_string);
  free(rc_style_string);
  asprintf(&rc_style_string, SKIN_RC_HIGHLIGHT_TEMPLATE, 
	   "buddy", skin->background_color, skin->highlight_buddy_color, "buddy", "buddy");
  gtk_rc_parse_string(rc_style_string);
  free(rc_style_string);
  asprintf(&rc_style_string, SKIN_RC_BACKGROUND_TEMPLATE, 
	   "NoSoucyBackground", skin->background_color, "NoSoucyBackground", "NoSoucyBackground");
  gtk_rc_parse_string(rc_style_string);
  free(rc_style_string);
}

static void	skinSetDefault()
{
  int		state_id;

  for (state_id = 0; state_id < SKIN_MAX_STATE; state_id++)
    {
      skin->state[state_id].name = strdup(default_skin_state[state_id].name);
      if (!skin->state[state_id].font)
	skin->state[state_id].font = strdup(default_skin_state[state_id].font);
      if (!skin->state[state_id].color)
	skin->state[state_id].color = strdup(default_skin_state[state_id].color);
    }
  skin->group.name = strdup(default_skin_state[SKIN_MAX_STATE].name);
  if (!skin->group.font)
    skin->group.font = strdup(default_skin_state[SKIN_MAX_STATE].font);
  if (!skin->group.color)
    skin->group.color = strdup(default_skin_state[SKIN_MAX_STATE].color);
  if (!skin->highlight_buddy_color)
    skin->highlight_buddy_color = strdup(SKIN_DEFAULT_HIGHLIGHT_BUDDY_COLOR);
  if (!skin->highlight_group_color)
    skin->highlight_group_color = strdup(SKIN_DEFAULT_HIGHLIGHT_GROUP_COLOR);
  if (!skin->background_color)
    skin->background_color = strdup(SKIN_DEFAULT_BACKGROUND_COLOR);
}

skin_t		*skinParseDoc(char *docname)
{
  xmlDocPtr	doc;
  xmlNodePtr	cur;

  skin = calloc(1, sizeof(skin_t));
  skin->path = "./";
  if ((doc = xmlParseFile(docname)))
    {
      cur = xmlDocGetRootElement(doc);
      if (cur != NULL && !xmlStrcmp(cur->name, (const xmlChar *)"SkinNoSoucy"))
	for (cur = cur->xmlChildrenNode; cur != NULL; cur = cur->next)
	  {
	    if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_ACTIF_TOKEN)))
	      skinParseState(doc, cur, SKIN_ONLINE);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_AWAY_TOKEN)))
	      skinParseState(doc, cur, SKIN_AWAY);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_LOCK_TOKEN)))
	      skinParseState(doc, cur, SKIN_LOCK);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_CONNECTION_TOKEN)))
	      skinParseState(doc, cur, SKIN_CONNECTION);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_IDLE_TOKEN)))
	      skinParseState(doc, cur, SKIN_IDLE);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_SERVER_TOKEN)))
	      skinParseState(doc, cur, SKIN_SERVER);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_UNKNOWN_TOKEN)))
	      skinParseState(doc, cur, SKIN_UNKNOWN);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_OFFLINE_TOKEN)))
	      skinParseState(doc, cur, SKIN_OFFLINE);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_MULTI_TOKEN)))
	      skinParseState(doc, cur, SKIN_MULTI);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)SKIN_GROUP_TOKEN)))
	      skinParseState(doc, cur, SKIN_MAX_STATE);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)"colors")))
	      skinParseColors(doc, cur);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)"icons")))
	      skinParseIcons(doc, cur);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)"path")))
	      skin->path = xmlNodeGetString(doc, cur, "./");
	  }
      xmlFreeDoc(doc);
    }
  skinLoadIconPixmap(skin->path);
  skinSetDefault();
  skinSetRcStyle();
  return (skin);  
}

int	skinStateToId(char *state)
{
  if (!strcmp(state, SKIN_ACTIF_TOKEN))
    return (SKIN_ONLINE);
  if (!strcmp(state, SKIN_AWAY_TOKEN))
    return (SKIN_AWAY);
  if (!strcmp(state, SKIN_LOCK_TOKEN))
    return (SKIN_LOCK);
  if (!strcmp(state, SKIN_CONNECTION_TOKEN))
    return (SKIN_CONNECTION);
  if (!strcmp(state, SKIN_IDLE_TOKEN))
    return (SKIN_IDLE);
  if (!strcmp(state, SKIN_SERVER_TOKEN))
    return (SKIN_SERVER);
  return (SKIN_UNKNOWN);
}
