/*
** list.c for  in /home/dev/xml
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sat May 17 17:35:17 2003 Anto
** Last update Fri Dec 12 00:10:28 2003 Anto
*/

#include "list.h"
#include <stdlib.h>

void		putinlist(list_t **list, void *data)
{
  list_t	*nw;
  list_t	*tmp;

  nw = malloc(sizeof(list_t));
  nw->data = data;
  nw->next = NULL;
  for (tmp = *list; tmp && tmp->next; tmp = tmp->next)
    ;
  if (!tmp)
    *list = nw;
  else
    tmp->next = nw;
}

int		listFree(list_t *list, void (*free_fct)())
{
  list_t	*next;

  if (!list)
    return (0);
  next = list->next;
  if (free_fct != NULL && list->data != NULL)
    free_fct(list->data);
  free(list);
  return (listFree(next, free_fct));
}

void		listRemoveItem(list_t **list, void *data, void (*free_fct)())
{
  list_t	*prev = NULL;
  list_t	*tmp;

  if (!*list)
    return ;
  for (tmp = *list; tmp; tmp = tmp->next)
    {
      if (tmp->data == data)
	{
	  if (prev == NULL)
	    *list = tmp->next;
	  else
	    prev->next = tmp->next;
	  free_fct(tmp->data);
	  free(tmp);
	  break ;
	}
      prev = tmp;
    }
}

void		listRemoveItemCmp(list_t **list, void *data, 
				  int (*cmp_fct)(), void (*free_fct)())
{
  list_t	*prev = NULL;
  list_t	*tmp;

  if (!*list)
    return ;
  for (tmp = *list; tmp; tmp = tmp->next)
    {
      if (!cmp_fct(tmp->data, data))
	{
	  if (prev == NULL)
	    *list = tmp->next;
	  else
	    prev->next = tmp->next;
	  free_fct(tmp->data);
	  free(tmp);
	  break ;
	}
      prev = tmp;
    }
}

list_t	*listFind(list_t *list, void *data, int (*cmp)())
{
  while (list)
    {
      if (!cmp(list->data, data))
	return (list);
      list = list->next;
    }
  return (NULL);
}


list_t	*listFindData(list_t *list, void *data)
{
  while (list)
    {
      if (list->data == data)
	return (list);
      list = list->next;
    }
  return (NULL);
}

void	*listFindIndex(list_t *list, int index)
{
  int	i;

  for (i = 0; i <= index && list; i++)
    {
      if (i == index)
	return (list);
      list = list->next;
    }
  return (NULL);
}

int	listSize(list_t *list)
{
  int	size;

  for (size = 0; list; size++)
    list = list->next;
  return (size);
}
