/*
** message_log.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Mon Nov 10 10:51:59 2003 Anto
** Last update Sun Jan  4 18:28:53 2004 Anto
*/

#include "message.h"
#include "env.h"
#include "conf.h"
#include "xml.h"
#include "log.h"

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <time.h>

static char	*get_log_file(char *login)
{
  char		*str = NULL;
  
  asprintf(&str, "%s/%s.xml", env->log, login);
  return (str);
}

void		message_log(char *login, message_log_t *log)
{
  xmlDocPtr	doc;
  xmlNodePtr	cur;
  char		*logfile;
  int		lines = 0;
  char		*history = NULL;
  int		history_line;

  logfile = get_log_file(login);
  log->history = NULL;
  log->width = conf->message_width;
  log->height = conf->message_height;
  log->x = conf->message_x;
  log->y = conf->message_y;
  log->pict = conf->expand_pict;
  history_line = conf->history_line;
  if ((doc = xmlParseFile(logfile)))
    {
      cur = xmlDocGetRootElement(doc);
      if (cur != NULL && !xmlStrcmp(cur->name, (const xmlChar *)"message"))
	{
	  for (cur = cur->xmlChildrenNode; cur != NULL; cur = cur->next)
	    if ((!xmlStrcmp(cur->name, (const xmlChar *)"info")))
	      {
		log->width = xmlGetPropInt(cur, "width", conf->message_width);
		log->height = xmlGetPropInt(cur, "height", conf->message_height);
		log->x = xmlGetPropInt(cur, "x", conf->message_x);
		log->y = xmlGetPropInt(cur, "y", conf->message_y);
		log->pict = xmlGetPropBoolean(cur, "pict", conf->expand_pict);
	      }
	    else if (conf->history == TRUE && (!xmlStrcmp(cur->name, (const xmlChar *)"history")))
	      {
		if (lines >= history_line + 1 && log->history != NULL)
		  {
		    listRemoveItem(&log->history, log->history->data, free);
		    if (log->limit)
		      lines--;
		  }
		history = xmlNodeGetString(doc, cur, "");
		putinlist(&log->history, history);
		if (*history == ' ')
		  history_line++;
		if (log->limit)
		  lines++;
	      }
	}
      xmlFreeDoc(doc);
    }
  free(logfile);
}

static void	message_log_save_info(xmlNodePtr node, message_log_t *log, 
				      xmlAttrPtr (*prop_fct)())
{
  char		buff[10];

  if (conf->message_save_geometry)
    {
      xmlIntToStr(log->width, buff);
      prop_fct(node, "width", buff);
      xmlIntToStr(log->height, buff);
      prop_fct(node, "height", buff);
      xmlIntToStr(log->x, buff);
      prop_fct(node, "x", buff);
      xmlIntToStr(log->y, buff);
      prop_fct(node, "y", buff);
    }
  else
    {
      xmlIntToStr(conf->message_width, buff);
      prop_fct(node, "width", buff);
      xmlIntToStr(conf->message_height, buff);
      prop_fct(node, "height", buff);
      xmlIntToStr(conf->message_x, buff);
      prop_fct(node, "x", buff);
      xmlIntToStr(conf->message_y, buff);
      prop_fct(node, "y", buff);
    }
  prop_fct(node, "pict", xmlBoolToStr(log->pict));
}

static void	message_log_save_new(char *logfile, message_log_t *log)
{
  xmlDocPtr	doc;
  xmlNodePtr    root;
  list_t	*history;

  if ((doc = xmlNewDoc("1.0")))
    {
      xmlIndentTreeOutput = 1;
      root = xmlNewDocNode(doc, NULL, "message", NULL);
      message_log_save_info(xmlNewChild(root, NULL, "info", NULL), log, xmlNewProp);
      for (history = log->history; history; history = history->next)
	xmlNewChild(root, NULL, "history", history->data);
      xmlDocSetRootElement(doc, root);
      xmlSaveFormatFile(logfile, doc, 1);
      xmlFreeDoc(doc);
    }
}

void		message_log_save(char *login, message_log_t *log)
{
  xmlDocPtr	doc;
  xmlNodePtr    root;
  xmlNodePtr	child;
  char		*logfile;
  list_t	*history;

  logfile = get_log_file(login);
  if ((doc = xmlParseFile(logfile)))
    {
      xmlIndentTreeOutput = 1;
      root = xmlDocGetRootElement(doc);
      if (root != NULL && !xmlStrcmp(root->name, (const xmlChar *)"message"))
	{
	  for (child = root->xmlChildrenNode; child != NULL; child = child->next)
	    if ((!xmlStrcmp(child->name, (const xmlChar *)"info")))
	      {
		message_log_save_info(child, log, xmlSetProp);
		break ;
	      }
	  if (child == NULL)
	    message_log_save_info(xmlNewChild(root, NULL, "info", NULL), log, xmlNewProp);
	  for (history = log->history; history; history = history->next)
	    xmlNewChild(root, NULL, "history", history->data);
	  xmlSaveFormatFile(logfile, doc, 1);
	}
      else
	message_log_save_new(logfile, log);
      xmlFreeDoc(doc);
    }
  else
    message_log_save_new(logfile, log);
  free(logfile);
}

void		message_log_show(char *login, char *alias)
{
  message_log_t	msg_log;
  log_t		*log;
  char		*title;
  char		*line;

  msg_log.limit = FALSE;
  message_log(login, &msg_log);
  asprintf(&title, "NoSoucy - %s's log", alias ? alias : login);
  log = log_new(title);
  while (msg_log.history)
    {
      asprintf(&line, "%s\n", (char *)msg_log.history->data);
      log_add(log, (const char *)line);
      listRemoveItem(&msg_log.history, msg_log.history->data, free);
      free(line);
    }    
  log_show(log);
  free(title);  
}
