/*
** message.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Wed Aug  6 21:36:25 2003 Anto
** Last update Sun Jan  4 19:36:10 2004 Anto
*/

#include <gdk_imlib.h>
#include "message.h"
#include "skin.h"
#include "conf.h"
#include "utils.h"
#include "url.h"
#include "netsoul.h"
#include "request.h"
#include "skinedvbox.h"
#include "skinedvscrollbar.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

static GtkWidget	*create_Message(message_t *);
static GtkStyleClass	default_class;

list_t			*message_list = NULL;

static	message_menu_t	message_menu[] = 
  {
/*     {"btnSendFile"	, 49, 1}, */
/*     {"btnAdd"		, 25, 51, on_message_add}, */
/*     {"btnInfo"		, 26, 77}, */
    {"btnHistory"	, 42, 104, on_message_history},
    {"btnBlock"		, 33, 147, on_message_block},
    {"btnExpand"	, 18, 181, on_message_expand},
    {"btnCollapse"	, 18, 200, on_message_collapse},
    {NULL, 0, 0}
  };

message_t	*message_new(int type, char *login, char *alias, info_t *info)
{
  message_t	*message;
  GtkStyle	*style;
  GtkWidget	*txtSend;
  GtkWidget	*txtConversation;
  char		*date;
  int		mdate;

  message = calloc(1, sizeof(message_t));
  message->type = type;
  message->id = info ? info->id : -1;
  message->auto_answered = FALSE;
  message->login = strdup(login ? login : "");
  message->alias = strdup(alias ? alias : message->login);
  message->typing = FALSE;
  message->log.limit = TRUE;
  message_log(message->login, &message->log);

  message->window = create_Message(message);
  message_setinfo(message, info);

  txtSend = gtk_object_get_data(GTK_OBJECT(message->window), "txtSend");
  txtConversation = gtk_object_get_data(GTK_OBJECT(message->window), "txtConversation");

  style = gtk_style_new();
  bcopy(txtSend->style->klass, &default_class, sizeof(GtkStyleClass));
  style->klass = &default_class;
  style->klass->draw_focus = fake_draw_focus;
  style->klass->draw_shadow = fake_draw_shadow;
  style->klass->xthickness = -1;
  style->klass->ythickness = -1;
  gtk_style_ref(style);
  gtk_style_unref(txtSend->style);
  gtk_widget_set_style(txtSend, style);
  gtk_style_unref(txtConversation->style);
  gtk_widget_set_style(txtConversation, style);
  
  utils_photo_set(message->login, 50, 60,
		  gtk_object_get_data(GTK_OBJECT(message->window), "pixmap"));
  while (message->log.history)
    {
      if (*((char *)message->log.history->data) != ' ')
	message_insert_history(message, message->log.history->data);
      listRemoveItem(&message->log.history, message->log.history->data, free);
    }
  gtk_widget_show(message->window);
  putinlist(&message_list, message);

  mdate = time(NULL) + netsoul->time[TIME_DECAL];
  asprintf(&date, "   *** %.24s ***   ", ctime((const time_t *)&mdate));
  putinlist(&message->log.history, date);
  return (message);
}

void	message_setid(message_t *message, int id)
{
  message->id = id;
}

void	message_setinfo(message_t *message, info_t *info)
{
  char	*label_text;
  char	*tmp;

  message->info = info;
  if (info && message->type == MESSAGE_TYPE_STD)
    {
      message->id = info->id;
      tmp = strdup(message->info->mach_loc);
      asprintf(&label_text, "%s@%s", message->alias, url_decode(tmp));
      gtk_label_set_text(GTK_LABEL(gtk_object_get_data(GTK_OBJECT(message->window), "lblLogin")), 
			 label_text);
      free(label_text);
      free(tmp);
    }
}

static GtkWidget	*create_Message(message_t *message)
{
  GtkWidget		*Message;
  GtkWidget		*vbox;
  GtkWidget		*hboxLogin;
  GtkWidget		*lblLoginLeft;
  GtkWidget		*lblLogin;
  GtkWidget		*lblLoginRight;
  GtkWidget		*menubox;
  GtkWidget		*lblMenuLeft;
  GtkWidget		*btnMenu;
  GtkWidget		*lblMenuRight;
  GtkWidget		*hboxConversation;
  GtkWidget		*lblConversation;
  GtkWidget		*scrolledwindow;
  GtkWidget		*txtConversation;
  GtkWidget		*table;
  GtkWidget		*hboxTyping;
  GtkWidget		*pixmapTyping;
  GtkWidget		*lblTyping;
  GtkWidget		*txtSend;
  GtkWidget		*pixmap;
  GtkWidget		*line;
  GdkImlibImage		*img;
  GdkPixmap		*pxmp;
  GdkBitmap		*mask;
  int			i;
  char			*label_text;
  char			*window_text;

  Message = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (Message), "Message", Message);
  
  asprintf(&window_text, "NoSoucy - %s", message->alias);
  gtk_window_set_title(GTK_WINDOW (Message), window_text);
  free(window_text);
  
  gtk_window_set_default_size (GTK_WINDOW (Message), message->log.width, message->log.height);
  gtk_widget_set_uposition(Message, message->log.x, message->log.y);
  
  vbox = skined_vbox_new (FALSE, 0, message_paint, message);
  gtk_widget_ref (vbox);
  gtk_object_set_data_full (GTK_OBJECT (Message), "vbox", vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (Message), vbox);

  hboxLogin = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hboxLogin);
  gtk_object_set_data_full (GTK_OBJECT (Message), "hboxLogin", hboxLogin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hboxLogin);
  gtk_box_pack_start (GTK_BOX (vbox), hboxLogin, FALSE, FALSE, 0);
  gtk_widget_set_usize (hboxLogin, -2, 25);
  gtk_container_set_border_width (GTK_CONTAINER (hboxLogin), 5);

  lblLoginLeft = gtk_label_new ("");
  gtk_widget_ref (lblLoginLeft);
  gtk_object_set_data_full (GTK_OBJECT (Message), "lblLoginLeft", lblLoginLeft,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblLoginLeft);
  gtk_box_pack_start (GTK_BOX (hboxLogin), lblLoginLeft, FALSE, FALSE, 0);
  gtk_widget_set_usize (lblLoginLeft, 25, -2);

  asprintf(&label_text, "%s", message->alias);
  lblLogin = gtk_label_new (label_text);
  gtk_widget_ref (lblLogin);
  gtk_object_set_data_full (GTK_OBJECT (Message), "lblLogin", lblLogin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblLogin);
  gtk_box_pack_start (GTK_BOX (hboxLogin), lblLogin, TRUE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (lblLogin), 0, 0.5);
  free(label_text);
  
  lblLoginRight = gtk_label_new ("");
  gtk_widget_ref (lblLoginRight);
  gtk_object_set_data_full (GTK_OBJECT (Message), "lblLoginRight", lblLoginRight,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblLoginRight);
  gtk_box_pack_start (GTK_BOX (hboxLogin), lblLoginRight, FALSE, FALSE, 0);
  gtk_widget_set_usize (lblLoginRight, 25, -2);

  menubox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (menubox);
  gtk_object_set_data_full (GTK_OBJECT (Message), "menubox", menubox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menubox);
  gtk_box_pack_start (GTK_BOX (vbox), menubox, FALSE, FALSE, 0);

  lblMenuLeft = gtk_label_new ("");
  gtk_widget_ref (lblMenuLeft);
  gtk_object_set_data_full (GTK_OBJECT (Message), "lblMenuLeft", lblMenuLeft,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblMenuLeft);
  gtk_box_pack_start (GTK_BOX (menubox), lblMenuLeft, FALSE, FALSE, 0);
  gtk_widget_set_usize (lblMenuLeft, 5, -2);

  for (i = 0; message_menu[i].name != NULL; i++)
    {
      btnMenu = gtk_button_new ();
      gtk_button_set_relief(GTK_BUTTON(btnMenu), GTK_RELIEF_NONE);
      gtk_widget_ref (btnMenu);
      gtk_object_set_data_full (GTK_OBJECT (Message), message_menu[i].name, btnMenu,
				(GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_set_usize(btnMenu, message_menu[i].width, 18);
      gtk_widget_show (btnMenu);  
      gtk_box_pack_start (GTK_BOX (menubox), btnMenu, FALSE, FALSE, 0);

      gtk_signal_connect (GTK_OBJECT (btnMenu), "clicked",
			  GTK_SIGNAL_FUNC (message_menu[i].callback),
			  (gpointer)message);
      gtk_signal_connect_after (GTK_OBJECT (btnMenu), "draw",
				GTK_SIGNAL_FUNC (on_Message_button_draw),
				(gpointer)message_menu[i].x_offset);
      gtk_signal_connect_after (GTK_OBJECT (btnMenu), "expose_event",
				GTK_SIGNAL_FUNC (on_Message_button_expose_event),
				(gpointer)message_menu[i].x_offset);
    }

  lblMenuRight = gtk_label_new ("");
  gtk_widget_ref (lblMenuRight);
  gtk_object_set_data_full (GTK_OBJECT (Message), "lblMenuRight", lblMenuRight,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblMenuRight);
  gtk_box_pack_start (GTK_BOX (menubox), lblMenuRight, TRUE, TRUE, 0);
  gtk_widget_set_usize (lblMenuRight, 5, -2);

  line = gtk_label_new("");
  gtk_widget_show (line);
  gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);
  gtk_widget_set_usize (line, -2, 1);

  hboxConversation = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hboxConversation);
  gtk_object_set_data_full (GTK_OBJECT (Message), "hboxConversation", hboxConversation,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hboxConversation);
  gtk_box_pack_start (GTK_BOX (vbox), hboxConversation, TRUE, TRUE, 0);

  lblConversation = gtk_label_new ("");
  gtk_widget_ref (lblConversation);
  gtk_object_set_data_full (GTK_OBJECT (Message), "lblConversation", lblConversation,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblConversation);
  gtk_box_pack_start (GTK_BOX (hboxConversation), lblConversation, FALSE, FALSE, 0);
  gtk_widget_set_usize (lblConversation, 5, -2);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow);
  gtk_object_set_data_full (GTK_OBJECT (Message), "scrolledwindow", scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (hboxConversation), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  GTK_SCROLLED_WINDOW(scrolledwindow)->vscrollbar = skined_vscrollbar_new();
  gtk_widget_set_parent(GTK_SCROLLED_WINDOW(scrolledwindow)->vscrollbar, scrolledwindow);
  gtk_widget_ref (GTK_SCROLLED_WINDOW(scrolledwindow)->vscrollbar);

  txtConversation = gtk_text_new (NULL, NULL);
  gtk_widget_ref (txtConversation);
  gtk_object_set_data_full (GTK_OBJECT (Message), "txtConversation", txtConversation,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (txtConversation);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), txtConversation);

  table = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table);
  gtk_object_set_data_full (GTK_OBJECT (Message), "table", table,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table), 5);

  hboxTyping = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hboxTyping);
  gtk_object_set_data_full (GTK_OBJECT (Message), "hboxTyping", hboxTyping,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hboxTyping);
  gtk_table_attach (GTK_TABLE (table), hboxTyping, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (hboxTyping, -2, 20);

  pixmapTyping = gtk_pixmap_new (skin->icon[SKIN_TYPING].pixmap, skin->icon[SKIN_TYPING].mask);
  gtk_widget_ref (pixmapTyping);
  gtk_object_set_data_full (GTK_OBJECT (Message), "pixmapTyping", pixmapTyping,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmapTyping);
  gtk_box_pack_start (GTK_BOX (hboxTyping), pixmapTyping, FALSE, FALSE, 0);
  gtk_widget_set_usize (pixmapTyping, 16, 16);

  asprintf(&label_text, "%s is typing a message", message->alias);
  lblTyping = gtk_label_new (label_text);
  gtk_widget_ref (lblTyping);
  gtk_object_set_data_full (GTK_OBJECT (Message), "lblTyping", lblTyping,
                            (GtkDestroyNotify) gtk_widget_unref);
/*   gtk_widget_show (lblTyping); */
  gtk_box_pack_start (GTK_BOX (hboxTyping), lblTyping, TRUE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (lblTyping), 0, 0.5);
  gtk_widget_set_usize (lblTyping, -2, 20);
  free(label_text);
  
  txtSend = gtk_text_new (NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(txtSend), TRUE);
  gtk_widget_ref (txtSend);
  gtk_object_set_data_full (GTK_OBJECT (Message), "txtSend", txtSend,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (txtSend);
  gtk_table_attach (GTK_TABLE (table), txtSend, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (txtSend, -2, 35);
  gtk_widget_grab_focus(txtSend);

  img = gdk_imlib_create_image_from_drawable(skin->icon[SKIN_NO].pixmap, skin->icon[SKIN_NO].mask, 0, 0, 75, 90);
  gdk_imlib_render(img, 50, 60);
  pxmp = gdk_imlib_move_image(img);
  mask = gdk_imlib_move_mask(img);
  
  pixmap = gtk_pixmap_new (pxmp, mask);
  gtk_widget_ref (pixmap);
  gtk_object_set_data_full (GTK_OBJECT (Message), "pixmap", pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap);
  gtk_table_attach (GTK_TABLE (table), pixmap, 1, 2, 0, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (pixmap, 50, 60);

  gdk_imlib_free_colors();
  gdk_imlib_free_pixmap(pxmp);
  gdk_imlib_free_bitmap(mask);
  gdk_imlib_kill_image(img);

  /* callbacks */
  gtk_signal_connect (GTK_OBJECT(Message), "key-press-event",
		      GTK_SIGNAL_FUNC(on_Message_key_press), message);
  gtk_signal_connect_after (GTK_OBJECT(Message), "key-press-event",
			    GTK_SIGNAL_FUNC(on_Message_typing), message);
  
  gtk_signal_connect (GTK_OBJECT (Message), "show",
                      GTK_SIGNAL_FUNC (on_Message_show),
                      message);
  gtk_signal_connect (GTK_OBJECT (Message), "hide",
                      GTK_SIGNAL_FUNC (on_Message_hide),
                      message);
  gtk_signal_connect (GTK_OBJECT (Message), "delete_event",
                      GTK_SIGNAL_FUNC (on_Message_delete_event),
                      message);
  gtk_signal_connect (GTK_OBJECT(Message), "destroy",
		      GTK_SIGNAL_FUNC(on_Message_destroy), message);

  GTK_SCROLLED_WINDOW_CLASS(GTK_OBJECT(scrolledwindow)->klass)->scrollbar_spacing = 0;

  if (!message->log.pict)
    {
      gtk_widget_hide(gtk_object_get_data(GTK_OBJECT(Message), "btnCollapse"));
      gtk_widget_hide(pixmap);
    }
  else
    gtk_widget_hide(gtk_object_get_data(GTK_OBJECT(Message), "btnExpand"));
  return Message;
}

void	message_free(message_t *message)
{
  free(message->login);
  free(message->alias);
  listFree(message->log.history, free);
  free(message);
}

int	message_cmp(message_t *message, GtkWidget *widget)
{
  return (!(widget == message->window));
}

void		message_insert_out(message_t *message, const char *text)
{
  GtkWidget	*txtConveration;
  char		*inserted_text;

  txtConveration = gtk_object_get_data(GTK_OBJECT(message->window), "txtConversation");
  inserted_text = message_insert_conv(txtConveration, conf->login, text, conf->login_color);
  putinlist(&message->log.history, inserted_text);
}

void		message_insert_in(message_t *message, const char *text)
{
  GtkWidget	*txtConveration;
  char		*inserted_text;

  txtConveration = gtk_object_get_data(GTK_OBJECT(message->window), "txtConversation");
  inserted_text = message_insert_conv(txtConveration, message->alias, text, conf->contact_color);
  putinlist(&message->log.history, inserted_text);
  gtk_widget_show(message->window);
}

void		message_insert_history(message_t *message, const char *text)
{
  GtkWidget	*txtConveration;
  GdkColor	color;

  txtConveration = gtk_object_get_data(GTK_OBJECT(message->window), "txtConversation");
  utils_scolor_to_pixel(&color, conf->history_color);
  gtk_text_insert(GTK_TEXT(txtConveration), NULL, &color, NULL, text, strlen(text));
  gtk_text_insert(GTK_TEXT(txtConveration), NULL, &color, NULL, "\n", 1);
}

int		message_insert_auto_answer(message_t *message, const char *text)
{
  GtkWidget	*txtConveration;
  GdkColor	color;
  char		*str = NULL;
  char		*timestamp;

  if (message->auto_answered == TRUE)
    return (FALSE);
  txtConveration = gtk_object_get_data(GTK_OBJECT(message->window), "txtConversation");
  timestamp = utils_maketimeformat(time(NULL) + netsoul->time[TIME_DECAL]);
  asprintf(&str, "%s*** Auto-response sent to %s : %s\n", timestamp, message->alias, text);
  utils_scolor_to_pixel(&color, "#FF0000");
  gtk_text_insert(GTK_TEXT(txtConveration), NULL, &color, NULL, str, strlen(str));
  free(str);
  free(timestamp);
  message->auto_answered = TRUE;
  asprintf(&str, "*** [Auto-response] %s", text);  
  request_cmd_msg(message->login, str, message->id);
  free(str);
  return (TRUE);
}

char	*message_insert_conv(GtkWidget *txtConveration, char *login, 
			     const char *text, const char *fore)
{
  char		*timestamp;
  char		*str = NULL;
  char		*inserted_text = NULL;
  GdkColor	color;

  timestamp = utils_maketimeformat(time(NULL) + netsoul->time[TIME_DECAL]);
  asprintf(&str, "%s%.8s : ", timestamp, login);
  utils_scolor_to_pixel(&color, fore);
  gtk_text_insert(GTK_TEXT(txtConveration), NULL, &color, NULL, str, strlen(str));
  utils_scolor_to_pixel(&color, conf->text_color);
  gtk_text_insert(GTK_TEXT(txtConveration), NULL, &color, NULL, text, strlen(text));
  gtk_text_insert(GTK_TEXT(txtConveration), NULL, &color, NULL, "\n", 1);
  asprintf(&inserted_text, "%s%s", str, text);
  free(str);
  free(timestamp);
  return (inserted_text);
}

void		message_information(message_t *message, const char *text)
{
  char		*timestamp;
  char		*str = NULL;
  GdkColor	color;
  GtkWidget	*txtConveration;

  txtConveration = gtk_object_get_data(GTK_OBJECT(message->window), "txtConversation");
  timestamp = utils_maketimeformat(time(NULL) + netsoul->time[TIME_DECAL]);
  asprintf(&str, "%s*** %s\n", timestamp, text);
  utils_scolor_to_pixel(&color, "#FF0000");
  gtk_text_insert(GTK_TEXT(txtConveration), NULL, &color, NULL, str, strlen(str));
  free(str);
  free(timestamp);
}

void		message_broadcast(char *login, const char *text)
{
  list_t	*list;
  message_t	*tmp;

  list = message_list;
  while (list)
    {
      tmp = (message_t *)list->data;
      if (!strcmp(tmp->login, login))
	message_information(tmp, text);
      list = list->next;
    }
}

message_t	*message_find(char *login)
{
  list_t	*list;
  message_t	*tmp;

  list = message_list;
  while (list)
    {
      tmp = (message_t *)list->data;
      if (tmp->id == -1 && !strcmp(tmp->login, login))
	return (tmp);
      list = list->next;
    }
  return (NULL);
}

message_t	*message_find_by_id(int id)
{
  list_t	*list;
  message_t	*tmp;

  list = message_list;
  while (list)
    {
      tmp = (message_t *)list->data;
      if (tmp->id == id)
	return (tmp);
      list = list->next;
    }
  return (NULL);
}

void		message_list_reset_info(list_t *buddy_list)
{
  list_t	*list;
  message_t	*message;

  list = message_list;
  while (list)
    {
      message = (message_t *)list->data;
      if (message->info != NULL && listFind(buddy_list, message->login, strcmp))
	message->info = NULL;
      list = list->next;
    }
}

void		message_typing(message_t *message, char state)
{
  GtkWidget	*lblTyping;

  lblTyping = gtk_object_get_data(GTK_OBJECT(message->window), "lblTyping");
  if (state)
    gtk_widget_show(lblTyping);
  else
    gtk_widget_hide(lblTyping);
}
