/*
** menu.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Thu Jul 31 08:04:27 2003 Anto
** Last update Thu Dec 11 14:05:54 2003 Anto
*/

#include "menu.h"
#include "skin.h"
#include "utils.h"
#include <stdio.h>

static void	menu_draw(GtkWidget *, GdkRectangle *);
static void	menu_item_draw(GtkWidget *, GdkRectangle *);
static gboolean	menu_item_expose(GtkWidget *, GdkEventExpose *);
static gboolean	menu_expose(GtkWidget *, GdkEventExpose *);
static void	menu_activate(GtkMenuItem *, gpointer);

void	menu_hide(GtkWidget *widget, GtkWidget *menu)
{
  GdkRectangle area;

  area.x = menu->allocation.x;
  area.y = menu->allocation.y;
  area.width = menu->allocation.width;
  area.height = menu->allocation.height;
  menu_draw(menu, &area);
}

GtkWidget	*menu_new(menu_t *menu_def)
{
  GtkWidget	*menu;
  GtkWidget	*item;
  GtkWidget	*icon;
  GtkWidget	*label;
  GtkWidget	*hbox;
  int		i;

  menu = gtk_menu_new();
  for (i = 0; menu_def[i].type != MENU_TYPE_END; i++)
    {
      if (menu_def[i].type == MENU_TYPE_SEPARATOR)
	{
	  item = gtk_menu_item_new();
	  gtk_widget_set_usize(item, -2, 3);
	  ((GtkWidgetClass *)GTK_OBJECT(item)->klass)->draw = menu_item_draw;
	  ((GtkWidgetClass *)GTK_OBJECT(item)->klass)->expose_event = menu_item_expose;
	}
      else
	{
	  item = gtk_menu_item_new();
	  hbox = gtk_hbox_new(FALSE, 12);
	  label = gtk_label_new(menu_def[i].name);
	  if (menu_def[i].icon_id == MENU_NO_ICON)
	    icon = gtk_label_new("");
	  else
	    icon = gtk_pixmap_new(skin->icon[menu_def[i].icon_id].pixmap, 
				  skin->icon[menu_def[i].icon_id].mask);
	  gtk_widget_set_usize(icon, 16, 18);
	  gtk_box_pack_start(GTK_BOX(hbox), icon, FALSE, TRUE, 0);
	  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
	  gtk_container_add(GTK_CONTAINER(item), hbox);
	  ((GtkWidgetClass *)GTK_OBJECT(item)->klass)->draw = menu_item_draw;
	  ((GtkWidgetClass *)GTK_OBJECT(item)->klass)->expose_event = menu_item_expose;
	  gtk_object_set_data(GTK_OBJECT(item), "type", (gpointer)menu_def[i].type);
	  if (menu_def[i].type == MENU_TYPE_CHECK || menu_def[i].type == MENU_TYPE_RADIO)
	    {
	      gtk_signal_connect(GTK_OBJECT(item), "activate", 
				 GTK_SIGNAL_FUNC(menu_activate), menu);
	      gtk_object_set_data(GTK_OBJECT(item), "state", (gpointer)FALSE);
	    }
	  if (menu_def[i].submenu)
	    menu_set_submenu(menu, item, menu_new(menu_def[i].submenu));
	}
      if (menu_def[i].callback != NULL)
	gtk_signal_connect(GTK_OBJECT(item), "activate",
			   GTK_SIGNAL_FUNC(menu_def[i].callback), (gpointer)menu_def[i].user_data);
      gtk_container_add(GTK_CONTAINER(menu), item);
      gtk_object_set_data(GTK_OBJECT(menu), menu_def[i].name, item);
    }
  gtk_widget_realize(menu);
  gtk_widget_show_all(menu);
  utils_setBackground(GTK_WIDGET(GTK_MENU_SHELL(menu)), 0xFCFCFB);
  ((GtkWidgetClass *)GTK_OBJECT(menu)->klass)->draw = menu_draw;
  ((GtkWidgetClass *)GTK_OBJECT(menu)->klass)->expose_event = menu_expose;
  return (menu);
}

void	menu_set_submenu(GtkWidget *menu, GtkWidget *item, GtkWidget *submenu)
{
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), submenu);
  gtk_signal_connect(GTK_OBJECT(submenu), "hide",
		     GTK_SIGNAL_FUNC(menu_hide), (gpointer)menu);
}

static void	menu_draw(GtkWidget *widget, GdkRectangle *area)
{
  GtkMenuShell	*menu_shell;
  GtkWidget	*child;
  GdkRectangle	child_area;
  GList		*children;
  GdkGC		*gc;
  
  if (!GTK_WIDGET_DRAWABLE(widget))
    return ;
  gc = gdk_gc_new(widget->window);
  gdk_gc_set_clip_rectangle(gc, area);
  gdk_gc_set_line_attributes(gc, 1, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_ROUND);
  /* draw menu */
  gdk_rgb_gc_set_foreground(gc, 0x000000);
  gdk_draw_rectangle(widget->window, gc, FALSE, 0, 0, area->width - 1, area->height - 1);
  gdk_rgb_gc_set_foreground(gc, 0xEDEDF0);
  gdk_draw_rectangle(widget->window, gc, TRUE, 1, 1, area->width - 2, area->height - 2);
  gdk_gc_set_clip_rectangle(gc, NULL);
  gdk_gc_destroy(gc);
  /* draw childs */
  menu_shell = GTK_MENU_SHELL(widget);
  children = menu_shell->children;
  while (children)
    {
      child = children->data;
      children = children->next;
      if (gtk_widget_intersect(child, area, &child_area))
	gtk_widget_draw(child, &child_area);
    }
}

static void	menu_item_draw(GtkWidget *widget, GdkRectangle *area)
{
  int		type;
  GdkGC		*gc;
  GdkRectangle	child_area;    
  
  if (!GTK_WIDGET_DRAWABLE(widget))
    return ;
  type = (int)gtk_object_get_data(GTK_OBJECT(widget), "type");
  gc = gdk_gc_new(widget->window);
  gdk_gc_set_clip_rectangle(gc, area);
  gdk_gc_set_line_attributes(gc, 1, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_ROUND);
  if (GTK_WIDGET_STATE(widget) == GTK_STATE_PRELIGHT && GTK_BIN(widget)->child)
    {
      gdk_rgb_gc_set_foreground(gc, 0x728FBE);
      gdk_draw_rectangle(widget->window, gc, FALSE, 0, 0, area->width - 1, area->height - 1);
      gdk_rgb_gc_set_foreground(gc, 0xCAD3E4);
      gdk_draw_rectangle(widget->window, gc, TRUE, 1, 1, area->width - 2, area->height - 2);
    }
  else
    {
      gdk_window_clear_area(widget->window, area->x, area->y, area->width, area->height);
      gdk_rgb_gc_set_foreground(gc, 0xEEEEE8);
      gdk_draw_rectangle(widget->window, gc, TRUE, 0, 0, 25, area->height);
      if (!GTK_BIN(widget)->child)
	{
	  gdk_rgb_gc_set_foreground(gc, 0x939393);
	  gdk_draw_line(widget->window, gc, 33, 1, area->width - 8, 1);
	}
    }
  if (GTK_MENU_ITEM(widget)->submenu && GTK_MENU_ITEM(widget)->show_submenu_indicator)
    {
      GdkPoint	points[3];
      
      gdk_rgb_gc_set_foreground(gc, 0x000000);
      points[0].x = area->width - 10;
      points[0].y = area->height / 2 - 5;
      points[1].x = area->width - 5;
      points[1].y = area->height / 2;
      points[2].x = area->width - 10;
      points[2].y = area->height / 2 + 5;
      gdk_draw_polygon(widget->window, gc, TRUE, points, 3);
    }
  if (type == MENU_TYPE_CHECK || type == MENU_TYPE_RADIO)
    {
      int	state;

      state = (int)gtk_object_get_data(GTK_OBJECT(widget), "state");
      if (state == TRUE)
	{
	  GdkPoint	points[3];
	  
	  gdk_rgb_gc_set_foreground(gc, 0x000000);
	  points[0].x = 10;
	  points[0].y = area->height / 2 - 5;
	  points[1].x = 15;
	  points[1].y = area->height / 2;
	  points[2].x = 10;
	  points[2].y = area->height / 2 + 5;
	  gdk_draw_polygon(widget->window, gc, TRUE, points, 3);
	}
    }
  gdk_gc_set_clip_rectangle(gc, NULL);
  if (GTK_BIN(widget)->child)
    if (gtk_widget_intersect(GTK_BIN(widget)->child, area, &child_area))
      gtk_widget_draw(GTK_BIN(widget)->child, &child_area);
  gdk_gc_destroy(gc);
}

static gboolean		menu_expose(GtkWidget *widget, GdkEventExpose *event)
{
  if (GTK_WIDGET_DRAWABLE(widget))
    menu_draw(widget, &event->area);
  return (FALSE);
}

static gboolean	menu_item_expose(GtkWidget *widget, GdkEventExpose *event)
{
  if (GTK_WIDGET_DRAWABLE(widget))
    menu_item_draw(widget, &event->area);
  return (FALSE);
}

gboolean	menu_show(GtkWidget *w,
			  GdkEventButton *event,
			  GtkWidget *menu)
{
  if (event->button == 3)
    {
      gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
		     event->button, event->time);
      gtk_object_set_data(GTK_OBJECT(menu), "widget_menued", w);
      gtk_signal_emit_stop_by_name(GTK_OBJECT(w), "button_press_event");
    }
  return (gtk_true());
}

static void	menu_activate(GtkMenuItem *item, gpointer user_data)
{
  int		state;
  int		type;

  type = (int)gtk_object_get_data(GTK_OBJECT(item), "type");
  state = (int)gtk_object_get_data(GTK_OBJECT(item), "state");
  gtk_object_set_data(GTK_OBJECT(item), "state", (gpointer)!state);
  if (type == MENU_TYPE_RADIO)
    {
      GtkWidget	*menu;
      GList	*children;
      
      menu = (GtkWidget *)user_data;
      children = gtk_container_children(GTK_CONTAINER(menu));
      while (children)
	{
	  if (GTK_MENU_ITEM(children->data) != item)
	    gtk_object_set_data(GTK_OBJECT(children->data), "state", (gpointer)FALSE);
	  children = children->next;
	}
    }
}
