/*
** control_panel_callback.c for  in /home/dev/xml
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 03:55:43 2003 Anto
** Last update Fri Mar 12 10:15:52 2004 Anto
*/

#include <gtk/gtk.h>
#include "control_panel.h"
#include "skin.h"
#include "utils.h"
#include "env.h"
#include "netsoul.h"
#include "request.h"
#include "list.h"
#include "message.h"
#include "NoSoucy.h"
#include <stdlib.h>
#include <string.h>

static char	buddy_edited = FALSE;
static char	answer_edited = FALSE;

void		on_button_move_up_clicked(GtkButton *button, gpointer user_data)
{
  GtkWidget	*wlst;
  GList		*sel = NULL;
  int		pos;
  
  wlst = gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_contact_list");
  if (!GTK_LIST(wlst)->selection)
    return ;
  if (!(pos = g_list_index(GTK_LIST(wlst)->children, GTK_LIST(wlst)->selection->data)))
    return ;
  sel = g_list_append(sel, GTK_LIST(wlst)->selection->data);
  gtk_list_remove_items_no_unref(GTK_LIST(wlst), sel);
  gtk_list_insert_items(GTK_LIST(wlst), sel, pos - 1);
  gtk_list_select_item(GTK_LIST(wlst), pos - 1);
  buddy_edited = TRUE;
}

void		on_button_move_down_clicked(GtkButton *button, gpointer user_data)
{
  GtkWidget	*wlst;
  GList		*sel = NULL;
  int		pos;
  
  wlst = gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_contact_list");
  if (!GTK_LIST(wlst)->selection)
    return ;
  pos = g_list_index(GTK_LIST(wlst)->children, GTK_LIST(wlst)->selection->data);
  if (pos == g_list_length(GTK_LIST(wlst)->children) - 1)
    return ;
  sel = g_list_append(sel, GTK_LIST(wlst)->selection->data);
  gtk_list_remove_items_no_unref(GTK_LIST(wlst), sel);
  gtk_list_insert_items(GTK_LIST(wlst), sel, pos + 1);
  gtk_list_select_item(GTK_LIST(wlst), pos + 1);
  buddy_edited = TRUE;
}

static void	insert_in_contact_list(char *label, gpointer type, gpointer data)
{
  GtkWidget	*wlst;
  GtkWidget	*item;
  GList		*list = NULL;
  int		pos;
  
  wlst = gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_contact_list");
  if (GTK_LIST(wlst)->selection)
    pos = g_list_index(GTK_LIST(wlst)->children, GTK_LIST(wlst)->selection->data);
  else
    pos = g_list_length(GTK_LIST(wlst)->children);
  list = g_list_prepend(list, item = gtk_list_item_new_with_label(label));
  if (type == TYPE_GROUP)
    gtk_widget_set_name(GTK_LIST_ITEM(item)->item.bin.child, skin->group.name);
  gtk_list_insert_items(GTK_LIST(wlst), list, pos);
  gtk_object_set_data(GTK_OBJECT(item), "type", type);
  gtk_object_set_data(GTK_OBJECT(item), "data", data);
  gtk_signal_connect(GTK_OBJECT(item), "button_press_event", GTK_SIGNAL_FUNC(on_list_contact_list_button_press_event), NULL);
  gtk_widget_show_all(item);
  gtk_list_select_item(GTK_LIST(wlst), pos);
  buddy_edited = TRUE;
}

void		on_button_new_group_clicked(GtkButton *button, gpointer user_data)
{
  group_t	*grp;
  
  if ((grp = ControlPanel_UINewGroup()))
    {
      insert_in_contact_list(grp->name, TYPE_GROUP, grp);
      buddy_edited = TRUE;
    }
}

void		on_button_new_contact_clicked(GtkButton *button, gpointer user_data)
{
  buddy_t	*bdy;

  if ((bdy = ControlPanel_UINewBuddy()))
    {
      insert_in_contact_list(bdy->login, TYPE_BUDDY, bdy);
      buddy_edited = TRUE;
    }
}

void		on_button_edit_contact_clicked(GtkButton *button, gpointer user_data)
{
  GtkWidget	*wlst;
  
  wlst = gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_contact_list");
  if (GTK_LIST(wlst)->selection)
    {
      gpointer	type;

      type = gtk_object_get_data(GTK_OBJECT(GTK_LIST(wlst)->selection->data), "type");
      if (type == TYPE_GROUP)
	{
	  group_t	*grp;

	  grp = gtk_object_get_data(GTK_OBJECT(GTK_LIST(wlst)->selection->data), "data");
	  if (ControlPanel_UIEditGroup(grp))
	    {
	      gtk_label_set_text(GTK_LABEL(GTK_LIST_ITEM(GTK_LIST(wlst)->selection->data)->item.bin.child), grp->name);
	      buddy_edited = TRUE;
	    }
	}
      else if (type == TYPE_BUDDY)
	{
	  buddy_t	*bdy;

	  bdy = gtk_object_get_data(GTK_OBJECT(GTK_LIST(wlst)->selection->data), "data");
	  if (ControlPanel_UIEditBuddy(bdy))
	    {
	      gtk_label_set_text(GTK_LABEL(GTK_LIST_ITEM(GTK_LIST(wlst)->selection->data)->item.bin.child), bdy->login);
	      buddy_edited = TRUE;
	    }
	}
    }  
}

void		on_button_remove_contact_clicked(GtkButton *button, gpointer user_data)
{
  int		pos;
  GtkWidget	*wlst;
  GList		*list = NULL;
  
  wlst = gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_contact_list");
  if (GTK_LIST(wlst)->selection)
    {
      list = g_list_append(list, GTK_LIST(wlst)->selection->data);
      pos = g_list_index(GTK_LIST(wlst)->children, GTK_LIST(wlst)->selection->data);
      gtk_list_remove_items(GTK_LIST(wlst), list);
      gtk_list_select_item(GTK_LIST(wlst), pos);
      buddy_edited = TRUE;
    }
}

void		on_button_remove_auto_answer_clicked(GtkButton *button, gpointer user_data)
{
  int		pos;
  GtkWidget	*wlst;
  GList		*list = NULL;
  
  wlst = gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_auto_answer");
  if (GTK_LIST(wlst)->selection)
    {
      list = g_list_append(list, GTK_LIST(wlst)->selection->data);
      pos = g_list_index(GTK_LIST(wlst)->children, GTK_LIST(wlst)->selection->data);
      gtk_list_remove_items(GTK_LIST(wlst), list);
      gtk_list_select_item(GTK_LIST(wlst), pos);
    }
  answer_edited = TRUE;
}

void		on_button_add_auto_answer_clicked(GtkButton *button, gpointer user_data)
{
  GtkWidget	*text;
  GtkWidget	*item;
  char		*msg;
  GList		*list = NULL;
  
  text = gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_auto_answer");
  msg = gtk_entry_get_text(GTK_ENTRY(text));
  if (!msg[0])
    return ;
  list = g_list_prepend(list, item = gtk_list_item_new_with_label(msg));
  gtk_list_append_items(GTK_LIST(gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_auto_answer")), list);
  gtk_widget_show_all(item);
  gtk_entry_set_text(GTK_ENTRY(text), "");
  answer_edited = TRUE;
}

void		on_button_ignore_add_clicked(GtkButton *button, gpointer user_data)
{
  GtkWidget	*text;
  GtkWidget	*item;
  char		*login;
  GList		*list = NULL;
  
  text = gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_ignore_login");
  login = gtk_entry_get_text(GTK_ENTRY(text));
  if (!login[0])
    return ;
  list = g_list_prepend(list, item = gtk_list_item_new_with_label(login));
  gtk_list_append_items(GTK_LIST(gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_ignore")), list);
  gtk_widget_show_all(item);
  gtk_entry_set_text(GTK_ENTRY(text), "");
}

void		on_button_ignore_remove_clicked(GtkButton *button, gpointer user_data)
{
  int		pos;
  GtkWidget	*wlst;
  GList		*list = NULL;
  
  wlst = gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_ignore");
  if (GTK_LIST(wlst)->selection)
    {
      list = g_list_append(list, GTK_LIST(wlst)->selection->data);
      pos = g_list_index(GTK_LIST(wlst)->children, GTK_LIST(wlst)->selection->data);
      gtk_list_remove_items(GTK_LIST(wlst), list);
      gtk_list_select_item(GTK_LIST(wlst), pos);
    }
}

void	on_btn_cancel_clicked(GtkButton *button, gpointer user_data)
{
/*   ControlPanel_UIHide(); */
  answer_edited = buddy_edited = FALSE;
  gtk_widget_destroy(Control_Panel);
}

void		on_btn_ok_clicked(GtkButton *button, gpointer user_data)
{
  list_t	*buddy;
  list_t	*buddy_save;
  list_t	*group_save;
  int		auto_answer;
  GtkWidget	*pixmap;
  GtkWidget	*pixmap_offline;
  char		default_message;

  auto_answer = conf->auto_answer;
  default_message = conf->default_message;
  if (buddy_edited)
    {
      contacts_UIEmptyList(conf->buddy, conf->group);
      for (buddy = conf->buddy; buddy; buddy = buddy->next)
	listRemoveItemCmp(&netsoul->watchlog, ((buddy_t *)buddy->data)->login, strcmp, free);
      message_list_reset_info(conf->buddy);
    }
  else
    {
      buddy_save = conf->buddy;
      group_save = conf->group;
    }
  confFree(conf, buddy_edited);
  conf = ControlPanel_saveConf(buddy_edited);
  if (!buddy_edited)
    {
      conf->buddy = buddy_save;
      conf->group = group_save;
    }
  confSaveDoc(env->conf);
  if (buddy_edited)
    {
      contacts_UIFillList(conf->group, conf->buddy);
      buddy = contactsMakeBuddyList(conf->buddy);
      request_cmd_who_list(buddy);
      listFree(buddy, free);
      for (buddy = conf->buddy; buddy; buddy = buddy->next)
	putinlist(&netsoul->watchlog, strdup(((buddy_t *)buddy->data)->login));
      request_watch_log(netsoul->watchlog);
    }
  conf->default_message = default_message;
  if (answer_edited || conf->auto_answer != auto_answer)
    NoSoucy_UIMenuAutoAnswer(conf->answer);
  contacts_UISetMenuContactOption(TRUE);
  answer_edited = buddy_edited = FALSE;
  for (buddy = conf->buddy; buddy; buddy = buddy->next)
    {
      pixmap = gtk_object_get_data(GTK_OBJECT(((buddy_t *)buddy->data)->item), "alert");
      pixmap_offline = gtk_object_get_data(GTK_OBJECT(((buddy_t *)buddy->data)->offline), "alert");
      if (((buddy_t *)buddy->data)->alerte)
	{
	  gtk_widget_show(pixmap);
	  gtk_widget_show(pixmap_offline);
	}
      else
	{
	  gtk_widget_hide(pixmap);
	  gtk_widget_hide(pixmap_offline);
	}	
      pixmap = gtk_object_get_data(GTK_OBJECT(((buddy_t *)buddy->data)->item), "block");
      pixmap_offline = gtk_object_get_data(GTK_OBJECT(((buddy_t *)buddy->data)->offline), "block");
      if (listFind(conf->ignore, ((buddy_t *)buddy->data)->login, strcmp))
	{
	  gtk_widget_show(pixmap);
	  gtk_widget_show(pixmap_offline);
	}
      else
	{
	  gtk_widget_hide(pixmap);
	  gtk_widget_hide(pixmap_offline);
	}	
    }
  gtk_widget_destroy(Control_Panel);
}

void	on_button_ok_clicked(GtkButton *button, gpointer dialog)
{
  quit_modal = BUTTON_OK;
}

void	on_button_cancel_clicked(GtkButton *button, gpointer dialog)
{
  quit_modal = BUTTON_CANCEL;
}

void	on_Add_Contact_destroy(GtkObject *object, gpointer user_data)
{
  quit_modal = BUTTON_CANCEL;
  Add_Contact = NULL;
}

void	on_Add_Group_destroy(GtkObject *object, gpointer user_data)
{
  quit_modal = BUTTON_CANCEL;
  Add_Group = NULL;
}

void	on_Control_Panel_destroy(GtkObject *object, gpointer user_data)
{
  Control_Panel = NULL;
  answer_edited = buddy_edited = FALSE;  
}

gboolean	on_list_contact_list_button_press_event(GtkWidget *widget, 
							GdkEventButton  *event, 
							gpointer user_data)
{
  if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
    {
      gtk_list_select_child(GTK_LIST(gtk_object_get_data(GTK_OBJECT(Control_Panel),
							 "list_contact_list")),
			    widget);
      on_button_edit_contact_clicked(NULL, NULL);
    }
  return (gtk_true());
}

