/*
** NoSoucy_ui.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Mon May 19 07:45:03 2003 Anto
** Last update Sun Jan  4 21:49:26 2004 Anto
*/

#include "NoSoucy.h"
#include "netsoul.h"
#include "contacts.h"
#include "conf.h"
#include "skin.h"
#include "menu.h"
#include "log.h"
#include "utils.h"
#include "skinedvbox.h"
#include "skinedvscrollbar.h"
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <gdk/gdkprivate.h>

static GtkWidget	*NoSoucyUI = NULL;
static GtkWidget	*create_NoSoucyUI(void);
static GtkStyleClass	default_class;
static log_t		*log_window = NULL;

static menu_t	main_menu[] = 
  {
    {MENU_TYPE_BUTTON, NOSOUCY_MENU_CONNECT, SKIN_CONNECT, on_NoSoucy_menu_connect, NULL, NULL},
    {MENU_TYPE_BUTTON, NOSOUCY_MENU_DISCONNECT, SKIN_DISCONNECT, on_NoSoucy_menu_disconnect, NULL, NULL},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, NOSOUCY_MENU_ACTIF, SKIN_ONLINE, on_NoSoucy_menu_state, SKIN_ACTIF_TOKEN, NULL},
    {MENU_TYPE_BUTTON, NOSOUCY_MENU_AWAY, SKIN_AWAY, on_NoSoucy_menu_state, SKIN_AWAY_TOKEN, NULL},
    {MENU_TYPE_BUTTON, NOSOUCY_MENU_LOCK, SKIN_LOCK, on_NoSoucy_menu_state, SKIN_LOCK_TOKEN, NULL},
    {MENU_TYPE_BUTTON, NOSOUCY_MENU_IDLE, SKIN_IDLE, on_NoSoucy_menu_state, SKIN_IDLE_TOKEN, NULL},
    {MENU_TYPE_BUTTON, NOSOUCY_MENU_AUTO_ANSWER, MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, NOSOUCY_MENU_EXIT, MENU_NO_ICON, on_NoSoucy_menu_exit, NULL, NULL},
    MENU_END_ITEM
  };

void		NoSoucy_UI()
{
  GtkWidget	*menu;
  GtkWidget	*viewport;
  GtkStyle	*style;

  create_NoSoucyUI();
  viewport = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "viewport");
  contacts_UI(viewport);
  gtk_window_set_title(GTK_WINDOW(NoSoucyUI), NOSOUCY_VERSION);
  gtk_window_set_default_size(GTK_WINDOW(NoSoucyUI), conf->aspect_width, conf->aspect_height);
  menu = menu_new(main_menu);
  gtk_object_set_data(GTK_OBJECT(NoSoucyUI), "menu", menu);
  NoSoucy_UIMenuAutoAnswer(conf->answer);
  style = gtk_style_new();
  memcpy(&default_class, viewport->style->klass, sizeof(GtkStyleClass));
  style->klass = &default_class;
  style->klass->xthickness = 0;
  style->klass->ythickness = 0;
  gtk_style_ref(style);
  gtk_style_unref(viewport->style);
  gtk_widget_set_style(viewport, style);
  gtk_widget_show(NoSoucyUI);
  gdk_window_move(NoSoucyUI->window, conf->aspect_x, conf->aspect_y);
  gtk_widget_set_name(viewport, "NoSoucyBackground");
}

void		NoSoucy_UILog(const char *text)
{
  if (log_window && GTK_IS_WIDGET(log_window) && GTK_WIDGET_REALIZED(log_window))
    log_add(log_window, text);
}

GtkWidget	*NoSoucy_UIGet()
{
  return (NoSoucyUI);
}

void	NoSoucy_UIRemoveInput(gint tag)
{
  if (tag > 0)
    gdk_input_remove(tag);
}

int	NoSoucy_UIAddInput(gint source, GdkInputFunction function)
{
  return (gdk_input_add(source, GDK_INPUT_READ, function, NULL));
}

int	NoSoucy_UIAddTimer(gint32 timeout, GtkFunction function)
{
  return (gtk_timeout_add(timeout, function, NULL));
}

static GtkWidget	*create_NoSoucyUI (void)
{
  GtkWidget		*vbox;
  GtkWidget		*SpcTop;
  GtkWidget		*hbox1;
  GtkWidget		*SpcLeft;
  GtkWidget		*scrolledwindow;
  GtkWidget		*viewport;
  GtkWidget		*hbox2;
  GtkWidget		*evtState;
  GtkWidget		*xpmState;
  GtkWidget		*evtControlPanel;
  GtkWidget		*xpmControlPanel;
  GtkWidget		*evtMessage;
  GtkWidget		*xpmMessage;
  GtkWidget		*evtMail;
  GtkWidget		*xpmMail;
  GtkWidget		*SpcMiddle;
  GtkWidget		*evtLog;
  GtkWidget		*xpmLog;
  GtkTooltips		*tooltips;

  tooltips = gtk_tooltips_new ();

  NoSoucyUI = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (NoSoucyUI), "NoSoucyUI", NoSoucyUI);

  vbox = skined_vbox_new (FALSE, 0, NoSoucy_paint, NULL);
  gtk_widget_ref (vbox);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "vbox", vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (NoSoucyUI), vbox);

  SpcTop = gtk_label_new ("");
  gtk_widget_ref (SpcTop);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "SpcTop", SpcTop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SpcTop);
  gtk_box_pack_start (GTK_BOX (vbox), SpcTop, FALSE, FALSE, 0);
  gtk_widget_set_usize (SpcTop, -2, 5);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox), hbox1, TRUE, TRUE, 0);

  SpcLeft = gtk_label_new ("");
  gtk_widget_ref (SpcLeft);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "SpcLeft", SpcLeft,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SpcLeft);
  gtk_box_pack_start (GTK_BOX (hbox1), SpcLeft, FALSE, FALSE, 0);
  gtk_widget_set_usize (SpcLeft, 5, -2);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "scrolledwindow", scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (hbox1), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  GTK_SCROLLED_WINDOW(scrolledwindow)->vscrollbar = skined_vscrollbar_new();
  gtk_widget_set_parent(GTK_SCROLLED_WINDOW(scrolledwindow)->vscrollbar, scrolledwindow);
  gtk_widget_ref (GTK_SCROLLED_WINDOW(scrolledwindow)->vscrollbar);

  viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "viewport", viewport,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), viewport);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport), GTK_SHADOW_NONE);

  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox2), 5);

  evtState = gtk_event_box_new ();
  gtk_widget_ref (evtState);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "evtState", evtState,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (evtState);
  gtk_box_pack_start (GTK_BOX (hbox2), evtState, FALSE, FALSE, 0);
  gtk_widget_set_usize (evtState, 20, 20);

  xpmState = gtk_pixmap_new (skin->icon[SKIN_OFFLINE].pixmap, 
			     skin->icon[SKIN_OFFLINE].mask);
  gtk_widget_ref (xpmState);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "xpmState", xpmState,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xpmState);
  gtk_container_add (GTK_CONTAINER (evtState), xpmState);

  evtControlPanel = gtk_event_box_new ();
  gtk_widget_ref (evtControlPanel);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "evtControlPanel", evtControlPanel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (evtControlPanel);
  gtk_box_pack_start (GTK_BOX (hbox2), evtControlPanel, FALSE, FALSE, 0);
  gtk_widget_set_usize (evtControlPanel, 20, 20);

  xpmControlPanel = gtk_pixmap_new (skin->icon[SKIN_PREFERENCES].pixmap, skin->icon[SKIN_PREFERENCES].mask);
  gtk_widget_ref (xpmControlPanel);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "xpmControlPanel", xpmControlPanel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xpmControlPanel);
  gtk_container_add (GTK_CONTAINER (evtControlPanel), xpmControlPanel);

  evtMessage = gtk_event_box_new ();
  gtk_widget_ref (evtMessage);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "evtMessage", evtMessage,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (evtMessage);
  gtk_box_pack_start (GTK_BOX (hbox2), evtMessage, FALSE, FALSE, 0);
  gtk_widget_set_usize (evtMessage, 20, 20);

  xpmMessage = gtk_pixmap_new (skin->icon[SKIN_SEND_MESSAGE].pixmap, skin->icon[SKIN_SEND_MESSAGE].mask);
  gtk_widget_ref (xpmMessage);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "xpmMessage", xpmMessage,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xpmMessage);
  gtk_container_add (GTK_CONTAINER (evtMessage), xpmMessage);

  evtMail = gtk_event_box_new ();
  gtk_widget_ref (evtMail);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "evtMail", evtMail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (evtMail);
  gtk_box_pack_start (GTK_BOX (hbox2), evtMail, FALSE, FALSE, 0);
  gtk_widget_set_usize (evtMail, 20, 20);
  gtk_tooltips_set_tip (tooltips, evtMail, "No new mail", NULL);

  xpmMail = gtk_pixmap_new (skin->icon[SKIN_MAIL].pixmap, skin->icon[SKIN_MAIL].mask);
  gtk_widget_ref (xpmMail);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "xpmMail", xpmMail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xpmMail);
  gtk_container_add (GTK_CONTAINER (evtMail), xpmMail);

  SpcMiddle = gtk_label_new ("");
  gtk_widget_ref (SpcMiddle);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "SpcMiddle", SpcMiddle,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SpcMiddle);
  gtk_box_pack_start (GTK_BOX (hbox2), SpcMiddle, TRUE, FALSE, 0);

  evtLog = gtk_event_box_new ();
  gtk_widget_ref (evtLog);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "evtLog", evtLog,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (evtLog);
  gtk_box_pack_start (GTK_BOX (hbox2), evtLog, FALSE, FALSE, 0);
  gtk_widget_set_usize (evtLog, 20, 20);

  xpmLog = gtk_pixmap_new (skin->icon[SKIN_SHOW_LOG].pixmap, skin->icon[SKIN_SHOW_LOG].mask);
  gtk_widget_ref (xpmLog);
  gtk_object_set_data_full (GTK_OBJECT (NoSoucyUI), "xpmLog", xpmLog,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xpmLog);
  gtk_container_add (GTK_CONTAINER (evtLog), xpmLog);

  gtk_signal_connect (GTK_OBJECT (NoSoucyUI), "destroy",
                      GTK_SIGNAL_FUNC (on_NoSoucyUI_destroy_event),
                      NoSoucyUI);
  gtk_signal_connect (GTK_OBJECT (NoSoucyUI), "delete_event",
                      GTK_SIGNAL_FUNC (on_NoSoucyUI_delete_event),
                      NoSoucyUI);
  gtk_signal_connect (GTK_OBJECT (evtState), "button_press_event",
                      GTK_SIGNAL_FUNC (on_evtState_button_press_event),
                      NoSoucyUI);
  gtk_signal_connect (GTK_OBJECT (evtControlPanel), "button_press_event",
                      GTK_SIGNAL_FUNC (on_evtControlPanel_button_press_event),
                      NoSoucyUI);
  gtk_signal_connect (GTK_OBJECT (evtMessage), "button_press_event",
                      GTK_SIGNAL_FUNC (on_evtMessage_button_press_event),
                      NoSoucyUI);
  gtk_signal_connect (GTK_OBJECT (evtMail), "button_press_event",
                      GTK_SIGNAL_FUNC (on_evtMail_button_press_event),
                      NoSoucyUI);
  gtk_signal_connect (GTK_OBJECT (evtLog), "button_press_event",
                      GTK_SIGNAL_FUNC (on_evtLog_button_press_event),
                      &log_window);
  gtk_signal_connect_after (GTK_OBJECT (evtState), "draw",
			    GTK_SIGNAL_FUNC (on_NoSoucy_event_draw),
			    NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtState), "expose_event",
		      GTK_SIGNAL_FUNC (on_NoSoucy_event_expose_event),
		      NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtControlPanel), "draw",
			    GTK_SIGNAL_FUNC (on_NoSoucy_event_draw),
			    NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtControlPanel), "expose_event",
		      GTK_SIGNAL_FUNC (on_NoSoucy_event_expose_event),
		      NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtMail), "draw",
			    GTK_SIGNAL_FUNC (on_NoSoucy_event_draw),
			    NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtMail), "expose_event",
		      GTK_SIGNAL_FUNC (on_NoSoucy_event_expose_event),
		      NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtMessage), "draw",
			    GTK_SIGNAL_FUNC (on_NoSoucy_event_draw),
			    NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtMessage), "expose_event",
		      GTK_SIGNAL_FUNC (on_NoSoucy_event_expose_event),
		      NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtLog), "draw",
			    GTK_SIGNAL_FUNC (on_NoSoucy_event_draw),
			    NoSoucyUI);
  gtk_signal_connect_after (GTK_OBJECT (evtLog), "expose_event",
		      GTK_SIGNAL_FUNC (on_NoSoucy_event_expose_event),
		      NoSoucyUI);

  gtk_object_set_data(GTK_OBJECT(xpmMail), "timeout_id", (gpointer)-1);

  gtk_object_set_data (GTK_OBJECT (NoSoucyUI), "tooltips_mail", tooltips);

  GTK_SCROLLED_WINDOW_CLASS(GTK_OBJECT(scrolledwindow)->klass)->scrollbar_spacing = 0;

  return NoSoucyUI;
}

static gint	NoSoucy_UIMailTimeout(gpointer data)
{
  static int	state = 0;
  GtkWidget	*xpmMail;

  xpmMail = (GtkWidget *)data;
  state ^= 1;
  if (!state)
    gtk_pixmap_set(GTK_PIXMAP(xpmMail), 
		   skin->icon[SKIN_MAIL].pixmap,
		   skin->icon[SKIN_MAIL].mask);
  else
    gtk_pixmap_set(GTK_PIXMAP(xpmMail), 
		   skin->icon[SKIN_MAIL_ALERT].pixmap,
		   skin->icon[SKIN_MAIL_ALERT].mask);
  return (gtk_true());
}

void			NoSoucy_UIMailAlert(char *from, char *subject)
{
  GtkWidget		*xpmMail;
  GtkWidget		*evtMail;
  GtkTooltips		*tooltip;
  GtkTooltipsData	*tooltip_data;
  gint			timeout_id;  
  char			*tip;
  time_t		mail_time;

  tooltip = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "tooltips_mail");
  evtMail = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "evtMail");
  xpmMail = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "xpmMail");
  timeout_id = (gint)gtk_object_get_data(GTK_OBJECT(xpmMail), "timeout_id");
  tooltip_data = gtk_tooltips_data_get(evtMail);
  if (!strcmp(tooltip_data->tip_text, "No new mail"))
    tip = "";
  else
    tip = tooltip_data->tip_text;
  mail_time = time(NULL) + netsoul->time[TIME_DECAL];
  asprintf(&tip, "%s%sOn : %sFrom : %s\nSubject : %s\n", 
	   *tip ? tip : "", *tip ? "-------------------------------------\n" : "", 
	   ctime(&mail_time), 
	   from, subject);
  gtk_tooltips_set_tip(tooltip, evtMail, tip, NULL);
  free(tip);
  if (timeout_id == -1)
    {
      timeout_id = gtk_timeout_add(500, NoSoucy_UIMailTimeout, xpmMail);
      gtk_object_set_data(GTK_OBJECT(xpmMail), "timeout_id", (gpointer)timeout_id);
    }
}

void	NoSoucy_UISaveGeometry()
{
  if (conf->save_geometry)
    {
      conf->aspect_width = ((GdkWindowPrivate *)NoSoucyUI->window)->width;
      conf->aspect_height = ((GdkWindowPrivate *)NoSoucyUI->window)->height;
      conf->aspect_x = ((GdkWindowPrivate *)NoSoucyUI->window)->x;
      conf->aspect_y = ((GdkWindowPrivate *)NoSoucyUI->window)->y;
    }
}

void	NoSoucy_UISetState(char *state)
{
  GtkWidget	*pixmap;
  int		state_id;

  pixmap = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "xpmState");
  state_id = skinStateToId(state);
  gtk_pixmap_set(GTK_PIXMAP(pixmap), skin->icon[state_id].pixmap, skin->icon[state_id].mask);
}

void		NoSoucy_UIMenuAutoAnswer(list_t *answer)
{
  GtkWidget	*menu;
  GtkWidget	*item;
  GtkWidget	*submenu;
  int		size, i;
  menu_t	*answer_menu;
  menu_t	template = {MENU_TYPE_RADIO, NULL, MENU_NO_ICON, on_NoSoucy_menu_answer, NULL, NULL};

  menu = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "menu");
  item = gtk_object_get_data(GTK_OBJECT(menu), NOSOUCY_MENU_AUTO_ANSWER);
  size = listSize(answer);
  submenu = GTK_MENU_ITEM(item)->submenu;
  gtk_menu_item_remove_submenu(GTK_MENU_ITEM(item));
  if (submenu)
    gtk_widget_destroy(submenu);
  answer_menu = calloc(sizeof(menu_t), size + 3);
  for (i = 0; answer; i++)
    {
      memcpy(&answer_menu[i], &template, sizeof(menu_t));
      answer_menu[i].name = (char *)answer->data;
      answer_menu[i].user_data = (gpointer)i;
      answer = answer->next;
    }
  memcpy(&answer_menu[i], &template, sizeof(menu_t));
  answer_menu[i].type = MENU_TYPE_SEPARATOR;
  answer_menu[i].name = "-";
  memcpy(&answer_menu[i + 1], &template, sizeof(menu_t));
  answer_menu[i + 1].name = NOSOUCY_MENU_AUTO_ANSWER_NONE;
  answer_menu[i + 1].user_data = (gpointer)-1;
  memset(&answer_menu[i + 2], (int)NULL, sizeof(menu_t));
  menu_set_submenu(menu, item, submenu = menu_new(answer_menu));
  if (conf->auto_answer == FALSE || !size || conf->default_message == -1)
    gtk_menu_item_activate(GTK_MENU_ITEM(gtk_object_get_data(GTK_OBJECT(submenu), 
							     NOSOUCY_MENU_AUTO_ANSWER_NONE)));
  else if (size && conf->default_message < size)
    gtk_menu_item_activate(GTK_MENU_ITEM(gtk_object_get_data(GTK_OBJECT(submenu), 
							     answer_menu[(int)conf->default_message].name)));
  free(answer_menu);
}
