/*
** request.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Thu May 22 01:15:09 2003 Anto
** Last update Thu Apr 22 14:10:01 2004 Anto
*/

#include "request.h"
#include "netsoul.h"
#include "url.h"
#include "message.h"
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define CMD_TYPE(x, y)	((netsoul->type == NETSOUL_TYPE_INT) ? x : y)
#define VERIF_ARG(x)	(x ? x : "*")

static void	nswrite(const char *req)
{
  if (netsoul->type > NETSOUL_TYPE_DISC)
    {
      write(netsoul->output, req, strlen(req));
      netsoulLog("[Sent] : %s", req);
    }
}

static char	*listToStr(list_t *list)
{
  char		*tmp = NULL;
  char		*logins = NULL;
  
  while (list)
    {
      tmp = logins;
      asprintf(&logins, "%s%s%s",
	       !logins ? "" : logins, !logins ? "" : ",", (char *)list->data);
      if (tmp)
	free(tmp);
      list = list->next;
    }  
  return (logins);
}

void	request_cmd_who(char *login, char *host, int id)
{
  char	*req = NULL;
  
  if (id == -1)
    asprintf(&req, "%s {%s}\n", 
	     CMD_TYPE("cmd who", "list_users"),
	     VERIF_ARG(login));
  else
    asprintf(&req, "%s {:%d}\n", 
	     CMD_TYPE("cmd who", "list_users"), id);
  nswrite(req);
  free(req);
}

void	request_cmd_who_list(list_t *list)
{
  char	*req = NULL;
  char	*logins;

  logins = listToStr(list);
  asprintf(&req, "%s {%s}\n",
	   CMD_TYPE("cmd who", "list_users"), logins);
  nswrite(req);
  free(logins);
  free(req);
}

void	request_cmd_msg(char *login, char *msg, int id)
{
  char	*req = NULL;
  char	*txt_encoded;

  txt_encoded = url_encode(msg);
  if (id == -1)
    asprintf(&req, "%s msg_user {%s} msg %s\n",
	     CMD_TYPE("cmd", "user_cmd"), login, txt_encoded);
  else
    asprintf(&req, "%s msg_user {:%d} msg %s\n",
	     CMD_TYPE("cmd", "user_cmd"), id, txt_encoded);
  nswrite(req);
  free(txt_encoded);
  free(req);
}

void	request_cmd_user_data(char *user_data)
{
  char	*user_data_;
  char	*user_data_encoded;
  char	*req = NULL;

  asprintf(&user_data_, NOSOUCY_VERSION" [%s]", user_data);
  user_data_encoded = url_encode(user_data_);
  asprintf(&req, "%s user_data %s\n",
	   CMD_TYPE("cmd", "user_cmd"), user_data_encoded);
  nswrite(req);
  free(user_data_encoded);
  free(user_data_);
  free(req);
}

void	request_state(char *state, unsigned long state_time)
{
  char	*req = NULL;

  asprintf(&req, "state %s:%lu\n", state, state_time + netsoul->time[TIME_DECAL]);
  nswrite(req);
  free(req);  
}

void	request_watch_log(list_t *list)
{
  char	*req = NULL;
  char	*logins;

  logins = listToStr(list);
  asprintf(&req, "%s watch_log_user {%s}\n", 
	   CMD_TYPE("cmd", "user_cmd") , logins);
  nswrite(req);
  free(logins);
  free(req);
}

void		request_auth_ag()
{
  const char	*req = "auth_ag ext_user none none\n";

  nswrite(req);
}

void	request_user_log(char *login, char *pass,
			 char *location, char *user_data)
{
  char	*req = NULL;
  char	*enc_location;
  char	*full_user_data;
  char	*enc_user_data;
  
  asprintf(&full_user_data, NOSOUCY_VERSION" [%s]", user_data);
  enc_location = url_encode(location);
  enc_user_data = url_encode(full_user_data);
  asprintf(&req, "ext_user_log %s %s %s %s\n", login, pass, enc_location, enc_user_data);
  nswrite(req);
  free(enc_location);
  free(enc_user_data);
  free(full_user_data);
  free(req);
}

int	request_ping(void *data)
{
  if (netsoul->type <= NETSOUL_TYPE_DISC || netsoul->sock == -1)
    return (FALSE);
  nswrite(CMD_TYPE("cmd ping\n", "ping\n"));
  return (TRUE);
}

void	request_cmd_typing(char *login, const char *state, int id)
{
  char	*req = NULL;

  if (id == -1)
    asprintf(&req, "%s msg_user {%s} typing_%s\n",
	     CMD_TYPE("cmd", "user_cmd"), login, state);
  else
    asprintf(&req, "%s msg_user {:%d} typing_%s\n",
	     CMD_TYPE("cmd", "user_cmd"), id, state);
  nswrite(req);
  free(req);
}
