/*
** update.c for  in /home/dev/NoSoucy-0.3b
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun Jan  4 14:39:01 2004 Anto
** Last update Sun Jan  4 17:40:21 2004 Anto
*/

#include "update.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include "netsoul.h"
#include <gtk/gtk.h>

static int		update_connect()
{
  struct sockaddr_in	addr;
  struct hostent	*ipserv;
  int			sock;
  char			*req;

  addr.sin_family = PF_INET;
  addr.sin_port = htons(80);
  if (!(ipserv = gethostbyname("etud.epita.fr")))
    return (-1);
  addr.sin_addr.s_addr = 
    inet_addr(inet_ntoa(*((struct in_addr *)ipserv->h_addr)));
  if ((sock = socket(PF_INET, SOCK_STREAM, 0)) == -1)
    return (-1);
  if (connect(sock, (const struct sockaddr *)&addr,
	      sizeof (struct sockaddr)) == -1)
    return (-1);
  asprintf(&req, "GET /~herrer_a/NoSoucy/VERSION HTTP/1.0\n\n");
  write(sock, req, strlen(req));
  free(req);
  return (sock);
}

static char	*update_get(int sock)
{
  unsigned char	buff[1024];
  int		br, bn;
  int		size;
  char		*version;
  char		*tmp = NULL;
  
  br = bn = 0;
  version = strdup("");
  while (42)
    {
      if (!read(sock, buff, 1))
	break ;
      if (buff[0] == '\r')
	br = (buff[0] == '\r' && !bn);
      else if (buff[0] == '\n')
	bn = (buff[0] == '\n' && br);
      else
	bn = br = 0;
      if (!bn && buff[0] == '\n')
	{
	  while ((size = read(sock, buff, 1024)))
	    {
	      tmp = malloc(size + strlen(version));
	      strcpy(tmp, version);
	      strncat(tmp, buff, size);
	      free(version);
	      version = tmp;
	    }
	  break ;
	}
    }
  return (version);
}

static void	update_dialog(const char *version)
{
  GtkWidget	*update_dialog;
  GtkWidget	*vbox1;
  GtkWidget	*vbox2;
  GtkWidget	*lblUpdate;
  GtkWidget	*frame1;
  GtkWidget	*scrolledwindow1;
  GtkWidget	*txtVersion;
  GtkWidget	*btnOK;

  update_dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (update_dialog), "update_dialog", update_dialog);
  gtk_window_set_title (GTK_WINDOW (update_dialog), "NoSoucy - New version available");
  gtk_window_set_default_size (GTK_WINDOW (update_dialog), 300, 250);
  gtk_window_set_position (GTK_WINDOW (update_dialog), GTK_WIN_POS_CENTER);

  vbox1 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (update_dialog), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (update_dialog), vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);

  frame1 = gtk_frame_new ("Version history");
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (update_dialog), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (update_dialog), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame1), vbox2);
  gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);

  lblUpdate = gtk_label_new ("http://www.no-soucy.com/");
  gtk_widget_ref (lblUpdate);
  gtk_object_set_data_full (GTK_OBJECT (update_dialog), "lblUpdate", lblUpdate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblUpdate);
  gtk_box_pack_start (GTK_BOX (vbox2), lblUpdate, FALSE, FALSE, 0);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (update_dialog), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow1, TRUE, TRUE, 0);

  txtVersion = gtk_text_new (NULL, NULL);
  gtk_widget_ref (txtVersion);
  gtk_object_set_data_full (GTK_OBJECT (update_dialog), "txtVersion", txtVersion,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (txtVersion);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), txtVersion);
  gtk_text_insert(GTK_TEXT(txtVersion), NULL, NULL, NULL, version, strlen(version));

  btnOK = gtk_button_new_with_label ("OK");
  gtk_widget_ref (btnOK);
  gtk_object_set_data_full (GTK_OBJECT (update_dialog), "btnOK", btnOK,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnOK);
  gtk_box_pack_start (GTK_BOX (vbox1), btnOK, FALSE, FALSE, 0);

  gtk_signal_connect_object (GTK_OBJECT (btnOK), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (update_dialog));

  gtk_widget_show(update_dialog);
}

void	*update_check(void *data)
{
  int	n;
  int	sock;
  char	*version;

  sleep(5);
  netsoulLog("[update] : Checking for new version ...\n");
  if ((sock = update_connect()) > 0)
    {
      version = update_get(sock);
      if (((n = (int)(strchr(version, '\n') - version)) > 0) &&
	  strncmp(NOSOUCY_VERSION, version, n))
	{
	  netsoulLog("[update] : New version found : %.*s\n", n, version);
	  update_dialog(version);
	}
      else
	netsoulLog("[update] : You're up to date\n");
      close(sock);
      free(version);
    }
  return (NULL);
}
