/*
** contacts.h for  in /home/dev/xml
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sat May 17 18:26:56 2003 Anto
** Last update Sun Jan  4 20:11:38 2004 Anto
*/

#ifndef	_CONTACTS_H_
#define _CONTACTS_H_

#include <gtk/gtk.h>
#include "list.h"

#define	MAX_LOG	10

#define	BUDDY_INFO_ID		0
#define	BUDDY_INFO_LOGIN	1
#define	BUDDY_INFO_IP		2
#define	BUDDY_INFO_TIME_LOGIN	3
#define	BUDDY_INFO_TIME_IDLE	4
#define	BUDDY_INFO_AUTH_USER	5
#define	BUDDY_INFO_AUTH_AG	6
#define	BUDDY_INFO_MACH_FUNC	7
#define	BUDDY_INFO_MACH_LOC	8
#define	BUDDY_INFO_GROUP	9
#define	BUDDY_INFO_STATE	10
#define	BUDDY_INFO_TIME_STATE	11
#define	BUDDY_INFO_USER_DATA	12

#define	BUDDY_MASK_ALL		0xFFFF
#define	BUDDY_MASK_ID		(1 << 0)
#define	BUDDY_MASK_LOGIN	(1 << 1)
#define	BUDDY_MASK_IP		(1 << 2)
#define	BUDDY_MASK_TIME_LOGIN	(1 << 3)
#define	BUDDY_MASK_TIME_IDLE	(1 << 4)
#define	BUDDY_MASK_AUTH_USER	(1 << 5)
#define	BUDDY_MASK_AUTH_AG	(1 << 6)
#define	BUDDY_MASK_MACH_FUNC	(1 << 7)
#define	BUDDY_MASK_MACH_LOC	(1 << 8)
#define	BUDDY_MASK_GROUP	(1 << 9)
#define	BUDDY_MASK_STATE	(1 << 10)
#define	BUDDY_MASK_TIME_STATE	(1 << 11)
#define	BUDDY_MASK_USER_DATA	(1 << 12)

#define ADD_MENU_ADD_GROUP		"... group"
#define ADD_MENU_ADD_BUDDY		"... buddy"

#define CONTACT_MENU_GROUP_COUNT	"Group count"
#define CONTACT_MENU_AUTO_EXPAND	"Auto expand groups"
#define CONTACT_MENU_OFFLINE_CONTACTS	"Offline group"

#define GROUP_MENU_MASS_MESSAGE		"Mass message"
#define GROUP_MENU_EDIT			"Edit"
#define GROUP_MENU_REMOVE		"Remove"
#define GROUP_MENU_ADD			"Add ..."
#define GROUP_MENU_CONTACT_LIST_OPTION	"Contact list options"

#define BUDDY_MENU_MESSAGE		"Message"
#define BUDDY_MENU_SHOW_LOG		"Show log"
#define BUDDY_MENU_EDIT			"Edit"
#define BUDDY_MENU_REMOVE		"Remove"
#define BUDDY_MENU_ADD			"Add ..."
#define BUDDY_MENU_ALERT		"Alert"
#define BUDDY_MENU_BLOCK		"Block"
#define BUDDY_MENU_MESSAGE		"Message"
#define BUDDY_MENU_CONTACT_LIST_OPTION	"Contact list options"

typedef struct	info_s
{
  int		id;
  int		lock;
  char		*login;
  char		*ip;
  int		time_login;
  int		time_idle;
  char		*auth_user;
  char		*auth_ag;
  char		*mach_func;
  char		*mach_loc;
  char		*group;
  char		*state;
  int		time_state;
  char		*user_data;
  GtkWidget	*item;
}		info_t;

typedef struct	group_s
{
  char		*name;
  int		online_count;
  int		buddy_count;
  int		expand;
  GtkWidget	*item;
  int		expanded;
}		group_t;

typedef struct	buddy_s
{
  char		*login;
  char		*alias;
  group_t	*group;
  int		nb_log;
  info_t	info[MAX_LOG];
  GtkWidget	*item;
  GtkWidget	*offline;
  int		expand;
  int		alerte;
  int		expanded;
}		buddy_t;

#define TYPE_GROUP		(gpointer)1
#define TYPE_BUDDY		(gpointer)2
#define TYPE_BUDDY_INFO		(gpointer)3

#define DEFAULT_BUDDY_LOGIN	NULL
#define DEFAULT_BUDDY_ALIAS	NULL
#define DEFAULT_BUDDY_EXPAND	FALSE
#define DEFAULT_BUDDY_ALERTE	FALSE
#define DEFAULT_GROUP_EXPAND	FALSE
#define DEFAULT_GROUP_NAME	NULL
#define OFFLINE_CONTACTS	"Offline contacts"

group_t	*contactsNewGroup(char *, int);
buddy_t	*contactsNewBuddy(char *, char *, int, int);
void	contactsUpdateGroup(group_t *, char *, int);
void	contactsUpdateBuddy(buddy_t *, char *, char *, int, int);
group_t	*contactsDupGroup(group_t *);
buddy_t	*contactsDupBuddy(buddy_t *);
void	contactsFreeGroup(group_t *);
void	contactsFreeBuddy(buddy_t *);
int	contactsCmpBuddy(buddy_t *, char *);
int	contactsFindBuddyId(buddy_t *, int);
int	contactsGetNewBuddyInfoId(buddy_t *);
void	contactsUpdateBuddyInfo(buddy_t *, int, char **, short);
void	contactsFreeBuddyInfo(buddy_t *, int);
list_t	*contactsMakeBuddyList(list_t *);

/* UI */
void		contacts_UI(GtkWidget *);
void		contacts_UIFillList(list_t *, list_t *);
void		contacts_UIShowBuddy(buddy_t *, int);
void		contacts_UIHideBuddy(buddy_t *, int);
void		contacts_UIHideAll(list_t *);
void		contacts_UIRefreshTree();
void		contacts_UIInsertGroup(group_t *);
void		contacts_UIInsertBuddy(buddy_t *);
void		contacts_UIEmptyList(list_t *, list_t *);
GtkWidget	*contacts_UIGetMenuGroup();
GtkWidget	*contacts_UIGetMenuBuddy();
GtkWidget	*contacts_UIGetOfflineGroup();
void		contacts_UISetMenuContactOption(int);
void		contacts_UIAlert(buddy_t *, int);
void		contacts_UIBlock(buddy_t *);
void		contacts_UIRemoveBuddy(buddy_t *);

gboolean	on_item_contact_tree_button_press(GtkWidget *, GdkEventButton *, gpointer);
gboolean	on_item_enter_notify(GtkWidget *, GdkEventMotion *, GtkWidget *);
int		on_item_dblclick(GtkWidget *, GdkEventButton *, gpointer);
gboolean	on_group_tree_button_press(GtkWidget *, GdkEventButton *, gpointer);
gboolean	on_offline_tree_button_press(GtkWidget *, GdkEventButton *, gpointer);
gboolean	on_menu_show(GtkWidget *, GdkEventButton *, GtkWidget *);
gboolean	on_Group_menu_rename(GtkMenuItem *, gpointer);
gboolean	on_menu_add_buddy(GtkMenuItem *, gpointer);
gboolean	on_menu_add_group(GtkMenuItem *, gpointer);
gboolean	on_menu_group_count(GtkMenuItem *, gpointer);
gboolean	on_menu_offline_contacts(GtkMenuItem *, gpointer);
gboolean	on_menu_auto_expand(GtkMenuItem *, gpointer);
gboolean	on_menu_remove_group(GtkMenuItem *, gpointer);
gboolean	on_menu_buddy_message(GtkMenuItem *, gpointer);
gboolean	on_menu_buddy_rename(GtkMenuItem *, gpointer);
gboolean	on_menu_buddy_block(GtkMenuItem *, gpointer);
gboolean	on_menu_buddy_alert(GtkMenuItem *, gpointer);
gboolean	on_menu_buddy_remove(GtkMenuItem *, gpointer);
gboolean	on_menu_group_mass_message(GtkMenuItem *, gpointer);
gboolean	on_menu_buddy_show_log(GtkMenuItem *, gpointer);

#endif /* _CONTACTS_H_ */
