#!/bin/sh
echo "Starting NoSoucy compilation."
echo ""
if !(make) then
    echo ""
    echo "Compiltation failed."
    exit 1
fi
echo ""
echo "NoSoucy compiled successfully."
echo ""
#make clean
strip NoSoucy
if !(test -d ~/.NoSoucy) then
    echo "Creating NoSoucy directory"
    mkdir ~/.NoSoucy
    chmod 700 ~/.NoSoucy
fi
if !(test -f ~/.NoSoucy/NoSoucy.xml) then
    echo "Copying configuration file"
    cp -f conf/NoSoucy.xml ~/.NoSoucy/
    chmod 600 ~/.NoSoucy/NoSoucy.xml
fi
if !(test -d ~/.NoSoucy/log) then
    echo "Creating log directory"
    mkdir ~/.NoSoucy/log
fi
if !(test -d ~/.NoSoucy/cache) then
    echo "Creating cache directory"
    mkdir ~/.NoSoucy/cache
fi
if !(test -d ~/.NoSoucy/skin) then
    echo "Creating skin directory"
    mkdir ~/.NoSoucy/skin
fi
if !(test -d ~/.NoSoucy/skin/base) then
    echo "Installing base skin"
    mkdir ~/.NoSoucy/skin/base
    cp -f pixmap/*.xpm ~/.NoSoucy/skin/base/
    cp -f conf/base.xml ~/.NoSoucy/skin/base/
fi
if (test -d ~/.ns) then
    echo -n "Do you want to put NoSoucy as your default netsoul client ? [yn] "
    read install
    if (test -z $install) || (test $install = "y") then
	echo "Removing old netsoul client..."
	if (test -f ~/.ns/ns_user_cmd) then
	    mv ~/.ns/ns_user_cmd ~/.ns/ns_user_cmd.old 
	fi
	echo "Installing NoSoucy..."
	cp ./NoSoucy ~/.ns/
	ln -s ~/.ns/NoSoucy ~/.ns/ns_user_cmd
	echo "You have to restart session to apply changes."
	echo "NoSoucy will start automatically when you receive a message."
    fi 
fi
echo ""
echo "Installation done."
