/*
** utils.c for  in /home/dev/NoSoucy
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 11:37:33 2003 Anto
** Last update Sun Jan  4 13:46:57 2004 Anto
*/

#include "utils.h"
#include "env.h"
#include "conf.h"
#include "skin.h"
#include "photo.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <gdk_imlib.h>

#include <gdk/gdkprivate.h>

#define BUFF_SIZE	42

static char	buff[BUFF_SIZE];
static int	in_buf = 0;
static int	start;

static int	read_from_file(int fd)
{
  in_buf = read(fd,buff,BUFF_SIZE);
  start = 0;
  return (in_buf);
}

static char	*add_to_line(char *line,int cur)
{
  char		*new;
  int		old_len;

  new = malloc((old_len=(line?strlen(line):0))+cur+1);
  if (line)
    {
      memcpy(new,line,old_len);
      free(line);
    }
  memcpy(new+old_len,buff+start,cur);
  new[old_len+cur] = 0;
  start += cur + 1;
  return (new);
}

char	*utils_readLine(int fd)
{
  int	cur;
  char	*line;

  for (line = 0, cur = 0; ; cur++)
    {
      if (start >= in_buf)
        {
          if (!read_from_file(fd))
            return (line);
          cur = 0;
        }
      if (buff[start+cur] == '\n')
        {
          line = add_to_line(line,cur);
          return (line);
        }
      if (start + cur == in_buf-1)
        line = add_to_line(line,cur+1);
    }
}

void		utils_setBackground(GtkWidget *widget, long lcolor)
{
  GtkRcStyle	*rc_style;
  GdkColor	color;

  rc_style = gtk_rc_style_new();
  color.red = (lcolor & 0xFF0000) >> 8;
  color.green = (lcolor & 0x00FF00);
  color.blue = (lcolor & 0x0000FF) << 8;
  rc_style->bg[GTK_STATE_NORMAL] = color;
  rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_BG;
  gtk_widget_modify_style(widget, rc_style);
  gtk_rc_style_unref(rc_style);
}

void		utils_setSelectedColor(GtkWidget *widget, const char *scolor)
{
  GtkRcStyle	*rc_style;
  long		lcolor;
  GdkColor	color;

  lcolor = strtol(scolor, (char **)NULL, 16);
  rc_style = gtk_rc_style_new();
  color.red = (lcolor & 0xFF0000) >> 8;
  color.green = (lcolor & 0x00FF00);
  color.blue = (lcolor & 0x0000FF) << 8;
  rc_style->bg[GTK_STATE_SELECTED] = color;
  rc_style->color_flags[GTK_STATE_SELECTED] |= GTK_RC_BG;
  gtk_widget_modify_style(widget, rc_style);
  gtk_rc_style_unref(rc_style);
}

void		utils_setTextColor(GtkWidget *widget, const char *scolor)
{
  GtkRcStyle	*rc_style;
  long		lcolor;
  GdkColor	color;

  lcolor = strtol(scolor, (char **)NULL, 16);
  rc_style = gtk_rc_style_new();
  color.red = (lcolor & 0xFF0000) >> 8;
  color.green = (lcolor & 0x00FF00);
  color.blue = (lcolor & 0x0000FF) << 8;
  rc_style->fg[GTK_STATE_NORMAL] = color;
  rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_FG;
  gtk_widget_modify_style(widget, rc_style);
  gtk_rc_style_unref(rc_style);
}

void		utils_setFont(GtkWidget *widget, const char *fontname)
{
  GtkRcStyle	*rc_style;

  rc_style = gtk_rc_style_new();
  rc_style->font_name = strdup(fontname);
  gtk_widget_modify_style(widget, rc_style);
  gtk_rc_style_unref(rc_style);
}

GdkColor	*utils_scolor_to_pixel(GdkColor *color, const char *scolor)
{
/*   color->pixel = strtoul(scolor + 1, (char **)NULL, 16); */
/*   color->pixel = gdk_rgb_xpixel_from_rgb(color->pixel); */
/*   color->red = (color->pixel & 0xFF0000) >> 8; */
/*   color->green = (color->pixel & 0x00FF00); */
/*   color->blue = (color->pixel & 0x0000FF) << 8; */
  gdk_color_parse(scolor, color);
  return (color);
}

void		utils_photo_set(char *login, 
				short width, short height, 
				GtkWidget *pixmap)
{
  char		*buf;
  GdkImlibImage	*img;
  GdkPixmap	*pxmp;
  GdkBitmap	*mask;
       
  asprintf(&buf, "%s/%s.jpg", env->cache, login);
  if (photo_get(login, buf))
    {
      if (!(img = gdk_imlib_load_image(buf)))
	remove(buf);
      else
	{
	  gdk_imlib_render(img, width, height);
	  pxmp = gdk_imlib_move_image(img);
	  mask = gdk_imlib_move_mask(img);
	  gtk_pixmap_set(GTK_PIXMAP(pixmap), pxmp, mask);
	  gdk_imlib_free_colors();
	  gdk_imlib_free_pixmap(pxmp);
	  gdk_imlib_free_bitmap(mask);
	  gdk_imlib_kill_image(img);
	}
    }
  else
    {
      img = gdk_imlib_create_image_from_drawable(skin->icon[SKIN_NO].pixmap, skin->icon[SKIN_NO].mask, 0, 0, 75, 90);
      gdk_imlib_save_image(img, buf, NULL);
      gdk_imlib_render(img, width, height);
      pxmp = gdk_imlib_move_image(img);
      mask = gdk_imlib_move_mask(img);
      gtk_pixmap_set(GTK_PIXMAP(pixmap), pxmp, mask);
      gdk_imlib_free_colors();
      gdk_imlib_free_pixmap(pxmp);
      gdk_imlib_free_bitmap(mask);
      gdk_imlib_kill_image(img);
    }
  free(buf);  
}

char		*utils_maketimeformat(time_t timestamp)
{
  char		*str = NULL;
  struct tm	*tm;

  tm = localtime(&timestamp);
  if (conf->time_format == 1)
    asprintf(&str, "[%.2d:%.2d] ", tm->tm_hour, tm->tm_min);
  else if (conf->time_format == 2)
    asprintf(&str, "[%.2d:%.2d:%.2d] ", tm->tm_hour, tm->tm_min, tm->tm_sec);
  else
    str = strdup("");
  return (str);
}
