/*
** control_panel.c for  in /root/c/NoSoucy-0.2
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Wed May 21 06:26:44 2003 Anto
** Last update Fri Dec 19 07:21:32 2003 Anto
*/

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "control_panel.h"
#include "contacts.h"
#include "utils.h"
#include "skin.h"

void	ControlPanel_loadConf(conf_t *config)
{
  ControlPanel_setTextStr(config->host, "entry_host");
  ControlPanel_setTextInt(config->port, "entry_port");
  ControlPanel_setTextStr(config->login, "entry_login");
  ControlPanel_setTextStr(config->password, "entry_password");
  ControlPanel_setTextStr(config->location, "entry_location");
  ControlPanel_setTextStr(config->user_data, "entry_user_data");
  ControlPanel_setTextInt(config->attempt, "entry_attempt");
  ControlPanel_setTextInt(config->delay, "entry_delay");

  ControlPanel_setCheckValue(config->big_mail_alert, "chkMail");
  ControlPanel_setTextInt(config->away_delay, "entry_auto_away_delay");
  ControlPanel_setCheckValue(config->auto_answer, "checkbutton_auto_answer");
  ControlPanel_setList(config->answer, "list_auto_answer");

  ControlPanel_setTextInt(config->aspect_width, "entry_aspect_width");
  ControlPanel_setTextInt(config->aspect_height, "entry_aspect_height");
  ControlPanel_setTextInt(config->aspect_x, "entry_aspect_x");
  ControlPanel_setTextInt(config->aspect_y, "entry_aspect_y");
  ControlPanel_setTextStr(config->skin_file, "entry_skin_file");
  ControlPanel_setCheckValue(config->save_geometry, "checkbutton_save_geometry");

  ControlPanel_setCheckValue(config->offline_group, "checkbutton_offline_group");
  ControlPanel_setCheckValue(config->group_count, "checkbutton_group_count");
  ControlPanel_setCheckValue(config->auto_expand, "checkbutton_auto_expand");
  ControlPanel_setContactList(config->buddy, config->group);

  ControlPanel_setTextStr(config->ignore_answer, "entry_ignore_answer");
  ControlPanel_setList(config->ignore, "list_ignore");

  ControlPanel_setTextInt(config->message_width, "entry_message_width");
  ControlPanel_setTextInt(config->message_height, "entry_message_height");
  ControlPanel_setTextInt(config->message_x, "entry_message_x");
  ControlPanel_setTextInt(config->message_y, "entry_message_y");
  ControlPanel_setCheckValue(config->message_save_geometry, "checkbutton_save_message_geometry");
  ControlPanel_setCheckValue(config->expand_pict, "checkbutton_expand_pict");
  ControlPanel_setCheckValue(config->history, "checkbutton_history");
  ControlPanel_setTextInt(config->history_line, "entry_history_line");
  ControlPanel_setTextStr(config->history_color, "entry_history_color");
  ControlPanel_setTextStr(config->login_color, "entry_login_color");
  ControlPanel_setTextStr(config->contact_color, "entry_contact_color");
  ControlPanel_setTextStr(config->text_color, "entry_text_color");
  ControlPanel_setComboValue(config->time_format, "combo_time_format");
}

conf_t		*ControlPanel_saveConf(char flag)
{
  conf_t	*config;
  
  config = calloc(1, sizeof(conf_t));
  config->host = ControlPanel_getTextStr("entry_host");
  config->port = ControlPanel_getTextInt("entry_port");
  config->login = ControlPanel_getTextStr("entry_login");
  config->password = ControlPanel_getTextStr("entry_password");
  config->location = ControlPanel_getTextStr("entry_location");
  config->user_data = ControlPanel_getTextStr("entry_user_data");
  config->attempt = ControlPanel_getTextInt("entry_attempt");
  config->delay = ControlPanel_getTextInt("entry_delay");

  config->big_mail_alert = ControlPanel_getCheckValue("chkMail");
  config->away_delay = ControlPanel_getTextInt("entry_auto_away_delay");
  config->auto_answer = ControlPanel_getCheckValue("checkbutton_auto_answer");
  config->answer = ControlPanel_getList("list_auto_answer");

  config->aspect_width = ControlPanel_getTextInt("entry_aspect_width");
  config->aspect_height = ControlPanel_getTextInt("entry_aspect_height");
  config->aspect_x = ControlPanel_getTextInt("entry_aspect_x");
  config->aspect_y = ControlPanel_getTextInt("entry_aspect_y");
  config->skin_file = ControlPanel_getTextStr("entry_skin_file");
  config->save_geometry = ControlPanel_getCheckValue("checkbutton_save_geometry");

  config->offline_group = ControlPanel_getCheckValue("checkbutton_offline_group");
  config->group_count = ControlPanel_getCheckValue("checkbutton_group_count");
  config->auto_expand = ControlPanel_getCheckValue("checkbutton_auto_expand");
  if (flag)
    {
      config->buddy = config->group = NULL;
      ControlPanel_getContactList(&config->buddy, &config->group);
    }
/*   config->buddy = conf->buddy; */
/*   config->group = conf->group; */

  config->ignore_answer = ControlPanel_getTextStr("entry_ignore_answer");
  config->ignore = ControlPanel_getList("list_ignore");

  config->message_width = ControlPanel_getTextInt("entry_message_width");
  config->message_height = ControlPanel_getTextInt("entry_message_height");
  config->message_x = ControlPanel_getTextInt("entry_message_x");
  config->message_y = ControlPanel_getTextInt("entry_message_y");
  config->message_save_geometry = ControlPanel_getCheckValue("checkbutton_save_message_geometry");
  config->expand_pict = ControlPanel_getCheckValue("checkbutton_expand_pict");
  config->history = ControlPanel_getCheckValue("checkbutton_history");
  config->history_line = ControlPanel_getTextInt("entry_history_line");
  config->history_color = ControlPanel_getTextStr("entry_history_color");
  config->login_color = ControlPanel_getTextStr("entry_login_color");
  config->contact_color = ControlPanel_getTextStr("entry_contact_color");
  config->text_color = ControlPanel_getTextStr("entry_text_color");
  config->time_format = ControlPanel_getComboValue("combo_time_format");
  return (config);
}

/* SET */
void	ControlPanel_setTextStr(char *str, const char *object)
{
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), object)),
		     str);
}

void	ControlPanel_setTextInt(int value, const char *object)
{
  char	str[10];

  snprintf(str, 10, "%i", value);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), object)),
		     str);
}

void		ControlPanel_setCheckValue(int value, const char *object)
{
  GtkWidget	*check;
  
  check = gtk_object_get_data(GTK_OBJECT(Control_Panel), object);
  gtk_toggle_button_set_active(&(GTK_CHECK_BUTTON(check)->toggle_button), value);
}

void		ControlPanel_setComboValue(int value, const char *object)
{
  GtkWidget	*combo;
  char		*str = NULL;
  GList		*glist;
  int		i;

  combo = gtk_object_get_data(GTK_OBJECT(Control_Panel), object);
  glist = GTK_LIST(GTK_COMBO(combo)->list)->children;
  for (i = 0; i <= value && glist; i++)
    {
      str = GTK_LABEL(GTK_LIST_ITEM(glist->data)->item.bin.child)->label;
      glist = g_list_next(glist);
    }
  if (str)
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), str);
}

void		ControlPanel_setList(list_t *values, const char *object)
{
  GList		*lst = NULL;
  GtkWidget	*item;

  while (values)
    {
      lst = g_list_append(lst, item = gtk_list_item_new_with_label(values->data));
      gtk_widget_show_all(item);
      values = values->next;
    }
  gtk_list_append_items(GTK_LIST(gtk_object_get_data(GTK_OBJECT(Control_Panel), object)), 
			lst);
}

void		ControlPanel_setContactList(list_t *buddy, list_t *group)
{
  list_t	*tmp;
  group_t	*grp;
  buddy_t	*bdy;
  GList		*lst = NULL;
  GtkWidget	*item;

  while (group)
    {
      if (group->data)
	{
	  grp = contactsDupGroup(group->data);
	  lst = g_list_append(lst, item = gtk_list_item_new_with_label(grp->name));
	  gtk_widget_set_name(GTK_LIST_ITEM(item)->item.bin.child, skin->group.name);
	  gtk_object_set_data(GTK_OBJECT(item), "type", TYPE_GROUP);
	  gtk_object_set_data_full(GTK_OBJECT(item), "data", grp, (GtkDestroyNotify)contactsFreeGroup);
	  gtk_widget_show_all(item);
	  gtk_signal_connect(GTK_OBJECT(item), "button_press_event", GTK_SIGNAL_FUNC(on_list_contact_list_button_press_event), NULL);
	}
      for (tmp = buddy; tmp; tmp = tmp->next)
	{
	  if (((buddy_t *)tmp->data)->group != (group_t *)group->data)
	    continue ;
	  bdy = contactsDupBuddy((buddy_t *)tmp->data);
	  lst = g_list_append(lst, item = gtk_list_item_new_with_label(bdy->login));
	  gtk_object_set_data(GTK_OBJECT(item), "type", TYPE_BUDDY);
	  gtk_object_set_data_full(GTK_OBJECT(item), "data", bdy, (GtkDestroyNotify)contactsFreeBuddy);
	  gtk_widget_show_all(item);
	  gtk_signal_connect(GTK_OBJECT(item), "button_press_event", GTK_SIGNAL_FUNC(on_list_contact_list_button_press_event), NULL);
	}
      group = group->next;
    }
  gtk_list_append_items(GTK_LIST(gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_contact_list")), 
			lst);
}

/* GET */
char	*ControlPanel_getTextStr(const char *object)
{
  return (strdup(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), object)))));
}

int	ControlPanel_getTextInt(const char *object)
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), object)))));
}

int		ControlPanel_getCheckValue(const char *object)
{
  GtkWidget	*check;
  
  check = gtk_object_get_data(GTK_OBJECT(Control_Panel), object);
  return (gtk_toggle_button_get_active(&(GTK_CHECK_BUTTON(check)->toggle_button)));
}

int		ControlPanel_getComboValue(const char *object)
{
  GtkWidget	*combo;
  char		*str;
  GList		*glist;
  int		i;

  combo = gtk_object_get_data(GTK_OBJECT(Control_Panel), object);
  str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));
  glist = GTK_LIST(GTK_COMBO(combo)->list)->children;
  for (i = 0; glist; i++)
    {
      if (!strcmp(str, GTK_LABEL(GTK_LIST_ITEM(glist->data)->item.bin.child)->label))
	break ;
      glist = g_list_next(glist);
    }
  return (i);
}

list_t		*ControlPanel_getList(const char *object)
{
  list_t	*last = NULL;
  GList		*glist = NULL;
  GtkWidget	*list;
  char		*item;

  list = gtk_object_get_data(GTK_OBJECT(Control_Panel), object);
  glist = GTK_LIST(list)->children;
  while (glist)
    {
      item = GTK_LABEL(GTK_LIST_ITEM(glist->data)->item.bin.child)->label;
      putinlist(&last, strdup(item));
      glist = g_list_next(glist);
    }
  return (last);
}

void		ControlPanel_getContactList(list_t **buddy, list_t **group)
{
  group_t	*current = NULL;
  GList		*glist = NULL;
  gpointer	type;
  gpointer	data;

  glist = GTK_LIST(gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_contact_list"))->children;
  putinlist(group, NULL);
  while (glist)
    {
      type = gtk_object_get_data(GTK_OBJECT(GTK_LIST_ITEM(glist->data)), "type");
      data = gtk_object_get_data(GTK_OBJECT(GTK_LIST_ITEM(glist->data)), "data");
      if (type == TYPE_GROUP)
	putinlist(group, current = contactsDupGroup(data));
      else if (type == TYPE_BUDDY)
	{
	  putinlist(buddy, data = contactsDupBuddy(data));
	  ((buddy_t *)data)->group = current;
	  if (current)
	    current->buddy_count++;
	}
      glist = g_list_next(glist);
    }
}
