/*
** conf.c for  in /home/dev/xml
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sat May 17 05:26:44 2003 Anto
** Last update Fri Dec 19 08:06:31 2003 Anto
*/

#include "conf.h"
#include "xml.h"
#include "url.h"
#include "contacts.h"
#include <stdio.h>
#include <string.h>

conf_t	*conf = NULL;

#ifdef __DEV
void		confShow()
{
  list_t	*tmp;

  printf("\nConnection :\n");
  printf("\tHost : %s\n", conf->host);
  printf("\tPort : %d\n", conf->port);
  printf("\tLogin : %s\n", conf->login);
  printf("\tPassword : %s\n", conf->password);
  printf("\tLocation : %s\n", conf->location);
  printf("\tUser data : %s\n", conf->user_data);
  printf("\tAttempt : %d\n", conf->attempt);
  printf("\tDelay : %d\n", conf->delay);

  printf("\nAspect :\n");
  printf("\tWidth : %d\n", conf->aspect_width);
  printf("\tHeight : %d\n", conf->aspect_height);
  printf("\tX : %d\n", conf->aspect_x);
  printf("\tY : %d\n", conf->aspect_y);
  printf("\tSave geometry : %d\n", conf->save_geometry);
  printf("\tSkin file : %s\n", conf->skin_file);

  printf("\nAutomation :\n");
  printf("\tAway delay : %d\n", conf->away_delay);
  printf("\tDefault message : %d\n", conf->default_message);
  printf("\tAuto answer : %d\n", conf->auto_answer);
  for (tmp = conf->answer; tmp; tmp = tmp->next)
    printf("\tAnswer : %s\n", (char *)tmp->data);

  printf("\nIgnore :\n");
  printf("\tIgnore answer : %s\n", (char *)conf->ignore_answer);
  for (tmp = conf->ignore; tmp; tmp = tmp->next)
    printf("\tLogin : %s\n", (char *)tmp->data);

  printf("\nContacts :\n");
  printf("\tOffline group : %d\n", conf->offline_group);
  printf("\tGroup count : %d\n", conf->group_count);
  printf("\tAuto expand : %d\n", conf->auto_expand);
  for (tmp = conf->buddy; tmp; tmp = tmp->next)
    {
      printf("\tBuddy : %s\n", ((buddy_t *)tmp->data)->login);
      printf("\tBuddy alias : %s\n", ((buddy_t *)tmp->data)->alias);
      printf("\tBuddy expand : %d\n", ((buddy_t *)tmp->data)->expand);
      if (((buddy_t *)tmp->data)->group)
	printf("\tBuddy group : %s\n", ((buddy_t *)tmp->data)->group->name);
    }
}
#endif

void	confSetDefaultString()
{
  if (conf->host == NULL)
    conf->host = strdup(DEFAULT_HOST);
  if (conf->login == NULL)
    conf->login = strdup(DEFAULT_LOGIN);
  if (conf->password == NULL)
    conf->password = strdup(DEFAULT_PASSWORD);
  if (conf->location == NULL)
    conf->location = strdup(DEFAULT_LOCATION);
  if (conf->user_data == NULL)
    conf->user_data = strdup(DEFAULT_USER_DATA);
  if (conf->history_color == NULL)
    conf->history_color = strdup(DEFAULT_HISTORY_COLOR);
  if (conf->login_color == NULL)
    conf->login_color = strdup(DEFAULT_LOGIN_COLOR);
  if (conf->contact_color == NULL)
    conf->contact_color = strdup(DEFAULT_CONTACT_COLOR);
  if (conf->text_color == NULL)
    conf->text_color = strdup(DEFAULT_TEXT_COLOR);
  if (conf->skin_file == NULL)
    conf->skin_file = strdup(DEFAULT_SKIN_FILE);
  if (conf->ignore_answer == NULL)
    conf->ignore_answer = strdup(DEFAULT_IGNORE_ANSWER);
}

void	confSetDefaultInt()
{
  conf->port = DEFAULT_PORT;
  conf->attempt = DEFAULT_ATTEMPT;
  conf->delay = DEFAULT_DELAY;
  conf->big_mail_alert = DEFAULT_BIG_MAIL_ALERT;
  conf->away_delay = DEFAULT_AWAY_DELAY;
  conf->default_message = DEFAULT_DEFAULT_ANSWER;
  conf->auto_answer = DEFAULT_BOOL_ANSWER;
  conf->aspect_width = DEFAULT_ASPECT_WIDTH;
  conf->aspect_height = DEFAULT_ASPECT_HEIGHT;
  conf->aspect_x = DEFAULT_ASPECT_X;
  conf->aspect_y = DEFAULT_ASPECT_Y;
  conf->save_geometry = DEFAULT_SAVE_GEOMETRY;
  conf->offline_group = DEFAULT_OFFLINE_GROUP;
  conf->group_count = DEFAULT_GROUP_COUNT;
  conf->auto_expand = DEFAULT_AUTO_EXPAND;
  conf->message_width = DEFAULT_MESSAGE_WIDTH;
  conf->message_height = DEFAULT_MESSAGE_HEIGHT;
  conf->message_x = DEFAULT_MESSAGE_X;
  conf->message_y = DEFAULT_MESSAGE_Y;
  conf->message_save_geometry = DEFAULT_MESSAGE_SAVE_GEOMETRY;
  conf->expand_pict = DEFAULT_EXPAND_PICT;
  conf->history = DEFAULT_HISTORY;
  conf->history_line = DEFAULT_HISTORY_LINE;
  conf->time_format = DEFAULT_TIME_FORMAT;
}


static void	confParseConnection(xmlDocPtr doc, xmlNodePtr cur) 
{
  conf->attempt = xmlGetPropInt(cur, "attempt", DEFAULT_ATTEMPT);
  conf->delay = xmlGetPropInt(cur, "delay", DEFAULT_DELAY);
  cur = cur->xmlChildrenNode;
  while (cur != NULL)
    {
      if ((!xmlStrcmp(cur->name, (const xmlChar *)"host")))
	{
	  conf->port = (short)xmlGetPropInt(cur, "port", DEFAULT_PORT);
	  conf->host = xmlNodeGetString(doc, cur, DEFAULT_HOST);
	}
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"login")))
	conf->login = xmlNodeGetString(doc, cur, DEFAULT_LOGIN);
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"password")))
	conf->password = xmlNodeGetString(doc, cur, DEFAULT_PASSWORD);
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"location")))
	conf->location = xmlNodeGetString(doc, cur, DEFAULT_LOCATION);
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"user_data")))
	conf->user_data = xmlNodeGetString(doc, cur, DEFAULT_USER_DATA);
      cur = cur->next;
    }
}

static void	confParseAutomation(xmlDocPtr doc, xmlNodePtr cur)
{
  cur = cur->xmlChildrenNode;
  while (cur != NULL)
    {
      if ((!xmlStrcmp(cur->name, (const xmlChar *)"away")))
	{
	  xmlNodePtr ans;
	  void	     *data;

	  conf->away_delay = (short)xmlGetPropInt(cur, "delay", DEFAULT_AWAY_DELAY);
	  conf->default_message = (short)xmlGetPropInt(cur, "default", DEFAULT_DEFAULT_ANSWER);
	  conf->auto_answer = (short)xmlGetPropBoolean(cur, "answer", DEFAULT_BOOL_ANSWER);
	  for (ans = cur->xmlChildrenNode; ans != NULL; ans = ans->next)
	    if ((!xmlStrcmp(ans->name, (const xmlChar *)"answer")))
	      if ((data = (void *)xmlNodeGetString(doc, ans, DEFAULT_ANSWER)))
		putinlist(&conf->answer, data);
	}
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"alert")))
	conf->big_mail_alert = (short)xmlGetPropBoolean(cur, "mail", DEFAULT_BIG_MAIL_ALERT);	
      cur = cur->next;
    }
}

static void	confParseAspect(xmlDocPtr doc, xmlNodePtr cur) 
{
  cur = cur->xmlChildrenNode;
  while (cur != NULL) 
    {
      if ((!xmlStrcmp(cur->name, (const xmlChar *)"geometry"))) 
	{
	  conf->save_geometry = xmlGetPropBoolean(cur, "save", DEFAULT_SAVE_GEOMETRY);
	  conf->aspect_width = xmlGetPropInt(cur, "width", DEFAULT_ASPECT_WIDTH);
	  conf->aspect_height = xmlGetPropInt(cur, "height", DEFAULT_ASPECT_HEIGHT);
	  conf->aspect_x = xmlGetPropInt(cur, "x", DEFAULT_ASPECT_X);
	  conf->aspect_y = xmlGetPropInt(cur, "y", DEFAULT_ASPECT_Y);
	}
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"skin")))
	conf->skin_file = xmlNodeGetString(doc, cur, DEFAULT_SKIN_FILE);
      cur = cur->next;
    }
}

static void	confParseIgnore(xmlDocPtr doc, xmlNodePtr cur)
{
  cur = cur->xmlChildrenNode;
  while (cur != NULL)
    {
      if ((!xmlStrcmp(cur->name, (const xmlChar *)"answer")))
	conf->ignore_answer = xmlNodeGetString(doc, cur, DEFAULT_IGNORE_ANSWER);
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"login")))
	{
	  void	*data;

	  if ((data = (void *)xmlNodeGetString(doc, cur, DEFAULT_IGNORE_LOGIN)))
	    putinlist(&conf->ignore, data);
	}
      cur = cur->next;
    }
}

static buddy_t	*confCreateParseBuddy(xmlDocPtr doc, xmlNodePtr cur, group_t *group)
{
  buddy_t	*buddy;
  int		i;

  buddy = calloc(1, sizeof(buddy_t));
  buddy->alias = xmlGetPropStr(cur, "alias", DEFAULT_BUDDY_ALIAS);
  buddy->expand = xmlGetPropBoolean(cur, "expand", DEFAULT_BUDDY_EXPAND);
  buddy->alerte = xmlGetPropBoolean(cur, "alerte", DEFAULT_BUDDY_ALERTE);
  buddy->login = xmlNodeGetString(doc, cur, DEFAULT_BUDDY_LOGIN);
  buddy->group = group;
  for (i = 0; i < MAX_LOG; i++)
    buddy->info[i].id = -1;  
  if (group)
    group->buddy_count++;
  return (buddy);
}

static void	confParseContacts(xmlDocPtr doc, xmlNodePtr cur) 
{
  conf->offline_group = xmlGetPropBoolean(cur, "offline", DEFAULT_OFFLINE_GROUP);
  conf->group_count = xmlGetPropBoolean(cur, "count", DEFAULT_GROUP_COUNT);
  conf->auto_expand = xmlGetPropBoolean(cur, "expand", DEFAULT_AUTO_EXPAND);
  cur = cur->xmlChildrenNode;
  putinlist(&conf->group, NULL);
  while (cur != NULL)
    {
      if ((!xmlStrcmp(cur->name, (const xmlChar *)"buddy")))
	putinlist(&conf->buddy, confCreateParseBuddy(doc, cur, NULL));
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"group")))
	{
	  xmlNodePtr grpNode;
	  group_t    *group;
	  
	  group = calloc(1, sizeof(group_t));
	  group->expand = xmlGetPropBoolean(cur, "expand", DEFAULT_GROUP_EXPAND);
	  group->name = xmlGetPropStr(cur, "title", DEFAULT_GROUP_NAME);
	  group->buddy_count = group->online_count =0;
	  for (grpNode = cur->xmlChildrenNode; grpNode; grpNode = grpNode->next)
	    if ((!xmlStrcmp(grpNode->name, (const xmlChar *)"buddy")))
	      putinlist(&conf->buddy, confCreateParseBuddy(doc, grpNode, group));
	  putinlist(&conf->group, group);
	}
      cur = cur->next;
    }
}

static void	confParseMessage(xmlDocPtr doc, xmlNodePtr cur)
{
  cur = cur->xmlChildrenNode;
  while (cur != NULL) 
    {
      if ((!xmlStrcmp(cur->name, (const xmlChar *)"geometry"))) 
	{
	  conf->expand_pict = xmlGetPropBoolean(cur, "picture", DEFAULT_EXPAND_PICT);
	  conf->message_save_geometry = xmlGetPropBoolean(cur, "save", DEFAULT_MESSAGE_SAVE_GEOMETRY);
	  conf->message_width = xmlGetPropInt(cur, "width", DEFAULT_MESSAGE_WIDTH);
	  conf->message_height = xmlGetPropInt(cur, "height", DEFAULT_MESSAGE_HEIGHT);
	  conf->message_x = xmlGetPropInt(cur, "x", DEFAULT_MESSAGE_X);
	  conf->message_y = xmlGetPropInt(cur, "y", DEFAULT_MESSAGE_Y);
	}
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"history")))
	{
	  conf->history = xmlGetPropBoolean(cur, "state", DEFAULT_HISTORY);
	  conf->history_line = xmlGetPropInt(cur, "line", DEFAULT_HISTORY_LINE);
	  conf->history_color = xmlGetPropStr(cur, "color", DEFAULT_HISTORY_COLOR);
	}
      else if ((!xmlStrcmp(cur->name, (const xmlChar *)"misc")))
	{
	  conf->time_format = xmlGetPropInt(cur, "time", DEFAULT_TIME_FORMAT);
	  conf->login_color = xmlGetPropStr(cur, "login", DEFAULT_LOGIN_COLOR);
	  conf->contact_color = xmlGetPropStr(cur, "contact", DEFAULT_CONTACT_COLOR);
	  conf->text_color = xmlGetPropStr(cur, "text", DEFAULT_TEXT_COLOR);
	}
      cur = cur->next;
    }
}

conf_t		*confParseDoc(char *docname) 
{
  xmlDocPtr	doc;
  xmlNodePtr	cur;

  conf = calloc(1, sizeof(conf_t));
  confSetDefaultInt();
  if ((doc = xmlParseFile(docname)))
    {
      cur = xmlDocGetRootElement(doc);
      if (cur != NULL && !xmlStrcmp(cur->name, (const xmlChar *)"NoSoucy"))
	for (cur = cur->xmlChildrenNode; cur != NULL; cur = cur->next)
	  {
	    if ((!xmlStrcmp(cur->name, (const xmlChar *)"connection")))
	      confParseConnection(doc, cur);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)"automation")))
	      confParseAutomation(doc, cur);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)"aspect")))
	      confParseAspect(doc, cur);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)"ignore")))
	      confParseIgnore(doc, cur);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)"contacts")))
	      confParseContacts(doc, cur);
	    else if ((!xmlStrcmp(cur->name, (const xmlChar *)"message")))
	      confParseMessage(doc, cur);
	  }
      xmlFreeDoc(doc);
    }
  confSetDefaultString();
  return (conf);
}

void		confSaveDoc(const char *docname)
{
  xmlDocPtr     doc;
  xmlNodePtr    root;
  xmlNodePtr    child;
  xmlNodePtr    sub;
  xmlNodePtr    subgroup;
  char		buff[10];
  list_t	*list;
  list_t	*buddy;
  list_t	*group;
/*   group_t	*prev_group = NULL; */
  
  if (!(doc = xmlNewDoc("1.0")))
    return ;
  xmlIndentTreeOutput = 1;
  root = xmlNewDocNode(doc, NULL, "NoSoucy", NULL);
  child = xmlNewChild(root, NULL, "connection", NULL);
  xmlIntToStr(conf->attempt, buff);
  xmlNewProp(child, "attempt", buff);
  xmlIntToStr(conf->delay, buff);
  xmlNewProp(child, "delay", buff);
  sub = xmlNewChildEncoded(child, "host", conf->host);
  xmlIntToStr(conf->port, buff);
  xmlNewProp(sub, "port", buff);
  xmlNewChildEncoded(child, "login", conf->login);
  xmlNewChildEncoded(child, "password", conf->password);
  xmlNewChildEncoded(child, "location", conf->location);
  xmlNewChildEncoded(child, "user_data", conf->user_data);

  child = xmlNewChild(root, NULL, "automation", NULL);
  sub = xmlNewChild(child, NULL, "away", NULL);  
  xmlIntToStr(conf->away_delay, buff);
  xmlNewProp(sub, "delay", buff);
  xmlIntToStr(conf->default_message, buff);
  xmlNewProp(sub, "default", buff);
  xmlNewProp(sub, "answer", xmlBoolToStr(conf->auto_answer));
  for (list = conf->answer; list; list = list->next)
    xmlNewChildEncoded(sub, "answer", list->data);  
  sub = xmlNewChild(child, NULL, "alert", NULL);
  xmlNewProp(sub, "mail", xmlBoolToStr(conf->big_mail_alert));  
  
  child = xmlNewChild(root, NULL, "aspect", NULL);
  sub = xmlNewChild(child, NULL, "geometry", NULL);  
  xmlNewProp(sub, "save", xmlBoolToStr(conf->save_geometry));
  xmlIntToStr(conf->aspect_width, buff);
  xmlNewProp(sub, "width", buff);
  xmlIntToStr(conf->aspect_height, buff);
  xmlNewProp(sub, "height", buff);
  xmlIntToStr(conf->aspect_x, buff);
  xmlNewProp(sub, "x", buff);
  xmlIntToStr(conf->aspect_y, buff);
  xmlNewProp(sub, "y", buff);
  xmlNewChildEncoded(child, "skin", conf->skin_file);  

  child = xmlNewChild(root, NULL, "contacts", NULL);
  xmlNewProp(child, "offline", xmlBoolToStr(conf->offline_group));
  xmlNewProp(child, "count", xmlBoolToStr(conf->group_count));
  xmlNewProp(child, "expand", xmlBoolToStr(conf->auto_expand));

  for (subgroup = child, group = conf->group; group; group = group->next)
    {
      if (group->data)
	{
	  subgroup = xmlNewChild(child, NULL, "group", NULL);  
	  xmlNewPropEncoded(subgroup, "title", ((group_t *)group->data)->name);
	  xmlNewProp(subgroup, "expand", xmlBoolToStr(((group_t *)group->data)->expand));	  
	}
      for (buddy = conf->buddy; buddy; buddy = buddy->next)
	{
	  if (((buddy_t *)buddy->data)->group != (group_t *)group->data)
	    continue ;
	  sub = xmlNewChildEncoded(subgroup, "buddy", ((buddy_t *)buddy->data)->login);        
	  if (((buddy_t *)buddy->data)->alias && *(((buddy_t *)buddy->data)->alias) != 0)
	    xmlNewPropEncoded(sub, "alias", ((buddy_t *)buddy->data)->alias);
	  xmlNewProp(sub, "expand", xmlBoolToStr(((buddy_t *)buddy->data)->expand));
	  xmlNewProp(sub, "alerte", xmlBoolToStr(((buddy_t *)buddy->data)->alerte));
	}
    }
  
  child = xmlNewChild(root, NULL, "ignore", NULL);
  xmlNewChildEncoded(child, "answer", conf->ignore_answer);  
  for (list = conf->ignore; list; list = list->next)
    xmlNewChildEncoded(child, "login", list->data);  

  child = xmlNewChild(root, NULL, "message", NULL);
  sub = xmlNewChild(child, NULL, "geometry", NULL);    
  xmlNewProp(sub, "picture", xmlBoolToStr(conf->expand_pict));
  xmlIntToStr(conf->message_width, buff);
  xmlNewProp(sub, "save", xmlBoolToStr(conf->message_save_geometry));
  xmlIntToStr(conf->message_width, buff);
  xmlNewProp(sub, "width", buff);
  xmlIntToStr(conf->message_height, buff);
  xmlNewProp(sub, "height", buff);
  xmlIntToStr(conf->message_x, buff);
  xmlNewProp(sub, "x", buff);
  xmlIntToStr(conf->message_y, buff);
  xmlNewProp(sub, "y", buff);
  sub = xmlNewChild(child, NULL, "history", NULL);    
  xmlNewProp(sub, "state", xmlBoolToStr(conf->history));
  xmlIntToStr(conf->history_line, buff);
  xmlNewProp(sub, "line", buff);
  xmlNewPropEncoded(sub, "color", conf->history_color);
  sub = xmlNewChild(child, NULL, "misc", NULL);    
  xmlIntToStr(conf->time_format, buff);
  xmlNewPropEncoded(sub, "time", buff);
  xmlNewPropEncoded(sub, "login", conf->login_color);
  xmlNewPropEncoded(sub, "contact", conf->contact_color);
  xmlNewPropEncoded(sub, "text", conf->text_color);

  xmlDocSetRootElement(doc, root);
  xmlSaveFormatFile(docname, doc, 1);
  xmlFreeDoc(doc);
}

void	confFree(conf_t *config, char flag)
{
  if (config->host)
    free(config->host);
  if (config->login)
    free(config->login);
  if (config->password)
    free(config->password);
  if (config->location)
    free(config->location);
  if (config->user_data)
    free(config->user_data);
  if (config->skin_file)
    free(config->skin_file);
  if (config->ignore_answer)
    free(config->ignore_answer);
  if (config->history_color)
    free(config->history_color);
  if (config->login_color)
    free(config->login_color);
  if (config->contact_color)
    free(config->contact_color);
  if (config->text_color)
    free(config->text_color);
  listFree(config->answer, free);
  listFree(config->ignore, free);
  if (flag)
    {
      listFree(config->buddy, contactsFreeBuddy);
      listFree(config->group, contactsFreeGroup);
    }
  free(config);
}
