/*
** contacts_callback.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 20:41:06 2003 Anto
** Last update Sun Jan  4 19:11:12 2004 Anto
*/

#include "contacts.h"
#include "conf.h"
#include "control_panel.h"
#include "message.h"
#include "netsoul.h"
#include "request.h"
#include "dialog.h"
#include "skin.h"
#include "log.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

static buddy_t	*menu_get_buddy()
{
  GtkWidget	*item;
  GtkWidget	*menu;
  buddy_t	*buddy;

  menu = contacts_UIGetMenuBuddy();
  item = gtk_object_get_data(GTK_OBJECT(menu), "widget_menued");
  if (gtk_object_get_data(GTK_OBJECT(item), "type") == TYPE_BUDDY_INFO)
    {
      list_t	*tmp;
      info_t	*info;

      info = gtk_object_get_data(GTK_OBJECT(item), "info");
      tmp = listFind(conf->buddy, info->login, contactsCmpBuddy);
      buddy = tmp->data;
    }
  else
    buddy = gtk_object_get_data(GTK_OBJECT(item), "buddy");
  return (buddy);
}

static	void	send_message(GtkWidget *widget, buddy_t *buddy)
{
  int		i;
  message_t	*message = NULL;
  info_t	*info;

  if (gtk_object_get_data(GTK_OBJECT(widget), "type") == TYPE_BUDDY_INFO)
    {
      info = (info_t *)gtk_object_get_data(GTK_OBJECT(widget), "info");
      if (!(message = message_find_by_id(info->id)))
	message = message_new(MESSAGE_TYPE_STD, buddy->login, 
			      buddy->alias, info);
    }
  else if (buddy->nb_log == 1)
    {
      for (i = 0; i < MAX_LOG; i++)
	if (buddy->info[i].id > 0)
	  {
	    if (!(message = message_find_by_id(buddy->info[i].id)))
	      message = message_new(MESSAGE_TYPE_STD, buddy->login, 
				    buddy->alias, &buddy->info[i]);
	    break ;
	  }
    }
#ifdef __DEV
  else
    message = message_new(MESSAGE_TYPE_STD, buddy->login, 
			  buddy->alias, NULL);
#endif
  if (message)
    gtk_widget_show(message->window);
}

gboolean	on_offline_tree_button_press(GtkWidget *widget,
					     GdkEventButton *event,
					     gpointer data)
{
  static int	expanded = 0;
  list_t	*buddy;

  if (event->button != 1)
    return (gtk_true());
  buddy = conf->buddy;
  expanded ^= 1;
  gtk_object_set_data(GTK_OBJECT(widget), "expanded", (gpointer)expanded);
  while (buddy)
    {
      if (!((buddy_t *)buddy->data)->nb_log)
	{
	  if (expanded)
	    gtk_widget_show(((buddy_t *)buddy->data)->offline);
	  else
	    gtk_widget_hide(((buddy_t *)buddy->data)->offline);
	}
      buddy = buddy->next;
    }
  return (gtk_true());
}

gboolean	on_group_tree_button_press(GtkWidget *widget,
					   GdkEventButton *event,
					   gpointer data)
{
  list_t	*buddy;
  group_t	*group;
  int		i;

  if (event->button != 1)
    return (gtk_true());
  group = (group_t *)data;
  group->expanded ^= 1;
  for (buddy = conf->buddy; buddy; buddy = buddy->next)
    {
      if (((buddy_t *)buddy->data)->group == group)
	{
	  if (group->expanded)
	    {
	      if (((buddy_t *)buddy->data)->nb_log || !conf->offline_group)
		gtk_widget_show(((buddy_t *)buddy->data)->item);
	      if (((buddy_t *)buddy->data)->expanded && ((buddy_t *)buddy->data)->nb_log > 1)
		for (i = 0; i < MAX_LOG; i++)
		  if (((buddy_t *)buddy->data)->info[i].id > 0)
		    gtk_widget_show(((buddy_t *)buddy->data)->info[i].item);
	    }
	  else
	    {
	      gtk_widget_hide(((buddy_t *)buddy->data)->item);	    
	      for (i = 0; i < MAX_LOG; i++)
		if (((buddy_t *)buddy->data)->info[i].id > 0)
		  gtk_widget_hide(((buddy_t *)buddy->data)->info[i].item);
	    }
	}
    }
  return (gtk_true());
}

gboolean	on_item_contact_tree_button_press(GtkWidget *widget,
						  GdkEventButton *event,
						  gpointer data)
{
  buddy_t	*buddy;
  int		i;

  buddy = (buddy_t *)data;
  if (event->button != 1 || buddy->nb_log <= 1)
    return (gtk_true());
  buddy->expanded ^= 1;
  for (i = 0; i < MAX_LOG; i++)
    if (buddy->info[i].id > 0)
      {
	if (buddy->expanded)
	  gtk_widget_show(buddy->info[i].item);
	else
	  gtk_widget_hide(buddy->info[i].item);
      }
  return (gtk_true());
}

gboolean	on_item_enter_notify(GtkWidget *widget, 
				     GdkEventMotion *event,
				     GtkWidget *list)
{
  gtk_list_select_child(GTK_LIST(list), widget);
  return (FALSE);
}

int		on_item_dblclick(GtkWidget *widget,
				 GdkEventButton *event,
				 gpointer data)
{
  if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
    send_message(widget, data);
  return (0);
}

gboolean	on_Group_menu_rename(GtkMenuItem *widget, gpointer user_data)
{
  group_t	*group;
  GtkWidget	*item;
  GtkWidget	*label;
  GtkWidget	*menu;

  menu = contacts_UIGetMenuGroup();
  item = gtk_object_get_data(GTK_OBJECT(menu), "widget_menued");
  group = gtk_object_get_data(GTK_OBJECT(item), "group");  
  if (ControlPanel_UIEditGroup(group))
    {
      label = gtk_object_get_data(GTK_OBJECT(item), "label");  
      gtk_label_set(GTK_LABEL(label), group->name);
    }
  return FALSE;
}

gboolean	on_menu_add_buddy(GtkMenuItem *widget,
				  gpointer user_data)
{
  buddy_t	*buddy;
  GtkWidget	*item;
  GtkWidget	*menu;

  menu = contacts_UIGetMenuGroup();
  item = gtk_object_get_data(GTK_OBJECT(menu), "widget_menued");
  if ((buddy = ControlPanel_UINewBuddy()))
    {
      if (item)
	buddy->group = gtk_object_get_data(GTK_OBJECT(item), "group");
      putinlist(&conf->buddy, buddy);
      contacts_UIInsertBuddy(buddy);
      putinlist(&netsoul->watchlog, strdup(buddy->login));
      request_watch_log(netsoul->watchlog);
      request_cmd_who(buddy->login, NULL, -1);
    }
  gtk_object_set_data(GTK_OBJECT(menu), "widget_menued", NULL);  
  return FALSE;
}

gboolean	on_menu_add_group(GtkMenuItem *widget,
				  gpointer user_data)
{
  group_t	*group;

  if ((group = ControlPanel_UINewGroup()))
    {
      putinlist(&conf->group, group);
      contacts_UIInsertGroup(group);
    }
  return FALSE;
}

gboolean	on_menu_group_count(GtkMenuItem *widget,
				    gpointer user_data)
{
  list_t	*group;
  GtkWidget	*count;

  conf->group_count = (int)gtk_object_get_data(GTK_OBJECT(widget), "state");
  for (group = conf->group; group; group = group->next)
    {
      if (group->data && ((group_t *)group->data)->item)
	{
	  count = gtk_object_get_data(GTK_OBJECT(((group_t *)group->data)->item), "count");
	  if (conf->group_count)
	    gtk_widget_show(count);
	  else
	    gtk_widget_hide(count);
	}
    }
  return FALSE;
}

gboolean	on_menu_offline_contacts(GtkMenuItem *widget,
					 gpointer user_data)
{
  list_t	*buddy;
  int		expanded;
  GtkWidget	*offline_item;

  if (!(offline_item = contacts_UIGetOfflineGroup()))
    return FALSE;
  conf->offline_group = (int)gtk_object_get_data(GTK_OBJECT(widget), "state");
  expanded = (int)gtk_object_get_data(GTK_OBJECT(offline_item), "expanded");
  if (conf->offline_group)
    gtk_widget_show(offline_item);
  else
    gtk_widget_hide(offline_item);
  for (buddy = conf->buddy; buddy; buddy = buddy->next)
    {
      if (conf->offline_group)
	{
	  if (expanded && ((buddy_t *)buddy->data)->nb_log == 0)
	    gtk_widget_show(((buddy_t *)buddy->data)->offline);
	  if (((buddy_t *)buddy->data)->nb_log == 0)
	    gtk_widget_hide(((buddy_t *)buddy->data)->item);
	}
      else
	{
	  gtk_widget_hide(((buddy_t *)buddy->data)->offline);
	  if (!((buddy_t *)buddy->data)->group || ((buddy_t *)buddy->data)->group->expanded)
	    if (((buddy_t *)buddy->data)->nb_log == 0)
	      gtk_widget_show(((buddy_t *)buddy->data)->item);
	}
    }
  return FALSE;
}

gboolean	on_menu_auto_expand(GtkMenuItem *widget,
				    gpointer user_data)
{
  conf->auto_expand = (int)gtk_object_get_data(GTK_OBJECT(widget), "state");  
  return FALSE;
}

gboolean	on_menu_remove_group(GtkMenuItem *widget,
				     gpointer user_data)
{
  int		i;
  int		action;
  list_t	*list;
  buddy_t	*buddy;
  group_t	*group;
  GtkWidget	*item;
  GtkWidget	*menu;
  char		*str;

  menu = contacts_UIGetMenuGroup();
  if (!(item = gtk_object_get_data(GTK_OBJECT(menu), "widget_menued")))
    return FALSE;
  group = gtk_object_get_data(GTK_OBJECT(item), "group");
  asprintf(&str, "Remove group : %s ?", group->name);
  action = dialog_confirm(str, SKIN_REMOVE);
  free(str);
  if (action == FALSE)
    return FALSE;
  for (list = conf->buddy; list; )
    {
      buddy = (buddy_t *)list->data;
      if (buddy->group == group)
	{
	  for (i = 0; i < MAX_LOG; i++)
	    {
	      if (buddy->info[i].item)
		gtk_widget_destroy(buddy->info[i].item);
	      contactsFreeBuddyInfo(buddy, i);
	    }
	  gtk_widget_destroy(buddy->item);
	  gtk_widget_destroy(buddy->offline);
	  list = list->next;
	  listRemoveItemCmp(&netsoul->watchlog, buddy->login, strcmp, free);
	  listRemoveItem(&conf->buddy, buddy, contactsFreeBuddy);
	}
      else
	list = list->next;
    }
  gtk_widget_destroy(group->item);
  listRemoveItem(&conf->group, group, contactsFreeGroup);
  request_watch_log(netsoul->watchlog);
  return FALSE;
}

gboolean	on_menu_buddy_message(GtkMenuItem *widget,
				      gpointer user_data)
{
  GtkWidget	*item;
  GtkWidget	*menu;
  list_t	*tmp;
  info_t	*info;

  menu = contacts_UIGetMenuBuddy();
  item = gtk_object_get_data(GTK_OBJECT(menu), "widget_menued");
  if (gtk_object_get_data(GTK_OBJECT(item), "type") == TYPE_BUDDY_INFO)
    {
      info = gtk_object_get_data(GTK_OBJECT(item), "info");
      tmp = listFind(conf->buddy, info->login, contactsCmpBuddy);
      send_message(item, tmp->data);
    }
  else
    send_message(item, gtk_object_get_data(GTK_OBJECT(item), "buddy"));
  return FALSE;
}

gboolean	on_menu_buddy_rename(GtkMenuItem *widget,
				     gpointer user_data)
{
  buddy_t	*buddy;
  GtkWidget	*label;
  GtkWidget	*label_offline;
  GtkWidget	*alert;
  buddy_t	*mem;

  if (!(buddy = menu_get_buddy()))
    return FALSE;
  mem = contactsDupBuddy(buddy);
  if (ControlPanel_UIEditBuddy(mem))
    {
      label = gtk_object_get_data(GTK_OBJECT(buddy->item), "label");  
      label_offline = gtk_object_get_data(GTK_OBJECT(buddy->offline), "label");  
      if ((!buddy->alias && mem->alias) ||
	  (buddy->alias && mem->alias && strcmp(buddy->alias, mem->alias)))
	{
	  gtk_label_set(GTK_LABEL(label), mem->alias);
	  gtk_label_set(GTK_LABEL(label_offline), mem->alias);
	}
      else if (!mem->alias)
	{
	  gtk_label_set(GTK_LABEL(label), buddy->login);
	  gtk_label_set(GTK_LABEL(label_offline), buddy->login);
	}
      if (buddy->alias)
	free(buddy->alias);
      buddy->alias = mem->alias ? strdup(mem->alias) : DEFAULT_BUDDY_ALIAS;
      buddy->expand = mem->expand;
      buddy->alerte = mem->alerte;
      alert = gtk_object_get_data(GTK_OBJECT(buddy->item), "alert");
      if (buddy->alerte)
	gtk_widget_show(alert);
      else
	gtk_widget_hide(alert);
      alert = gtk_object_get_data(GTK_OBJECT(buddy->offline), "alert");
      if (buddy->alerte)
	gtk_widget_show(alert);
      else
	gtk_widget_hide(alert);
    }
  contactsFreeBuddy(mem);
  return FALSE;
}

gboolean	on_menu_buddy_block(GtkMenuItem *widget,
				    gpointer user_data)
{
  buddy_t	*buddy;

  if (!(buddy = menu_get_buddy()))
    return FALSE;
  contacts_UIBlock(buddy);
  return FALSE;
}

gboolean	on_menu_buddy_alert(GtkMenuItem *widget,
				    gpointer user_data)
{
  buddy_t	*buddy;
  GtkWidget	*alert;
  GtkWidget	*alert_offline;

  if (!(buddy = menu_get_buddy()))
    return FALSE;
  alert = gtk_object_get_data(GTK_OBJECT(buddy->item), "alert");
  alert_offline = gtk_object_get_data(GTK_OBJECT(buddy->offline), "alert");
  buddy->alerte ^= 1;
  if (buddy->alerte)
    {
      gtk_widget_show(alert);
      gtk_widget_show(alert_offline);
    }
  else
    {
      gtk_widget_hide(alert);
      gtk_widget_hide(alert_offline);
    }
  return FALSE;
}

gboolean	on_menu_buddy_remove(GtkMenuItem *widget,
				     gpointer user_data)
{
  buddy_t	*buddy;
  char		*str;

  if (!(buddy = menu_get_buddy()))
    return FALSE;
  asprintf(&str, "Remove buddy : %s ?", buddy->login);
  if (dialog_confirm(str, SKIN_REMOVE))
    {
      contacts_UIRemoveBuddy(buddy);
      listRemoveItemCmp(&netsoul->watchlog, buddy->login, strcmp, free);
      listRemoveItem(&conf->buddy, buddy, contactsFreeBuddy);
      request_watch_log(netsoul->watchlog);
    }
  free(str);  
  return FALSE;
}

gboolean	on_menu_group_mass_message(GtkMenuItem *widget,
					   gpointer user_data)
{
  list_t	*buddy;
  group_t	*group;
  GtkWidget	*item;
  GtkWidget	*menu;
  char		*logins = NULL;
  char		*alias = NULL;
  char		*tmp;
  message_t	*message;

  menu = contacts_UIGetMenuGroup();
  if (!(item = gtk_object_get_data(GTK_OBJECT(menu), "widget_menued")))
    return FALSE;
  group = gtk_object_get_data(GTK_OBJECT(item), "group");
  for (buddy = conf->buddy; buddy; buddy = buddy->next)
    {
      if (((buddy_t *)buddy->data)->group == group && ((buddy_t *)buddy->data)->nb_log > 0)
	{
	  tmp = logins;
	  asprintf(&logins, "%s%s%s", logins ? logins : "", logins ? "," : "", 
		   ((buddy_t *)buddy->data)->login);
	  if (tmp)
	    free(tmp);
	  tmp = alias;
	  asprintf(&alias, "%s%s%s", alias ? alias : "", alias ? " - " : "", 
		   ((buddy_t *)buddy->data)->alias ? 
		   ((buddy_t *)buddy->data)->alias : ((buddy_t *)buddy->data)->login);
	  if (tmp)
	    free(tmp);
	}
    }
  if (!(message = message_find(logins)))
    message = message_new(MESSAGE_TYPE_MASS, logins, alias, NULL);
  gtk_widget_show(message->window);
  free(logins);
  free(alias);
  return FALSE;
}

gboolean	on_menu_buddy_show_log(GtkMenuItem *widget,
				       gpointer user_data)
{
  buddy_t	*buddy;

  if (!(buddy = menu_get_buddy()))
    return FALSE;
  message_log_show(buddy->login, buddy->alias);
  return FALSE;
}
