/*
** dialog.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Fri Dec 12 05:23:30 2003 Anto
** Last update Fri Dec 12 20:32:56 2003 Anto
*/

#include "dialog.h"
#include "skin.h"
#include "list.h"
#include <string.h>
#include <stdlib.h>

static GtkWidget	*create_Confirm_Dialog(dialog_t *, char *, int);
static GtkWidget	*create_Input_Dialog(dialog_t *, char *, int);
static void		on_button_true_clicked(GtkButton *, gpointer);
static void		on_button_false_clicked(GtkButton *, gpointer);
static void		on_destroy(GtkObject *, gpointer);

static list_t		*dialog_list = NULL;

int		dialog_confirm(const char *question, int icon_id)
{
  dialog_t	*dialog;
  int		result;

  dialog = calloc(sizeof(dialog_t), 1);
  dialog->window = create_Confirm_Dialog(dialog, (char *)question, icon_id);
  putinlist(&dialog_list, dialog);
  gtk_widget_show(dialog->window);
  dialog->quit = DIALOG_FALSE;
  while (dialog->quit == DIALOG_FALSE)
    if (gtk_events_pending())
      gtk_main_iteration();
  result = dialog->quit;
  if (dialog->quit != DIALOG_DESTROY)
    gtk_widget_destroy(dialog->window);
  listRemoveItem(&dialog_list, dialog, free);
  return (result == DIALOG_YES);
}

char		*dialog_input(const char *input, int icon_id)
{
  dialog_t	*dialog;
  GtkWidget	*entry;
  char		*text;
  int		result;

  dialog = calloc(sizeof(dialog_t), 1);
  dialog->window = create_Input_Dialog(dialog, (char *)input, icon_id);
  putinlist(&dialog_list, dialog);
  gtk_widget_show(dialog->window);
  dialog->quit = DIALOG_FALSE;
  while (dialog->quit == DIALOG_FALSE)
    if (gtk_events_pending())
      gtk_main_iteration();
  result = dialog->quit;
  text = NULL;
  if (dialog->quit != DIALOG_DESTROY)
    {
      entry = gtk_object_get_data(GTK_OBJECT(dialog->window), "txtInput");
      text = gtk_entry_get_text(GTK_ENTRY(entry));
      text = (text && *text) ? strdup(text) : NULL;
      gtk_widget_destroy(dialog->window);
    }
  listRemoveItem(&dialog_list, dialog, free);
  if (result == DIALOG_DESTROY || result == DIALOG_NO || !text)
    return (NULL);
  return (text);
}

static GtkWidget	*create_Confirm_Dialog(dialog_t *dialog, char *question, int icon_id)
{
  GtkWidget		*Confirm_Dialog;
  GtkWidget		*table15;
  GtkWidget		*hbox12;
  GtkWidget		*lblQuestion;
  GtkWidget		*btnOK;
  GtkWidget		*btnCancel;
  GtkWidget		*pixmap;

  Confirm_Dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (Confirm_Dialog), "Confirm_Dialog", Confirm_Dialog);
  gtk_widget_set_usize (Confirm_Dialog, 250, 90);
  gtk_window_set_title (GTK_WINDOW (Confirm_Dialog), "NoSoucy - Confirm");
  gtk_window_set_position (GTK_WINDOW (Confirm_Dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (Confirm_Dialog), TRUE);
  gtk_window_set_policy (GTK_WINDOW (Confirm_Dialog), FALSE, FALSE, FALSE);

  table15 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table15);
  gtk_object_set_data_full (GTK_OBJECT (Confirm_Dialog), "table15", table15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table15);
  gtk_container_add (GTK_CONTAINER (Confirm_Dialog), table15);
  gtk_container_set_border_width (GTK_CONTAINER (table15), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table15), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table15), 5);

  hbox12 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox12);
  gtk_object_set_data_full (GTK_OBJECT (Confirm_Dialog), "hbox12", hbox12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox12);
  gtk_table_attach (GTK_TABLE (table15), hbox12, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  pixmap = gtk_pixmap_new (skin->icon[icon_id].pixmap, skin->icon[icon_id].mask);
  gtk_widget_ref (pixmap);
  gtk_object_set_data_full (GTK_OBJECT (Confirm_Dialog), "pixmap", pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap);
  gtk_box_pack_start (GTK_BOX (hbox12), pixmap, FALSE, FALSE, 5);

  lblQuestion = gtk_label_new (question);
  gtk_widget_ref (lblQuestion);
  gtk_object_set_data_full (GTK_OBJECT (Confirm_Dialog), "lblQuestion", lblQuestion,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblQuestion);
  gtk_label_set_line_wrap(GTK_LABEL(lblQuestion), TRUE);
  gtk_box_pack_start (GTK_BOX (hbox12), lblQuestion, FALSE, FALSE, 0);
  
  btnOK = gtk_button_new_with_label ("Yes");
  gtk_widget_ref (btnOK);
  gtk_object_set_data_full (GTK_OBJECT (Confirm_Dialog), "btnOK", btnOK,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnOK);
  gtk_table_attach (GTK_TABLE (table15), btnOK, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (btnOK, 117, -2);

  btnCancel = gtk_button_new_with_label ("No");
  gtk_widget_ref (btnCancel);
  gtk_object_set_data_full (GTK_OBJECT (Confirm_Dialog), "btnCancel", btnCancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnCancel);
  gtk_table_attach (GTK_TABLE (table15), btnCancel, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (btnCancel, 117, -2);

  gtk_signal_connect (GTK_OBJECT (btnOK), "clicked",
		      GTK_SIGNAL_FUNC (on_button_true_clicked),
		      (gpointer)dialog);
  gtk_signal_connect (GTK_OBJECT (btnCancel), "clicked",
		      GTK_SIGNAL_FUNC (on_button_false_clicked),
		      (gpointer)dialog);
  gtk_signal_connect (GTK_OBJECT (Confirm_Dialog), "destroy",
                      GTK_SIGNAL_FUNC (on_destroy),
                      (gpointer)dialog);
  gtk_widget_grab_focus(btnCancel);

  return Confirm_Dialog;
}

static GtkWidget	*create_Input_Dialog(dialog_t *dialog, char *input, int icon_id)
{
  GtkWidget		*Input_Dialog;
  GtkWidget		*table15;
  GtkWidget		*hbox12;
  GtkWidget		*lblInput;
  GtkWidget		*txtInput;
  GtkWidget		*btnOK;
  GtkWidget		*btnCancel;
  GtkWidget		*pixmap;

  Input_Dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (Input_Dialog), "Input_Dialog", Input_Dialog);
  gtk_widget_set_usize (Input_Dialog, 250, 90);
  gtk_window_set_title (GTK_WINDOW (Input_Dialog), "NoSoucy - Input");
  gtk_window_set_position (GTK_WINDOW (Input_Dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (Input_Dialog), TRUE);
  gtk_window_set_policy (GTK_WINDOW (Input_Dialog), FALSE, FALSE, FALSE);

  table15 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table15);
  gtk_object_set_data_full (GTK_OBJECT (Input_Dialog), "table15", table15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table15);
  gtk_container_add (GTK_CONTAINER (Input_Dialog), table15);
  gtk_container_set_border_width (GTK_CONTAINER (table15), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table15), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table15), 5);

  hbox12 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox12);
  gtk_object_set_data_full (GTK_OBJECT (Input_Dialog), "hbox12", hbox12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox12);
  gtk_table_attach (GTK_TABLE (table15), hbox12, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  pixmap = gtk_pixmap_new (skin->icon[icon_id].pixmap, skin->icon[icon_id].mask);
  gtk_widget_ref (pixmap);
  gtk_object_set_data_full (GTK_OBJECT (Input_Dialog), "pixmap", pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap);
  gtk_box_pack_start (GTK_BOX (hbox12), pixmap, FALSE, FALSE, 5);

  lblInput = gtk_label_new (input);
  gtk_widget_ref (lblInput);
  gtk_object_set_data_full (GTK_OBJECT (Input_Dialog), "lblInput", lblInput,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblInput);
  gtk_box_pack_start (GTK_BOX (hbox12), lblInput, FALSE, FALSE, 0);

  txtInput = gtk_entry_new ();
  gtk_widget_ref (txtInput);
  gtk_object_set_data_full (GTK_OBJECT (Input_Dialog), "txtInput", txtInput,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (txtInput);
  gtk_widget_set_usize(txtInput, 75, -2);
  gtk_box_pack_start (GTK_BOX (hbox12), txtInput, FALSE, FALSE, 0);

  btnOK = gtk_button_new_with_label ("OK");
  gtk_widget_ref (btnOK);
  gtk_object_set_data_full (GTK_OBJECT (Input_Dialog), "btnOK", btnOK,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnOK);
  gtk_table_attach (GTK_TABLE (table15), btnOK, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (btnOK, 117, -2);

  btnCancel = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (btnCancel);
  gtk_object_set_data_full (GTK_OBJECT (Input_Dialog), "btnCancel", btnCancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnCancel);
  gtk_table_attach (GTK_TABLE (table15), btnCancel, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (btnCancel, 117, -2);

  gtk_signal_connect (GTK_OBJECT (btnOK), "clicked",
		      GTK_SIGNAL_FUNC (on_button_true_clicked),
		      (gpointer)dialog);
  gtk_signal_connect (GTK_OBJECT (btnCancel), "clicked",
		      GTK_SIGNAL_FUNC (on_button_false_clicked),
		      (gpointer)dialog);
  gtk_signal_connect (GTK_OBJECT (Input_Dialog), "destroy",
                      GTK_SIGNAL_FUNC (on_destroy),
                      (gpointer)dialog);
  gtk_signal_connect (GTK_OBJECT (txtInput), "activate",
                      GTK_SIGNAL_FUNC (on_button_true_clicked),
                      (gpointer)dialog);
  gtk_widget_grab_focus(txtInput);

  return Input_Dialog;
}

static void	on_button_true_clicked(GtkButton *button, gpointer dialog)
{
  ((dialog_t *)dialog)->quit = DIALOG_YES;
}

static void	on_button_false_clicked(GtkButton *button, gpointer dialog)
{
  ((dialog_t *)dialog)->quit = DIALOG_NO;
}

static void	on_destroy(GtkObject *object, gpointer dialog)
{
  ((dialog_t *)dialog)->quit = DIALOG_DESTROY;
}
