/*
** str_to_wordtab.c for  in 
** 
** Made by anthony herrero
** Login   <herrer_a@epita.fr>
** 
** Started on  Mon Oct 23 09:21:06 2000 anthony herrero
** Last update Wed Jul 23 07:26:50 2003 Anto
*/

#include <stdlib.h>
#include <stdio.h>
#include "tab.h"

static char	*get_begin(char *s, char *sep)
{
  int	i;

  for (i = 0; sep[i]; i++)
    if (sep[i] == *s)
      return (s + 1);
  return (s);
}

static char	*get_end(char *s, char *sep)
{
  int		i;

  while (*s)
    {
      for (i = 0; sep[i]; i++)
	if (sep[i] == *s)
	  return (s);
      s++;
    }
  return (s);
}

char	*my_strndup(char *str, int n)
{
  char	*tmp;
  int	i;

  tmp = malloc((n + 1) * sizeof (char));
  for (i = 0; i < n; i++)
    tmp[i] = str[i];
  tmp[i] = 0;
  return (tmp);
}

char	**tab_str(char *str, char *sep)
{
  char	*s;
  char	*fin;
  int	count;
  char	**tab;
  
  if (!str)
    return (NULL);
  for (s = get_begin(str, sep), count = 0; *s; count++)
    s = get_begin(get_end(s, sep), sep);
  tab = malloc((count + 1) * sizeof(char *));
  for (s = get_begin(str, sep), count = 0; *s; count++)
    {
      fin = get_end(s, sep);
      tab[count] = my_strndup(s, fin - s);
      s = get_begin(fin, sep);
    }
  tab[count] = 0;
  return (tab);
}

void	tab_free(char **tab)
{
  int	i;

  for (i = 0; tab && tab[i] != NULL; i++)
    free(tab[i]);
  free(tab);
}

int	tab_len(char **tab)
{
  int	i;

  for (i = 0; tab && tab[i] != NULL; i++)
    ;
  return (i);
}

void	tab_show(char **tab)
{
  int	i;

  for (i = 0; tab && tab[i] != NULL; i++)
    printf("\t=>%s<=\n", tab[i]);
}
