/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.nat.DatagramListener;
import org.jivesoftware.smackx.jingle.nat.ResultListener;
import org.jivesoftware.smackx.jingle.nat.TestResult;
import org.jivesoftware.smackx.jingle.nat.TransportResolverListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportCandidate {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(TransportCandidate.class);
    private String name;
    private String ip;
    private int port;
    private String localIp;
    private int generation;
    protected String password;
    private String sessionId;
    private XMPPConnection connection;
    private TransportCandidate symmetric;
    private CandidateEcho candidateEcho = null;
    private Thread echoThread = null;
    private final List<TransportResolverListener.Checker> listeners = new ArrayList<TransportResolverListener.Checker>();

    public void addCandidateEcho(JingleSession jingleSession) throws SocketException, UnknownHostException {
        this.candidateEcho = new CandidateEcho(this, jingleSession);
        this.echoThread = new Thread(this.candidateEcho);
        this.echoThread.start();
    }

    public void removeCandidateEcho() {
        if (this.candidateEcho != null) {
            this.candidateEcho.cancel();
        }
        this.candidateEcho = null;
        this.echoThread = null;
    }

    public CandidateEcho getCandidateEcho() {
        return this.candidateEcho;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public String getLocalIp() {
        return this.localIp == null ? this.ip : this.localIp;
    }

    public void setLocalIp(String string) {
        this.localIp = string;
    }

    public TransportCandidate getSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(TransportCandidate transportCandidate) {
        this.symmetric = transportCandidate;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public TransportCandidate() {
        this(null, 0, 0);
    }

    public TransportCandidate(String string, int n) {
        this(string, n, 0);
    }

    public TransportCandidate(String string, int n, int n2) {
        this.ip = string;
        this.port = n;
        this.generation = n2;
    }

    public boolean isNull() {
        if (this.ip == null) {
            return true;
        }
        if (this.ip.length() == 0) {
            return true;
        }
        return this.port < 0;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int n) {
        this.generation = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransportCandidate transportCandidate = (TransportCandidate)object;
        if (this.generation != transportCandidate.generation) {
            return false;
        }
        if (this.getIp() == null ? transportCandidate.getIp() != null : !this.getIp().equals(transportCandidate.getIp())) {
            return false;
        }
        if (this.getPort() != transportCandidate.getPort()) {
            return false;
        }
        if (this.getName() == null ? transportCandidate.getName() != null : !this.getName().equals(transportCandidate.getName())) {
            return false;
        }
        return this.getPort() == transportCandidate.getPort();
    }

    public void check(List<TransportCandidate> list) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                boolean bl;
                try {
                    InetAddress inetAddress = InetAddress.getByName(TransportCandidate.this.getIp());
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                TransportCandidate.this.triggerCandidateChecked(bl);
            }
        }, "Transport candidate check");
        thread.setName("Transport candidate test");
        thread.start();
    }

    void triggerCandidateChecked(boolean bl) {
        for (TransportResolverListener.Checker checker : this.getListenersList()) {
            checker.candidateChecked(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransportResolverListener.Checker> getListenersList() {
        List<TransportResolverListener.Checker> list = this.listeners;
        synchronized (list) {
            return new ArrayList<TransportResolverListener.Checker>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TransportResolverListener.Checker checker) {
        List<TransportResolverListener.Checker> list = this.listeners;
        synchronized (list) {
            this.listeners.add(checker);
        }
    }

    public class CandidateEcho
    implements Runnable {
        DatagramSocket socket = null;
        String localUser = null;
        String remoteUser = null;
        String id = null;
        byte[] send = null;
        byte[] receive = null;
        DatagramPacket sendPacket = null;
        List<DatagramListener> listeners = new ArrayList<DatagramListener>();
        List<ResultListener> resultListeners = new ArrayList<ResultListener>();
        boolean enabled = true;
        boolean ended = false;
        long replyTries = 2L;
        long tries = 10L;
        TransportCandidate candidate = null;

        public CandidateEcho(TransportCandidate transportCandidate2, JingleSession jingleSession) throws UnknownHostException, SocketException {
            this.socket = new DatagramSocket(transportCandidate2.getPort(), InetAddress.getByName(transportCandidate2.getLocalIp()));
            this.localUser = jingleSession.getInitiator();
            this.remoteUser = jingleSession.getResponder();
            this.id = jingleSession.getSid();
            this.candidate = transportCandidate2;
            int n = (int)Math.ceil((float)this.id.length() / 2.0f);
            String string = this.id.substring(0, n) + ";" + this.localUser;
            String string2 = this.id.substring(n) + ";" + this.remoteUser;
            try {
                if (jingleSession.getConnection().getUser().equals(jingleSession.getInitiator())) {
                    this.send = string.getBytes("UTF-8");
                    this.receive = string2.getBytes("UTF-8");
                } else {
                    this.receive = string.getBytes("UTF-8");
                    this.send = string2.getBytes("UTF-8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }

        /*
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                TransportCandidate.access$000().debug("Listening for ECHO: " + this.socket.getLocalAddress().getHostAddress() + ":" + this.socket.getLocalPort());
                block9: while (true) {
                    var1_1 = new DatagramPacket(new byte[150], 150);
                    this.socket.receive(var1_1);
                    var2_6 = false;
                    var3_7 = ByteBuffer.wrap(var1_1.getData());
                    var4_8 = new byte[var1_1.getLength()];
                    var3_7 = var3_7.get(var4_8, 0, var1_1.getLength());
                    var1_1.setData(var4_8);
                    var5_10 = this.listeners.iterator();
                    while (var5_10.hasNext() && !(var2_6 = (var6_11 = var5_10.next()).datagramReceived(var1_1))) {
                    }
                    var5_9 = 100L / this.replyTries;
                    var7_12 = new String(var1_1.getData(), "UTF-8").split(";");
                    var8_13 = var7_12[0];
                    var9_14 = var7_12[1].split(":");
                    var10_15 = var9_14[0];
                    var11_16 = var9_14[1];
                    if (!var8_13.equals(this.candidate.getPassword()) || var2_6) continue;
                    var12_17 = null;
                    try {
                        var12_17 = (TransportCandidate.this.password + ";" + this.candidate.getIp() + ":" + this.candidate.getPort()).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException var13_19) {
                        var13_19.printStackTrace();
                    }
                    var1_1.setData(var12_17);
                    var1_1.setLength(var12_17.length);
                    var1_1.setAddress(InetAddress.getByName(var10_15));
                    var1_1.setPort(Integer.parseInt(var11_16));
                    var13_18 = 0;
                    while (true) {
                        if ((long)var13_18 >= this.replyTries) continue block9;
                        this.socket.send(var1_1);
                        if (this.enabled) ** break;
                        continue block9;
                        try {
                            Thread.sleep(var5_9);
                        }
                        catch (InterruptedException var14_20) {
                            var14_20.printStackTrace();
                        }
                        ++var13_18;
                    }
                    break;
                }
            }
            catch (UnknownHostException var1_2) {
                if (!this.enabled) return;
            }
            catch (SocketException var1_3) {
                if (!this.enabled) return;
            }
            catch (IOException var1_4) {
                if (!this.enabled) return;
            }
            catch (Exception var1_5) {
                if (!this.enabled) return;
            }
        }

        public void cancel() {
            this.enabled = false;
            this.socket.close();
        }

        private void fireTestResult(TestResult testResult, TransportCandidate transportCandidate) {
            for (ResultListener resultListener : this.resultListeners) {
                resultListener.testFinished(testResult, transportCandidate);
            }
        }

        public void testASync(final TransportCandidate transportCandidate, final String string) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    DatagramListener datagramListener = new DatagramListener(){

                        public boolean datagramReceived(DatagramPacket datagramPacket) {
                            try {
                                LOGGER.debug("ECHO Received to: " + CandidateEcho.this.candidate.getIp() + ":" + CandidateEcho.this.candidate.getPort() + "  data: " + new String(datagramPacket.getData(), "UTF-8"));
                                String[] stringArray = new String(datagramPacket.getData(), "UTF-8").split(";");
                                String string = stringArray[0];
                                String[] stringArray2 = stringArray[1].split(":");
                                String string2 = stringArray2[0];
                                String string3 = stringArray2[1];
                                if (string.equals(string) && transportCandidate.getIp().indexOf(string2) != -1 && transportCandidate.getPort() == Integer.parseInt(string3)) {
                                    LOGGER.debug("ECHO OK: " + CandidateEcho.this.candidate.getIp() + ":" + CandidateEcho.this.candidate.getPort() + " <-> " + transportCandidate.getIp() + ":" + transportCandidate.getPort());
                                    TestResult testResult = new TestResult();
                                    testResult.setResult(true);
                                    CandidateEcho.this.ended = true;
                                    CandidateEcho.this.fireTestResult(testResult, transportCandidate);
                                    return true;
                                }
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                unsupportedEncodingException.printStackTrace();
                            }
                            LOGGER.debug("ECHO Wrong Data: " + datagramPacket.getAddress().getHostAddress() + ":" + datagramPacket.getPort());
                            return false;
                        }
                    };
                    CandidateEcho.this.addListener(datagramListener);
                    byte[] byArray = null;
                    try {
                        byArray = new String(string + ";" + TransportCandidate.this.getIp() + ":" + TransportCandidate.this.getPort()).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    try {
                        datagramPacket.setAddress(InetAddress.getByName(transportCandidate.getIp()));
                    }
                    catch (UnknownHostException unknownHostException) {
                        unknownHostException.printStackTrace();
                    }
                    datagramPacket.setPort(transportCandidate.getPort());
                    long l = 200L;
                    try {
                        int n = 0;
                        while ((long)n < CandidateEcho.this.tries) {
                            CandidateEcho.this.socket.send(datagramPacket);
                            if (CandidateEcho.this.ended) break;
                            try {
                                Thread.sleep(l);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            ++n;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    CandidateEcho.this.removeListener(datagramListener);
                }
            });
            thread.start();
        }

        public void addListener(DatagramListener datagramListener) {
            this.listeners.add(datagramListener);
        }

        public void removeListener(DatagramListener datagramListener) {
            this.listeners.remove(datagramListener);
        }

        public void addResultListener(ResultListener resultListener) {
            this.resultListeners.add(resultListener);
        }

        public void removeResultListener(ResultListener resultListener) {
            this.resultListeners.remove(resultListener);
        }
    }

    public static class Channel {
        public static final Channel MYRTPVOICE = new Channel("myrtpvoice");
        public static final Channel MYRTCPVOICE = new Channel("myrtcpvoice");
        private String value;

        public Channel(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }

        public static Channel fromString(String string) {
            if (string == null) {
                return MYRTPVOICE;
            }
            if ((string = string.toLowerCase()).equals("myrtpvoice")) {
                return MYRTPVOICE;
            }
            if (string.equals("tcp")) {
                return MYRTCPVOICE;
            }
            return MYRTPVOICE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Channel channel = (Channel)object;
            return !(this.value == null ? channel.value != null : !this.value.equals(channel.value));
        }

        public boolean isNull() {
            if (this.value == null) {
                return true;
            }
            return this.value.length() == 0;
        }
    }

    public static class Protocol {
        public static final Protocol UDP = new Protocol("udp");
        public static final Protocol TCP = new Protocol("tcp");
        public static final Protocol TCPACT = new Protocol("tcp-act");
        public static final Protocol TCPPASS = new Protocol("tcp-pass");
        public static final Protocol SSLTCP = new Protocol("ssltcp");
        private String value;

        public Protocol(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }

        public static Protocol fromString(String string) {
            if (string == null) {
                return UDP;
            }
            if ((string = string.toLowerCase()).equals("udp")) {
                return UDP;
            }
            if (string.equals("tcp")) {
                return TCP;
            }
            if (string.equals("tcp-act")) {
                return TCPACT;
            }
            if (string.equals("tcp-pass")) {
                return TCPPASS;
            }
            if (string.equals("ssltcp")) {
                return SSLTCP;
            }
            return UDP;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Protocol protocol = (Protocol)object;
            return !(this.value == null ? protocol.value != null : !this.value.equals(protocol.value));
        }

        public boolean isNull() {
            if (this.value == null) {
                return true;
            }
            return this.value.length() == 0;
        }
    }

    public static class Fixed
    extends TransportCandidate {
        public Fixed() {
        }

        public Fixed(String string, int n) {
            super(string, n);
        }

        public Fixed(String string, int n, int n2) {
            super(string, n, n2);
        }
    }
}

