/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class FileTransferManager {
    private final FileTransferNegotiator fileTransferNegotiator;
    private List<FileTransferListener> listeners;
    private Connection connection;

    public FileTransferManager(Connection connection) {
        this.connection = connection;
        this.fileTransferNegotiator = FileTransferNegotiator.getInstanceFor(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileTransferListener(FileTransferListener fileTransferListener) {
        if (this.listeners == null) {
            this.initListeners();
        }
        List<FileTransferListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(fileTransferListener);
        }
    }

    private void initListeners() {
        this.listeners = new ArrayList<FileTransferListener>();
        this.connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                FileTransferManager.this.fireNewRequest((StreamInitiation)packet);
            }
        }, new AndFilter(new PacketTypeFilter(StreamInitiation.class), new IQTypeFilter(IQ.Type.SET)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNewRequest(StreamInitiation streamInitiation) {
        FileTransferListener[] fileTransferListenerArray = null;
        Object object = this.listeners;
        synchronized (object) {
            fileTransferListenerArray = new FileTransferListener[this.listeners.size()];
            this.listeners.toArray(fileTransferListenerArray);
        }
        object = new FileTransferRequest(this, streamInitiation);
        for (int i = 0; i < fileTransferListenerArray.length; ++i) {
            fileTransferListenerArray[i].fileTransferRequest((FileTransferRequest)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileTransferListener(FileTransferListener fileTransferListener) {
        if (this.listeners == null) {
            return;
        }
        List<FileTransferListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(fileTransferListener);
        }
    }

    public OutgoingFileTransfer createOutgoingFileTransfer(String string) {
        return new OutgoingFileTransfer(this.connection.getUser(), string, this.fileTransferNegotiator.getNextStreamID(), this.fileTransferNegotiator);
    }

    protected IncomingFileTransfer createIncomingFileTransfer(FileTransferRequest fileTransferRequest) {
        if (fileTransferRequest == null) {
            throw new NullPointerException("RecieveRequest cannot be null");
        }
        IncomingFileTransfer incomingFileTransfer = new IncomingFileTransfer(fileTransferRequest, this.fileTransferNegotiator);
        incomingFileTransfer.setFileInfo(fileTransferRequest.getFileName(), fileTransferRequest.getFileSize());
        return incomingFileTransfer;
    }

    protected void rejectIncomingFileTransfer(FileTransferRequest fileTransferRequest) {
        StreamInitiation streamInitiation = fileTransferRequest.getStreamInitiation();
        IQ iQ = FileTransferNegotiator.createIQ(streamInitiation.getPacketID(), streamInitiation.getFrom(), streamInitiation.getTo(), IQ.Type.ERROR);
        iQ.setError(new XMPPError(XMPPError.Condition.no_acceptable));
        this.connection.sendPacket(iQ);
    }
}

