/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.umlgraph.doclet.ContextView;
import org.umlgraph.doclet.Options;
import org.umlgraph.doclet.PackageView;
import org.umlgraph.doclet.UmlGraph;
import org.umlgraph.doclet.Version;
import org.umlgraph.doclet.WrappedRootDoc;

public class UmlGraphDoc {
    private static final String UML_DIV_TAG = "<div align=\"center\"><img src=\"%1$s.png\" alt=\"Package class diagram package %1$s\" usemap=\"#G\" border=0/></div>";
    private static final String EXPANDABLE_UML = "<script type=\"text/javascript\">\nfunction show() {\n    document.getElementById(\"uml\").innerHTML = \n        '<a style=\"font-family:monospace\" href=\"javascript:hide()\">%3$s</a>' +\n        '%1$s';\n}\nfunction hide() {\n\tdocument.getElementById(\"uml\").innerHTML = \n\t'<a style=\"font-family:monospace\" href=\"javascript:show()\">%2$s</a>' ;\n}\n</script>\n<div id=\"uml\" >\n\t<a href=\"javascript:show()\">\n\t<a style=\"font-family:monospace\" href=\"javascript:show()\">%2$s</a> \n</div>";

    public static int optionLength(String option) {
        int result = Standard.optionLength((String)option);
        if (result != 0) {
            return result;
        }
        return UmlGraph.optionLength(option);
    }

    public static boolean start(RootDoc root) {
        root.printNotice("UmlGraphDoc version " + Version.VERSION + ", running the standard doclet");
        Standard.start((RootDoc)root);
        root.printNotice("UmlGraphDoc version " + Version.VERSION + ", altering javadocs");
        try {
            String outputFolder = UmlGraphDoc.findOutputPath(root.options());
            Options opt = new Options();
            opt.setOptions(root.options());
            opt.showEnumerations = true;
            opt.relativeLinksForSourcePackages = true;
            opt.strictMatching = true;
            root = new WrappedRootDoc(root);
            UmlGraphDoc.generatePackageDiagrams(root, opt, outputFolder);
            UmlGraphDoc.generateContextDiagrams(root, opt, outputFolder);
        }
        catch (Throwable t) {
            root.printWarning("Error!");
            root.printWarning(t.toString());
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return Standard.languageVersion();
    }

    private static void generatePackageDiagrams(RootDoc root, Options opt, String outputFolder) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        for (ClassDoc classDoc : root.classes()) {
            PackageDoc packageDoc = classDoc.containingPackage();
            if (packages.contains(packageDoc.name())) continue;
            packages.add(packageDoc.name());
            PackageView view = new PackageView(outputFolder, packageDoc, root, opt);
            UmlGraph.buildGraph(root, view, (Doc)packageDoc);
            UmlGraphDoc.runGraphviz(outputFolder, packageDoc.name(), packageDoc.name(), root);
            UmlGraphDoc.alterHtmlDocs(opt, outputFolder, packageDoc.name(), packageDoc.name(), "package-summary.html", Pattern.compile("</H2>"), root);
        }
    }

    private static void generateContextDiagrams(RootDoc root, Options opt, String outputFolder) throws IOException {
        ContextView view = null;
        for (ClassDoc classDoc : root.classes()) {
            if (view == null) {
                view = new ContextView(outputFolder, classDoc, root, opt);
            } else {
                view.setContextCenter(classDoc);
            }
            UmlGraph.buildGraph(root, view, (Doc)classDoc);
            UmlGraphDoc.runGraphviz(outputFolder, classDoc.containingPackage().name(), classDoc.name(), root);
            UmlGraphDoc.alterHtmlDocs(opt, outputFolder, classDoc.containingPackage().name(), classDoc.name(), classDoc.name() + ".html", Pattern.compile("(Class|Interface|Enum) " + classDoc.name() + ".*"), root);
        }
    }

    private static void runGraphviz(String outputFolder, String packageName, String name, RootDoc root) {
        File dotFile = new File(outputFolder, packageName.replace(".", "/") + "/" + name + ".dot");
        File pngFile = new File(outputFolder, packageName.replace(".", "/") + "/" + name + ".png");
        File mapFile = new File(outputFolder, packageName.replace(".", "/") + "/" + name + ".map");
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"dot", "-Tcmapx", "-o", mapFile.getAbsolutePath(), "-Tpng", "-o", pngFile.getAbsolutePath(), dotFile.getAbsolutePath()});
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                root.printWarning(line);
            }
            int result = p.waitFor();
            if (result != 0) {
                root.printWarning("Errors running Graphviz on " + dotFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Ensure that dot is in your path and that its path does not contain spaces");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void alterHtmlDocs(Options opt, String outputFolder, String packageName, String className, String htmlFileName, Pattern insertPointPattern, RootDoc root) throws IOException {
        File output = new File(outputFolder, packageName.replace(".", "/"));
        File htmlFile = new File(output, htmlFileName);
        File alteredFile = new File(htmlFile.getAbsolutePath() + ".uml");
        File mapFile = new File(output, className + ".map");
        if (!htmlFile.exists()) {
            System.err.println("Expected file not found: " + htmlFile.getAbsolutePath());
            return;
        }
        BufferedWriter writer = null;
        BufferedReader reader = null;
        boolean matched = false;
        try {
            String line;
            int BUFSIZE = (int)Math.pow(2.0, 20.0);
            writer = new BufferedWriter(new FileWriter(alteredFile), BUFSIZE);
            reader = new BufferedReader(new FileReader(htmlFile));
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
                if (matched || !insertPointPattern.matcher(line).matches()) continue;
                matched = true;
                if (mapFile.exists()) {
                    UmlGraphDoc.insertClientSideMap(mapFile, writer);
                } else {
                    root.printWarning("Could not find map file " + mapFile);
                }
                String tag = String.format(UML_DIV_TAG, className);
                if (opt.collapsibleDiagrams) {
                    tag = String.format(EXPANDABLE_UML, tag, "Show UML class diagram", "Hide UML class diagram");
                }
                writer.write("<!-- UML diagram added by UMLGraph version " + Version.VERSION + " (http://www.umlgraph.org/) -->");
                writer.newLine();
                writer.write(tag);
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        if (matched) {
            htmlFile.delete();
            alteredFile.renameTo(htmlFile);
        } else {
            root.printNotice("Warning, could not find a line that matches the pattern '" + insertPointPattern.pattern() + "'.\n Class diagram reference not inserted");
            alteredFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertClientSideMap(File mapFile, BufferedWriter writer) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(mapFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static String findOutputPath(String[][] options) {
        for (int i = 0; i < options.length; ++i) {
            if (!options[i][0].equals("-d")) continue;
            return options[i][1];
        }
        return ".";
    }
}

