package com.beem.project.beem.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.app.ExpandableListActivity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.widget.ExpandableListAdapter;
import android.widget.SimpleExpandableListAdapter;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.aidl.IBeemConnectionListener;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXMPPConnection;
import com.beem.project.beem.service.aidl.IXMPPFacade;

public class ContactList extends ExpandableListActivity {

    private static final String TAG = "CONTACTLIST_ACT";
    
    private IXMPPFacade mService = null;

    private BeemApplication mBeemApplication;
    
    @Override
    public void onCreate(Bundle saveBundle) {
        super.onCreate(saveBundle);
        mBeemApplication = BeemApplication.getApplication(this);
        mBeemApplication.startBeemService();
        mService = mBeemApplication.getXmppFacade();
        /* bindService(new Intent(this, BeemService.class), mConnection,
                BIND_AUTO_CREATE | BIND_DEBUG_UNBIND); */
        showContactList();
    }

    private void showContactList() {
        ExpandableListAdapter Adapter;
        
        List<Map<String, String>> groupData = new ArrayList<Map<String, String>>();
        List<List<Map<String, String>>> childData = new ArrayList<List<Map<String, String>>>();

        for (int i = 0; i < 2; i++) {
            Map<String, String> curGroupMap = new HashMap<String, String>();
            groupData.add(curGroupMap);
            curGroupMap.put("NAME", "Group " + i);
            
            List<Map<String, String>> children = new ArrayList<Map<String, String>>();
            for (int j = 0; j < 5; j++) {
                Map<String, String> curChildMap = new HashMap<String, String>();
                children.add(curChildMap);
                curChildMap.put("NAOME CHILD", "Child " + j);                
            }
            childData.add(children);
        }

        Adapter = new SimpleExpandableListAdapter(this, 
                groupData, R.layout.contactlistgroup,
                new String[] {"NAME"}, new int[] {R.id.textgroup},
                childData, R.layout.contactlist,
                new String[] {"NAME CHILD"}, new int[] {R.id.textchild});
        setListAdapter(Adapter);
    }

    private ServiceConnection mConnection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            mService = IXMPPFacade.Stub.asInterface(service);
            try {
		IXMPPConnection con = mService.createConnection();
		con.addConnectionListener(new TestConnectionListener());
		mService.connectSync();
		Log.i("BEEM", "Connected !!!");
	    } catch (RemoteException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	    }
            
            /*
             * mService.getGroupList(); mService.getContactList();
             */
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }

    };

    @Override
    public void onDestroy() {
        super.onDestroy();
        unbindService(mConnection);
    }

    private class TestConnectionListener extends IBeemConnectionListener.Stub {

	@Override
	public void connectionClosed() throws RemoteException {
	    // TODO Auto-generated method stub
	    
	}

	@Override
	public void connectionClosedOnError() throws RemoteException {
	    // TODO Auto-generated method stub
	    
	}

	@Override
	public void onConnect() throws RemoteException {
	    // TODO Auto-generated method stub
	    IRoster roster = mService.getRoster();
	    for (Contact contact : roster.getContactList()) {
		Log.v(TAG,"Contact name " + contact.getJID() );
	    }
	    showContactList();
	}

	@Override
	public void reconnectingIn(int seconds) throws RemoteException {
	    // TODO Auto-generated method stub
	    
	}

	@Override
	public void reconnectionFailed() throws RemoteException {
	    // TODO Auto-generated method stub
	    
	}

	@Override
	public void reconnectionSuccessful() throws RemoteException {
	    // TODO Auto-generated method stub
	    
	}
	
    } 
    
}
