package com.beem.project.beem;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.os.RemoteException;
import android.widget.Toast;

import com.beem.project.beem.service.XmppConnectionAdapter;
import com.beem.project.beem.service.XmppFacade;
import com.beem.project.beem.service.aidl.IBeemConnectionListener;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.service.aidl.IXmppConnection;

/**
 * This class is for the Beem service.
 * The connection to the xmpp server will be made asynchronously when the service
 * will start.
 * @author darisk
 */
public class BeemService extends Service {

    /**
     * The id to use for status notification.
     */
    public static final int NOTIFICATION_STATUS_ID = 1;

    private NotificationManager mNotificationManager;
    private IXmppConnection mConnection;
    private SharedPreferences mSettings;
    private String mLogin;
    private String mPassword;
    private String mHost;


    private IXmppFacade.Stub mBind;

    /**
     * Constructor.
     */
    public BeemService() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IBinder onBind(Intent intent) {
	return mBind;
	// to forbid a client to bind
	// return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onCreate() {
	super.onCreate();
	mSettings = getSharedPreferences(getString(R.string.PreferenceFileName), MODE_PRIVATE);
	mLogin = mSettings.getString(getString(R.string.PreferenceLoginKey), "");
	mPassword = mSettings.getString(getString(R.string.PreferencePasswordKey), "");
	mHost = mSettings.getString(getString(R.string.PreferenceHostKey), "");
	mNotificationManager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
	mConnection = new XmppConnectionAdapter("10.0.2.2", mLogin, mPassword); // address
	mBind = new XmppFacade(mConnection, this);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onStart(Intent intent, int startId) {
	try {
	    mConnection.connectAsync();
	} catch (RemoteException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onDestroy() {
	closeConnection();
	mNotificationManager.cancel(NOTIFICATION_STATUS_ID);
    }

    /**
     * Close the connection to the xmpp server.
     */
    private void closeConnection() {
	if (mConnection != null)
	    try {
		mConnection.disconnect();
	    } catch (RemoteException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	    }
    }

    /**
     * Show a notification.
     * @param id 	the id of the notification.
     * @param notif	the notification to show
     */
    public void sendNotification(int id, Notification notif) {
	mNotificationManager.notify(id, notif);
    }
}
