/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.Properties;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.WrapperConfiguration;

public class WrapperExecutor {
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String DISTRIBUTION_BASE_PROPERTY = "distributionBase";
    public static final String ZIP_STORE_BASE_PROPERTY = "zipStoreBase";
    public static final String DISTRIBUTION_PATH_PROPERTY = "distributionPath";
    public static final String ZIP_STORE_PATH_PROPERTY = "zipStorePath";
    private final Properties properties;
    private final File propertiesFile;
    private final Appendable warningOutput;
    private final WrapperConfiguration config = new WrapperConfiguration();

    public static WrapperExecutor forProjectDirectory(File projectDir, Appendable warningOutput) {
        return new WrapperExecutor(new File(projectDir, "gradle/wrapper/gradle-wrapper.properties"), new Properties(), warningOutput);
    }

    public static WrapperExecutor forWrapperPropertiesFile(File propertiesFile, Appendable warningOutput) {
        if (!propertiesFile.exists()) {
            throw new RuntimeException(String.format("Wrapper properties file '%s' does not exist.", propertiesFile));
        }
        return new WrapperExecutor(propertiesFile, new Properties(), warningOutput);
    }

    WrapperExecutor(File propertiesFile, Properties properties, Appendable warningOutput) {
        this.properties = properties;
        this.propertiesFile = propertiesFile;
        this.warningOutput = warningOutput;
        if (propertiesFile.exists()) {
            try {
                WrapperExecutor.loadProperties(propertiesFile, properties);
                this.config.setDistribution(this.prepareDistributionUri());
                this.config.setDistributionBase(this.getProperty(DISTRIBUTION_BASE_PROPERTY, this.config.getDistributionBase()));
                this.config.setDistributionPath(this.getProperty(DISTRIBUTION_PATH_PROPERTY, this.config.getDistributionPath()));
                this.config.setZipBase(this.getProperty(ZIP_STORE_BASE_PROPERTY, this.config.getZipBase()));
                this.config.setZipPath(this.getProperty(ZIP_STORE_PATH_PROPERTY, this.config.getZipPath()));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not load wrapper properties from '%s'.", propertiesFile), e);
            }
        }
    }

    private URI prepareDistributionUri() throws URISyntaxException {
        URI source = this.readDistroUrl();
        if (source.getScheme() == null) {
            return new File(this.propertiesFile.getParentFile(), source.getSchemeSpecificPart()).toURI();
        }
        return source;
    }

    private URI readDistroUrl() throws URISyntaxException {
        if (this.properties.getProperty(DISTRIBUTION_URL_PROPERTY) != null) {
            return new URI(this.getProperty(DISTRIBUTION_URL_PROPERTY));
        }
        return this.readDistroUrlDeprecatedWay();
    }

    private URI readDistroUrlDeprecatedWay() throws URISyntaxException {
        String distroUrl = null;
        try {
            distroUrl = this.getProperty("urlRoot") + "/" + this.getProperty("distributionName") + "-" + this.getProperty("distributionVersion") + "-" + this.getProperty("distributionClassifier") + ".zip";
            Formatter formatter = new Formatter();
            formatter.format("Wrapper properties file '%s' contains deprecated entries 'urlRoot', 'distributionName', 'distributionVersion' and 'distributionClassifier'. These will be removed soon. Please use '%s' instead.%n", this.propertiesFile, DISTRIBUTION_URL_PROPERTY);
            this.warningOutput.append(formatter.toString());
        }
        catch (Exception e) {
            this.reportMissingProperty(DISTRIBUTION_URL_PROPERTY);
        }
        return new URI(distroUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(File propertiesFile, Properties properties) throws IOException {
        FileInputStream inStream = new FileInputStream(propertiesFile);
        try {
            properties.load(inStream);
        }
        finally {
            ((InputStream)inStream).close();
        }
    }

    public URI getDistribution() {
        return this.config.getDistribution();
    }

    public WrapperConfiguration getConfiguration() {
        return this.config;
    }

    public void execute(String[] args, Install install, BootstrapMainStarter bootstrapMainStarter) throws Exception {
        File gradleHome = install.createDist(this.config);
        bootstrapMainStarter.start(args, gradleHome);
    }

    private String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    private String getProperty(String propertyName, String defaultValue) {
        String value = this.properties.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return this.reportMissingProperty(propertyName);
    }

    private String reportMissingProperty(String propertyName) {
        throw new RuntimeException(String.format("No value with key '%s' specified in wrapper properties file '%s'.", propertyName, this.propertiesFile));
    }
}

