/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import org.jlibrtp.jlibrtp.core.Participant;
import org.jlibrtp.jlibrtp.core.PktBuffer;
import org.jlibrtp.jlibrtp.core.RTPSession;
import org.jlibrtp.jlibrtp.core.RtpPkt;

public class RTPReceiverThread
extends Thread {
    RTPSession rtpSession = null;

    RTPReceiverThread(RTPSession session) {
        this.rtpSession = session;
    }

    @Override
    public void run() {
        while (!this.rtpSession.endSession) {
            Participant part;
            long[] csrcArray;
            byte[] rawPkt = new byte[1500];
            DatagramPacket packet = new DatagramPacket(rawPkt, rawPkt.length);
            if (!this.rtpSession.mcSession) {
                try {
                    this.rtpSession.rtpSock.receive(packet);
                }
                catch (IOException e) {
                    if (this.rtpSession.endSession) continue;
                    e.printStackTrace();
                }
            } else {
                try {
                    this.rtpSession.rtpMCSock.receive(packet);
                }
                catch (IOException e) {
                    if (this.rtpSession.endSession) continue;
                    e.printStackTrace();
                }
            }
            RtpPkt pkt = new RtpPkt(rawPkt, packet.getLength());
            if (pkt == null) {
                System.out.println("Received invalid RTP packet. Ignoring");
                continue;
            }
            long pktSsrc = pkt.getSsrc();
            if (this.rtpSession.ssrc == pktSsrc) {
                this.rtpSession.resolveSsrcConflict();
            }
            if ((csrcArray = pkt.getCsrcArray()) != null) {
                int i = 0;
                while (i < csrcArray.length) {
                    if (csrcArray[i] == this.rtpSession.ssrc) {
                        // empty if block
                    }
                    this.rtpSession.resolveSsrcConflict();
                    ++i;
                }
            }
            if ((part = this.rtpSession.partDb.getParticipant(pktSsrc)) == null) {
                InetSocketAddress nullSocket = null;
                part = new Participant((InetSocketAddress)packet.getSocketAddress(), nullSocket, pkt.getSsrc());
                part.unexpected = true;
                this.rtpSession.partDb.addParticipant(1, part);
            }
            if (part.rtpAddress == null || packet.getAddress().equals(part.rtpAddress.getAddress())) {
                PktBuffer pktBuffer = part.pktBuffer;
                if (pktBuffer != null) {
                    pktBuffer.addPkt(pkt);
                } else {
                    part.pktBuffer = pktBuffer = new PktBuffer(this.rtpSession, part, pkt);
                }
            } else {
                System.out.println("RTPReceiverThread: Got an unexpected packet from " + pkt.getSsrc() + " the sending ip-address was " + packet.getAddress().toString() + ", we expected from " + part.rtpAddress.toString());
            }
            part.updateRRStats(packet.getLength(), pkt);
            part.lastRtpPkt = System.currentTimeMillis();
            this.rtpSession.pktBufLock.lock();
            try {
                this.rtpSession.pktBufDataReady.signalAll();
            }
            finally {
                this.rtpSession.pktBufLock.unlock();
            }
        }
    }
}

