/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.packet.JingleTransport;
import org.xmlpull.v1.XmlPullParser;

public abstract class JingleTransportProvider
implements PacketExtensionProvider {
    protected JingleTransport getInstance() {
        return new JingleTransport();
    }

    public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        JingleTransport jingleTransport = this.getInstance();
        while (!bl) {
            int n = xmlPullParser.next();
            String string = xmlPullParser.getName();
            if (n == 2) {
                if (string.equals("candidate")) {
                    JingleTransport.JingleTransportCandidate jingleTransportCandidate = this.parseCandidate(xmlPullParser);
                    if (jingleTransportCandidate == null) continue;
                    jingleTransport.addCandidate(jingleTransportCandidate);
                    continue;
                }
                throw new Exception("Unknown tag \"" + string + "\" in transport element.");
            }
            if (n != 3 || !string.equals("transport")) continue;
            bl = true;
        }
        return jingleTransport;
    }

    protected abstract JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser var1) throws Exception;

    public static class RawUdp
    extends JingleTransportProvider {
        protected JingleTransport getInstance() {
            return new JingleTransport.RawUdp();
        }

        protected JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser xmlPullParser) throws Exception {
            TransportCandidate.Fixed fixed = new TransportCandidate.Fixed();
            String string = xmlPullParser.getAttributeValue("", "generation");
            String string2 = xmlPullParser.getAttributeValue("", "ip");
            String string3 = xmlPullParser.getAttributeValue("", "name");
            String string4 = xmlPullParser.getAttributeValue("", "port");
            if (string != null) {
                try {
                    fixed.setGeneration(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string2 != null) {
                fixed.setIp(string2);
            }
            if (string3 != null) {
                fixed.setName(string3);
            }
            if (string4 != null) {
                try {
                    fixed.setPort(Integer.parseInt(string4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new JingleTransport.RawUdp.Candidate(fixed);
        }
    }

    public static class Ice
    extends JingleTransportProvider {
        protected JingleTransport getInstance() {
            return new JingleTransport.Ice();
        }

        protected JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser xmlPullParser) throws Exception {
            ICECandidate iCECandidate = new ICECandidate();
            String string = xmlPullParser.getAttributeValue("", "channel");
            String string2 = xmlPullParser.getAttributeValue("", "generation");
            String string3 = xmlPullParser.getAttributeValue("", "ip");
            String string4 = xmlPullParser.getAttributeValue("", "name");
            String string5 = xmlPullParser.getAttributeValue("", "network");
            String string6 = xmlPullParser.getAttributeValue("", "username");
            String string7 = xmlPullParser.getAttributeValue("", "password");
            String string8 = xmlPullParser.getAttributeValue("", "port");
            String string9 = xmlPullParser.getAttributeValue("", "preference");
            String string10 = xmlPullParser.getAttributeValue("", "proto");
            String string11 = xmlPullParser.getAttributeValue("", "type");
            if (string != null) {
                iCECandidate.setChannel(new TransportCandidate.Channel(string));
            }
            if (string2 != null) {
                try {
                    iCECandidate.setGeneration(Integer.parseInt(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string3 == null) {
                return null;
            }
            iCECandidate.setIp(string3);
            if (string4 != null) {
                iCECandidate.setName(string4);
            }
            if (string5 != null) {
                try {
                    iCECandidate.setNetwork(Integer.parseInt(string5));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string6 != null) {
                iCECandidate.setUsername(string6);
            }
            if (string7 != null) {
                iCECandidate.setPassword(string7);
            }
            if (string8 != null) {
                try {
                    iCECandidate.setPort(Integer.parseInt(string8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string9 != null) {
                try {
                    iCECandidate.setPreference(Integer.parseInt(string9));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string10 != null) {
                iCECandidate.setProto(new TransportCandidate.Protocol(string10));
            }
            if (string11 != null) {
                iCECandidate.setType(ICECandidate.Type.valueOf(string11));
            }
            return new JingleTransport.Ice.Candidate(iCECandidate);
        }
    }
}

