/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.RemoteRosterEntry;

public class RosterExchange
implements PacketExtension {
    private List remoteRosterEntries = new ArrayList();

    public RosterExchange() {
    }

    public RosterExchange(Roster roster) {
        for (RosterEntry rosterEntry : roster.getEntries()) {
            this.addRosterEntry(rosterEntry);
        }
    }

    public void addRosterEntry(RosterEntry rosterEntry) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (RosterGroup rosterGroup : rosterEntry.getGroups()) {
            arrayList.add(rosterGroup.getName());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        RemoteRosterEntry remoteRosterEntry = new RemoteRosterEntry(rosterEntry.getUser(), rosterEntry.getName(), stringArray);
        this.addRosterEntry(remoteRosterEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterEntry(RemoteRosterEntry remoteRosterEntry) {
        List list = this.remoteRosterEntries;
        synchronized (list) {
            this.remoteRosterEntries.add(remoteRosterEntry);
        }
    }

    @Override
    public String getElementName() {
        return "x";
    }

    @Override
    public String getNamespace() {
        return "jabber:x:roster";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getRosterEntries() {
        List list = this.remoteRosterEntries;
        synchronized (list) {
            List list2 = Collections.unmodifiableList(new ArrayList(this.remoteRosterEntries));
            return list2.iterator();
        }
    }

    public int getEntryCount() {
        return this.remoteRosterEntries.size();
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        Iterator iterator = this.getRosterEntries();
        while (iterator.hasNext()) {
            RemoteRosterEntry remoteRosterEntry = (RemoteRosterEntry)iterator.next();
            stringBuilder.append(remoteRosterEntry.toXML());
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }
}

