/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.collections.ReferenceMap;
import org.jivesoftware.smackx.ChatState;
import org.jivesoftware.smackx.ChatStateListener;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.ChatStateExtension;

public class ChatStateManager {
    private static final Map<Connection, ChatStateManager> managers = new WeakHashMap<Connection, ChatStateManager>();
    private static final PacketFilter filter = new NotFilter(new PacketExtensionFilter("http://jabber.org/protocol/chatstates"));
    private final Connection connection;
    private final OutgoingMessageInterceptor outgoingInterceptor = new OutgoingMessageInterceptor();
    private final IncomingMessageInterceptor incomingInterceptor = new IncomingMessageInterceptor();
    private final Map<Chat, ChatState> chatStates = new ReferenceMap<Chat, ChatState>(2, 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChatStateManager getInstance(Connection connection) {
        if (connection == null) {
            return null;
        }
        Map<Connection, ChatStateManager> map = managers;
        synchronized (map) {
            ChatStateManager chatStateManager = managers.get(connection);
            if (chatStateManager == null) {
                chatStateManager = new ChatStateManager(connection);
                chatStateManager.init();
                managers.put(connection, chatStateManager);
            }
            return chatStateManager;
        }
    }

    private ChatStateManager(Connection connection) {
        this.connection = connection;
    }

    private void init() {
        this.connection.getChatManager().addOutgoingMessageInterceptor(this.outgoingInterceptor, filter);
        this.connection.getChatManager().addChatListener(this.incomingInterceptor);
        ServiceDiscoveryManager.getInstanceFor(this.connection).addFeature("http://jabber.org/protocol/chatstates");
    }

    public void setCurrentState(ChatState chatState, Chat chat) throws XMPPException {
        if (chat == null || chatState == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (!this.updateChatState(chat, chatState)) {
            return;
        }
        Message message = new Message();
        ChatStateExtension chatStateExtension = new ChatStateExtension(chatState);
        message.addExtension(chatStateExtension);
        chat.sendMessage(message);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChatStateManager chatStateManager = (ChatStateManager)object;
        return this.connection.equals(chatStateManager.connection);
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    private boolean updateChatState(Chat chat, ChatState chatState) {
        ChatState chatState2 = this.chatStates.get(chat);
        if (chatState2 != chatState) {
            this.chatStates.put(chat, chatState);
            return true;
        }
        return false;
    }

    private void fireNewChatState(Chat chat, ChatState chatState) {
        for (MessageListener messageListener : chat.getListeners()) {
            if (!(messageListener instanceof ChatStateListener)) continue;
            ((ChatStateListener)messageListener).stateChanged(chat, chatState);
        }
    }

    private class IncomingMessageInterceptor
    implements ChatManagerListener,
    MessageListener {
        private IncomingMessageInterceptor() {
        }

        @Override
        public void chatCreated(Chat chat, boolean bl) {
            chat.addMessageListener(this);
        }

        @Override
        public void processMessage(Chat chat, Message message) {
            ChatState chatState;
            PacketExtension packetExtension = message.getExtension("http://jabber.org/protocol/chatstates");
            if (packetExtension == null) {
                return;
            }
            try {
                chatState = ChatState.valueOf(packetExtension.getElementName());
            }
            catch (Exception exception) {
                return;
            }
            ChatStateManager.this.fireNewChatState(chat, chatState);
        }
    }

    private class OutgoingMessageInterceptor
    implements PacketInterceptor {
        private OutgoingMessageInterceptor() {
        }

        @Override
        public void interceptPacket(Packet packet) {
            Message message = (Message)packet;
            Chat chat = ChatStateManager.this.connection.getChatManager().getThreadChat(message.getThread());
            if (chat == null) {
                return;
            }
            if (ChatStateManager.this.updateChatState(chat, ChatState.active)) {
                message.addExtension(new ChatStateExtension(ChatState.active));
            }
        }
    }
}

