/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public final class ReverseMap {
    private static Name inaddr4 = Name.fromConstantString("in-addr.arpa.");
    private static Name inaddr6 = Name.fromConstantString("ip6.arpa.");

    private ReverseMap() {
    }

    public static Name fromAddress(byte[] byArray) {
        if (byArray.length != 4 && byArray.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray.length == 4) {
            for (int i = byArray.length - 1; i >= 0; --i) {
                stringBuffer.append(byArray[i] & 0xFF);
                if (i <= 0) continue;
                stringBuffer.append(".");
            }
        } else {
            int[] nArray = new int[2];
            for (int i = byArray.length - 1; i >= 0; --i) {
                nArray[0] = (byArray[i] & 0xFF) >> 4;
                nArray[1] = byArray[i] & 0xFF & 0xF;
                for (int j = nArray.length - 1; j >= 0; --j) {
                    stringBuffer.append(Integer.toHexString(nArray[j]));
                    if (i <= 0 && j <= 0) continue;
                    stringBuffer.append(".");
                }
            }
        }
        try {
            if (byArray.length == 4) {
                return Name.fromString(stringBuffer.toString(), inaddr4);
            }
            return Name.fromString(stringBuffer.toString(), inaddr6);
        }
        catch (TextParseException textParseException) {
            throw new IllegalStateException("name cannot be invalid");
        }
    }

    public static Name fromAddress(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0 || nArray[i] > 255) {
                throw new IllegalArgumentException("array must contain values between 0 and 255");
            }
            byArray[i] = (byte)nArray[i];
        }
        return ReverseMap.fromAddress(byArray);
    }

    public static Name fromAddress(InetAddress inetAddress) {
        return ReverseMap.fromAddress(inetAddress.getAddress());
    }

    public static Name fromAddress(String string, int n) throws UnknownHostException {
        byte[] byArray = Address.toByteArray(string, n);
        if (byArray == null) {
            throw new UnknownHostException("Invalid IP address");
        }
        return ReverseMap.fromAddress(byArray);
    }

    public static Name fromAddress(String string) throws UnknownHostException {
        byte[] byArray = Address.toByteArray(string, 1);
        if (byArray == null) {
            byArray = Address.toByteArray(string, 2);
        }
        if (byArray == null) {
            throw new UnknownHostException("Invalid IP address");
        }
        return ReverseMap.fromAddress(byArray);
    }
}

