/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.HashMap;

class Mnemonic {
    private static Integer[] cachedInts = new Integer[64];
    static final int CASE_SENSITIVE = 1;
    static final int CASE_UPPER = 2;
    static final int CASE_LOWER = 3;
    private HashMap strings;
    private HashMap values;
    private String description;
    private int wordcase;
    private String prefix;
    private int max;
    private boolean numericok;

    public Mnemonic(String string, int n) {
        this.description = string;
        this.wordcase = n;
        this.strings = new HashMap();
        this.values = new HashMap();
        this.max = Integer.MAX_VALUE;
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public void setPrefix(String string) {
        this.prefix = this.sanitize(string);
    }

    public void setNumericAllowed(boolean bl) {
        this.numericok = bl;
    }

    public static Integer toInteger(int n) {
        if (n >= 0 && n < cachedInts.length) {
            return cachedInts[n];
        }
        return new Integer(n);
    }

    public void check(int n) {
        if (n < 0 || n > this.max) {
            throw new IllegalArgumentException(this.description + " " + n + "is out of range");
        }
    }

    private String sanitize(String string) {
        if (this.wordcase == 2) {
            return string.toUpperCase();
        }
        if (this.wordcase == 3) {
            return string.toLowerCase();
        }
        return string;
    }

    private int parseNumeric(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 && n <= this.max) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public void add(int n, String string) {
        this.check(n);
        Integer n2 = Mnemonic.toInteger(n);
        string = this.sanitize(string);
        this.strings.put(string, n2);
        this.values.put(n2, string);
    }

    public void addAlias(int n, String string) {
        this.check(n);
        Integer n2 = Mnemonic.toInteger(n);
        string = this.sanitize(string);
        this.strings.put(string, n2);
    }

    public void addAll(Mnemonic mnemonic) {
        if (this.wordcase != mnemonic.wordcase) {
            throw new IllegalArgumentException(mnemonic.description + ": wordcases do not match");
        }
        this.strings.putAll(mnemonic.strings);
        this.values.putAll(mnemonic.values);
    }

    public String getText(int n) {
        this.check(n);
        String string = (String)this.values.get(Mnemonic.toInteger(n));
        if (string != null) {
            return string;
        }
        string = Integer.toString(n);
        if (this.prefix != null) {
            return this.prefix + string;
        }
        return string;
    }

    public int getValue(String string) {
        int n;
        Integer n2 = (Integer)this.strings.get(string = this.sanitize(string));
        if (n2 != null) {
            return n2;
        }
        if (this.prefix != null && string.startsWith(this.prefix) && (n = this.parseNumeric(string.substring(this.prefix.length()))) >= 0) {
            return n;
        }
        if (this.numericok) {
            return this.parseNumeric(string);
        }
        return -1;
    }

    static {
        for (int i = 0; i < cachedInts.length; ++i) {
            Mnemonic.cachedInts[i] = new Integer(i);
        }
    }
}

