/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.SecurityCtx;
import com.sun.security.sasl.util.AbstractSaslImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import security.javax.security.sasl.SaslException;

abstract class DigestMD5Base
extends AbstractSaslImpl {
    private static final String DI_CLASS_NAME = DigestIntegrity.class.getName();
    private static final String DP_CLASS_NAME = DigestPrivacy.class.getName();
    protected static final int MAX_CHALLENGE_LENGTH = 2048;
    protected static final int MAX_RESPONSE_LENGTH = 4096;
    protected static final int DEFAULT_MAXBUF = 65536;
    protected static final int DES3 = 0;
    protected static final int RC4 = 1;
    protected static final int DES = 2;
    protected static final int RC4_56 = 3;
    protected static final int RC4_40 = 4;
    protected static final String[] CIPHER_TOKENS = new String[]{"3des", "rc4", "des", "rc4-56", "rc4-40"};
    private static final String[] JCE_CIPHER_NAME = new String[]{"DESede/CBC/NoPadding", "RC4", "DES/CBC/NoPadding"};
    protected static final byte DES_3_STRENGTH = 4;
    protected static final byte RC4_STRENGTH = 4;
    protected static final byte DES_STRENGTH = 2;
    protected static final byte RC4_56_STRENGTH = 2;
    protected static final byte RC4_40_STRENGTH = 1;
    protected static final byte UNSET = 0;
    protected static final byte[] CIPHER_MASKS = new byte[]{4, 4, 2, 2, 1};
    private static final String SECURITY_LAYER_MARKER = ":00000000000000000000000000000000";
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected int step;
    protected CallbackHandler cbh;
    protected SecurityCtx secCtx;
    protected byte[] H_A1;
    protected byte[] nonce;
    protected String negotiatedStrength;
    protected String negotiatedCipher;
    protected String negotiatedQop;
    protected String negotiatedRealm;
    protected boolean useUTF8 = false;
    protected String encoding = "8859_1";
    protected String digestUri;
    protected String authzid;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int RAW_NONCE_SIZE = 30;
    private static final int ENCODED_NONCE_SIZE = 40;
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};
    private static final BigInteger MASK = new BigInteger("7f", 16);

    protected DigestMD5Base(Map props, String className, int firstStep, String digestUri, CallbackHandler cbh) throws SaslException {
        super(props, className);
        this.step = firstStep;
        this.digestUri = digestUri;
        this.cbh = cbh;
    }

    public String getMechanismName() {
        return "DIGEST-MD5";
    }

    public byte[] unwrap(byte[] incoming, int start, int len) throws SaslException {
        if (!this.completed) {
            throw new IllegalStateException("DIGEST-MD5 authentication not completed");
        }
        if (this.secCtx == null) {
            throw new IllegalStateException("Neither integrity nor privacy was negotiated");
        }
        return this.secCtx.unwrap(incoming, start, len);
    }

    public byte[] wrap(byte[] outgoing, int start, int len) throws SaslException {
        if (!this.completed) {
            throw new IllegalStateException("DIGEST-MD5 authentication not completed");
        }
        if (this.secCtx == null) {
            throw new IllegalStateException("Neither integrity nor privacy was negotiated");
        }
        return this.secCtx.wrap(outgoing, start, len);
    }

    public void dispose() throws SaslException {
        if (this.secCtx != null) {
            this.secCtx = null;
        }
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            if (propName.equals("javax.security.sasl.strength")) {
                return this.negotiatedStrength;
            }
            return super.getNegotiatedProperty(propName);
        }
        throw new IllegalStateException("DIGEST-MD5 authentication not completed");
    }

    protected static final byte[] generateNonce() {
        Random random = new Random();
        byte[] randomData = new byte[30];
        random.nextBytes(randomData);
        byte[] nonce = new byte[40];
        int j = 0;
        int i = 0;
        while (i < randomData.length) {
            byte a = randomData[i];
            byte b = randomData[i + 1];
            byte c = randomData[i + 2];
            nonce[j++] = (byte)pem_array[a >>> 2 & 0x3F];
            nonce[j++] = (byte)pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            nonce[j++] = (byte)pem_array[(b << 2 & 0x3C) + (c >>> 6 & 3)];
            nonce[j++] = (byte)pem_array[c & 0x3F];
            i += 3;
        }
        return nonce;
    }

    protected static void writeQuotedStringValue(ByteArrayOutputStream out, byte[] buf) {
        int len = buf.length;
        int i = 0;
        while (i < len) {
            byte ch = buf[i];
            if (DigestMD5Base.needEscape((char)ch)) {
                out.write(92);
            }
            out.write(ch);
            ++i;
        }
    }

    private static boolean needEscape(String str) {
        int len = str.length();
        int i = 0;
        while (i < len) {
            if (DigestMD5Base.needEscape(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean needEscape(char ch) {
        return ch == '\"' || ch == '\\' || ch == '\u007f' || ch >= '\u0000' && ch <= '\u001f' && ch != '\r' && ch != '\t' && ch != '\n';
    }

    protected static String quotedStringValue(String str) {
        if (DigestMD5Base.needEscape(str)) {
            int len = str.length();
            char[] buf = new char[len + len];
            int j = 0;
            int i = 0;
            while (i < len) {
                char ch = str.charAt(i);
                if (DigestMD5Base.needEscape(ch)) {
                    buf[j++] = 92;
                }
                buf[j++] = ch;
                ++i;
            }
            return new String(buf, 0, j);
        }
        return str;
    }

    protected byte[] binaryToHex(byte[] digest) throws UnsupportedEncodingException {
        StringBuffer digestString = new StringBuffer();
        int i = 0;
        while (i < digest.length) {
            if ((digest[i] & 0xFF) < 16) {
                digestString.append("0" + Integer.toHexString(digest[i] & 0xFF));
            } else {
                digestString.append(Integer.toHexString(digest[i] & 0xFF));
            }
            ++i;
        }
        return digestString.toString().getBytes(this.encoding);
    }

    protected byte[] stringToByte_8859_1(String str) throws SaslException {
        char[] buffer = str.toCharArray();
        try {
            if (this.useUTF8) {
                int i = 0;
                while (i < buffer.length) {
                    if (buffer[i] > '\u00ff') {
                        return str.getBytes("UTF8");
                    }
                    ++i;
                }
            }
            return str.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("cannot encode string in UTF8 or 8859-1 (Latin-1)", e);
        }
    }

    protected static byte[] getPlatformCiphers() {
        byte[] ciphers = new byte[CIPHER_TOKENS.length];
        int i = 0;
        while (i < JCE_CIPHER_NAME.length) {
            try {
                Cipher.getInstance(JCE_CIPHER_NAME[i]);
                logger.log(Level.FINE, "DIGEST01:Platform supports {0}", JCE_CIPHER_NAME[i]);
                int n = i;
                ciphers[n] = (byte)(ciphers[n] | CIPHER_MASKS[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
            ++i;
        }
        if (ciphers[1] != 0) {
            ciphers[3] = (byte)(ciphers[3] | CIPHER_MASKS[3]);
            ciphers[4] = (byte)(ciphers[4] | CIPHER_MASKS[4]);
        }
        return ciphers;
    }

    protected byte[] generateResponseValue(String authMethod, String digestUriValue, String qopValue, String usernameValue, String realmValue, char[] passwdValue, byte[] nonceValue, byte[] cNonceValue, int nonceCount, byte[] authzidValue) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        ByteArrayOutputStream A2 = new ByteArrayOutputStream();
        A2.write((String.valueOf(authMethod) + ":" + digestUriValue).getBytes(this.encoding));
        if (qopValue.equals("auth-conf") || qopValue.equals("auth-int")) {
            logger.log(Level.FINE, "DIGEST04:QOP: {0}", qopValue);
            A2.write(SECURITY_LAYER_MARKER.getBytes(this.encoding));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST05:A2: {0}", A2.toString());
        }
        md5.update(A2.toByteArray());
        byte[] digest = md5.digest();
        byte[] hexA2 = this.binaryToHex(digest);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST06:HEX(H(A2)): {0}", new String(hexA2));
        }
        ByteArrayOutputStream beginA1 = new ByteArrayOutputStream();
        beginA1.write(this.stringToByte_8859_1(usernameValue));
        beginA1.write(58);
        beginA1.write(this.stringToByte_8859_1(realmValue));
        beginA1.write(58);
        beginA1.write(this.stringToByte_8859_1(new String(passwdValue)));
        md5.update(beginA1.toByteArray());
        digest = md5.digest();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST07:H({0}) = {1}", new Object[]{beginA1.toString(), new String(this.binaryToHex(digest))});
        }
        ByteArrayOutputStream A1 = new ByteArrayOutputStream();
        A1.write(digest);
        A1.write(58);
        A1.write(nonceValue);
        A1.write(58);
        A1.write(cNonceValue);
        if (authzidValue != null) {
            A1.write(58);
            A1.write(authzidValue);
        }
        md5.update(A1.toByteArray());
        digest = md5.digest();
        this.H_A1 = digest;
        byte[] hexA1 = this.binaryToHex(digest);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST08:H(A1) = {0}", new String(hexA1));
        }
        ByteArrayOutputStream KD = new ByteArrayOutputStream();
        KD.write(hexA1);
        KD.write(58);
        KD.write(nonceValue);
        KD.write(58);
        KD.write(DigestMD5Base.nonceCountToHex(nonceCount).getBytes(this.encoding));
        KD.write(58);
        KD.write(cNonceValue);
        KD.write(58);
        KD.write(qopValue.getBytes(this.encoding));
        KD.write(58);
        KD.write(hexA2);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST09:KD: {0}", KD.toString());
        }
        md5.update(KD.toByteArray());
        digest = md5.digest();
        byte[] answer = this.binaryToHex(digest);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST10:response-value: {0}", new String(answer));
        }
        return answer;
    }

    protected static String nonceCountToHex(int count) {
        String str = Integer.toHexString(count);
        StringBuffer pad = new StringBuffer();
        if (str.length() < 8) {
            int i = 0;
            while (i < 8 - str.length()) {
                pad.append("0");
                ++i;
            }
        }
        return String.valueOf(pad.toString()) + str;
    }

    protected static byte[][] parseDirectives(byte[] buf, String[] keyTable, List<byte[]> realmChoices, int realmIndex) throws SaslException {
        byte[][] valueTable = new byte[keyTable.length][];
        ByteArrayOutputStream key = new ByteArrayOutputStream(10);
        ByteArrayOutputStream value = new ByteArrayOutputStream(10);
        boolean gettingKey = true;
        boolean gettingQuotedValue = false;
        boolean expectSeparator = false;
        int i = DigestMD5Base.skipLws(buf, 0);
        while (i < buf.length) {
            byte bch = buf[i];
            if (gettingKey) {
                if (bch == 44) {
                    if (key.size() != 0) {
                        throw new SaslException("Directive key contains a ',':" + key);
                    }
                    i = DigestMD5Base.skipLws(buf, i + 1);
                    continue;
                }
                if (bch == 61) {
                    if (key.size() == 0) {
                        throw new SaslException("Empty directive key");
                    }
                    gettingKey = false;
                    if ((i = DigestMD5Base.skipLws(buf, i + 1)) < buf.length) {
                        if (buf[i] != 34) continue;
                        gettingQuotedValue = true;
                        ++i;
                        continue;
                    }
                    throw new SaslException("Valueless directive found: " + key.toString());
                }
                if (DigestMD5Base.isLws(bch)) {
                    if ((i = DigestMD5Base.skipLws(buf, i + 1)) < buf.length) {
                        if (buf[i] == 61) continue;
                        throw new SaslException("'=' expected after key: " + key.toString());
                    }
                    throw new SaslException("'=' expected after key: " + key.toString());
                }
                key.write(bch);
                ++i;
                continue;
            }
            if (gettingQuotedValue) {
                if (bch == 92) {
                    if (++i < buf.length) {
                        value.write(buf[i]);
                        ++i;
                        continue;
                    }
                    throw new SaslException("Unmatched quote found for directive: " + key.toString() + " with value: " + value.toString());
                }
                if (bch == 34) {
                    ++i;
                    gettingQuotedValue = false;
                    expectSeparator = true;
                    continue;
                }
                value.write(bch);
                ++i;
                continue;
            }
            if (DigestMD5Base.isLws(bch) || bch == 44) {
                DigestMD5Base.extractDirective(key.toString(), value.toByteArray(), keyTable, valueTable, realmChoices, realmIndex);
                key.reset();
                value.reset();
                gettingKey = true;
                expectSeparator = false;
                gettingQuotedValue = false;
                i = DigestMD5Base.skipLws(buf, i + 1);
                continue;
            }
            if (expectSeparator) {
                throw new SaslException("Expecting comma or linear whitespace after quoted string: \"" + value.toString() + "\"");
            }
            value.write(bch);
            ++i;
        }
        if (gettingQuotedValue) {
            throw new SaslException("Unmatched quote found for directive: " + key.toString() + " with value: " + value.toString());
        }
        if (key.size() > 0) {
            DigestMD5Base.extractDirective(key.toString(), value.toByteArray(), keyTable, valueTable, realmChoices, realmIndex);
        }
        return valueTable;
    }

    private static boolean isLws(byte b) {
        switch (b) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static int skipLws(byte[] buf, int start) {
        int i = start;
        while (i < buf.length) {
            if (!DigestMD5Base.isLws(buf[i])) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static void extractDirective(String key, byte[] value, String[] keyTable, byte[][] valueTable, List<byte[]> realmChoices, int realmIndex) throws SaslException {
        int i = 0;
        while (i < keyTable.length) {
            if (key.equalsIgnoreCase(keyTable[i])) {
                if (valueTable[i] == null) {
                    valueTable[i] = value;
                    if (!logger.isLoggable(Level.FINE)) break;
                    logger.log(Level.FINE, "DIGEST11:Directive {0} = {1}", new Object[]{keyTable[i], new String(valueTable[i])});
                    break;
                }
                if (realmChoices != null && i == realmIndex) {
                    if (realmChoices.size() == 0) {
                        realmChoices.add(valueTable[i]);
                    }
                    realmChoices.add(value);
                    break;
                }
                throw new SaslException("DIGEST-MD5: peer sent more than one " + key + " directive: " + new String(value));
            }
            ++i;
        }
    }

    private static void setParityBit(byte[] key) {
        int i = 0;
        while (i < key.length) {
            int bitCount = 0;
            int maskIndex = 0;
            while (maskIndex < PARITY_BIT_MASK.length) {
                if ((key[i] & PARITY_BIT_MASK[maskIndex]) == PARITY_BIT_MASK[maskIndex]) {
                    ++bitCount;
                }
                ++maskIndex;
            }
            key[i] = bitCount & true ? (byte)(key[i] & 0xFFFFFFFE) : (byte)(key[i] | 1);
            ++i;
        }
    }

    private static byte[] addDesParity(byte[] input, int offset, int len) {
        if (len != 7) {
            throw new IllegalArgumentException("Invalid length of DES Key Value:" + len);
        }
        byte[] raw = new byte[7];
        System.arraycopy(input, offset, raw, 0, len);
        byte[] result = new byte[8];
        BigInteger in = new BigInteger(raw);
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = in.and(MASK).toByteArray()[0];
            int n = i--;
            result[n] = (byte)(result[n] << 1);
            in = in.shiftRight(7);
        }
        DigestMD5Base.setParityBit(result);
        return result;
    }

    private static SecretKey makeDesKeys(byte[] input, String desStrength) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        byte[] subkey1 = DigestMD5Base.addDesParity(input, 0, 7);
        KeySpec spec = null;
        SecretKeyFactory desFactory = SecretKeyFactory.getInstance(desStrength);
        if (desStrength.equals("des")) {
            spec = new DESKeySpec(subkey1, 0);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST42:DES key input: ", input);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST43:DES key parity-adjusted: ", subkey1);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST44:DES key material: ", spec.getKey());
                logger.log(Level.FINEST, "DIGEST45: is parity-adjusted? {0}", DESKeySpec.isParityAdjusted(subkey1, 0));
            }
        } else if (desStrength.equals("desede")) {
            byte[] subkey2 = DigestMD5Base.addDesParity(input, 7, 7);
            byte[] ede = new byte[subkey1.length * 2 + subkey2.length];
            System.arraycopy(subkey1, 0, ede, 0, subkey1.length);
            System.arraycopy(subkey2, 0, ede, subkey1.length, subkey2.length);
            System.arraycopy(subkey1, 0, ede, subkey1.length + subkey2.length, subkey1.length);
            spec = new DESedeKeySpec(ede, 0);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST46:3DES key input: ", input);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST47:3DES key ede: ", ede);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST48:3DES key material: ", ((DESedeKeySpec)spec).getKey());
                logger.log(Level.FINEST, "DIGEST49: is parity-adjusted? ", DESedeKeySpec.isParityAdjusted(ede, 0));
            }
        } else {
            throw new IllegalArgumentException("Invalid DES strength:" + desStrength);
        }
        return desFactory.generateSecret(spec);
    }

    static /* synthetic */ void access$0(int n, byte[] byArray, int n2, int n3) {
        AbstractSaslImpl.intToNetworkByteOrder(n, byArray, n2, n3);
    }

    static /* synthetic */ Logger access$1() {
        return AbstractSaslImpl.logger;
    }

    static /* synthetic */ void access$3(String string, String string2, String string3, byte[] byArray) {
        AbstractSaslImpl.traceOutput(string, string2, string3, byArray);
    }

    static /* synthetic */ void access$4(String string, String string2, String string3, byte[] byArray, int n, int n2) {
        AbstractSaslImpl.traceOutput(string, string2, string3, byArray, n, n2);
    }

    static /* synthetic */ int access$5(byte[] byArray, int n, int n2) {
        return AbstractSaslImpl.networkByteOrderToInt(byArray, n, n2);
    }

    class DigestIntegrity
    implements SecurityCtx {
        private static final String CLIENT_INT_MAGIC = "Digest session key to client-to-server signing key magic constant";
        private static final String SVR_INT_MAGIC = "Digest session key to server-to-client signing key magic constant";
        protected byte[] myKi;
        protected byte[] peerKi;
        protected int mySeqNum = 0;
        protected int peerSeqNum = 0;
        protected final byte[] messageType = new byte[2];
        protected final byte[] sequenceNum = new byte[4];

        DigestIntegrity(boolean clientMode) throws SaslException {
            try {
                this.generateIntegrityKeyPair(clientMode);
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("DIGEST-MD5: Error encoding strings into UTF-8", e);
            }
            catch (IOException e) {
                throw new SaslException("DIGEST-MD5: Error accessing buffers required to create integrity key pairs", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("DIGEST-MD5: Unsupported digest algorithm used to create integrity key pairs", e);
            }
            DigestMD5Base.access$0(1, this.messageType, 0, 2);
        }

        private void generateIntegrityKeyPair(boolean clientMode) throws UnsupportedEncodingException, IOException, NoSuchAlgorithmException {
            byte[] cimagic = CLIENT_INT_MAGIC.getBytes(DigestMD5Base.this.encoding);
            byte[] simagic = SVR_INT_MAGIC.getBytes(DigestMD5Base.this.encoding);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] keyBuffer = new byte[DigestMD5Base.this.H_A1.length + cimagic.length];
            System.arraycopy(DigestMD5Base.this.H_A1, 0, keyBuffer, 0, DigestMD5Base.this.H_A1.length);
            System.arraycopy(cimagic, 0, keyBuffer, DigestMD5Base.this.H_A1.length, cimagic.length);
            md5.update(keyBuffer);
            byte[] Kic = md5.digest();
            System.arraycopy(simagic, 0, keyBuffer, DigestMD5Base.this.H_A1.length, simagic.length);
            md5.update(keyBuffer);
            byte[] Kis = md5.digest();
            if (DigestMD5Base.access$1().isLoggable(Level.FINER)) {
                DigestMD5Base.access$3(DI_CLASS_NAME, "generateIntegrityKeyPair", "DIGEST12:Kic: ", Kic);
                DigestMD5Base.access$3(DI_CLASS_NAME, "generateIntegrityKeyPair", "DIGEST13:Kis: ", Kis);
            }
            if (clientMode) {
                this.myKi = Kic;
                this.peerKi = Kis;
            } else {
                this.myKi = Kis;
                this.peerKi = Kic;
            }
        }

        @Override
        public byte[] wrap(byte[] outgoing, int start, int len) throws SaslException {
            if (len == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] wrapped = new byte[len + 10 + 2 + 4];
            System.arraycopy(outgoing, start, wrapped, 0, len);
            this.incrementSeqNum();
            byte[] mac = this.getHMAC(this.myKi, this.sequenceNum, outgoing, start, len);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$4(DI_CLASS_NAME, "wrap", "DIGEST14:outgoing: ", outgoing, start, len);
                DigestMD5Base.access$3(DI_CLASS_NAME, "wrap", "DIGEST15:seqNum: ", this.sequenceNum);
                DigestMD5Base.access$3(DI_CLASS_NAME, "wrap", "DIGEST16:MAC: ", mac);
            }
            System.arraycopy(mac, 0, wrapped, len, 10);
            System.arraycopy(this.messageType, 0, wrapped, len + 10, 2);
            System.arraycopy(this.sequenceNum, 0, wrapped, len + 12, 4);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$3(DI_CLASS_NAME, "wrap", "DIGEST17:wrapped: ", wrapped);
            }
            return wrapped;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int start, int len) throws SaslException {
            if (len == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] mac = new byte[10];
            byte[] msg = new byte[len - 16];
            byte[] msgType = new byte[2];
            byte[] seqNum = new byte[4];
            System.arraycopy(incoming, start, msg, 0, msg.length);
            System.arraycopy(incoming, start + msg.length, mac, 0, 10);
            System.arraycopy(incoming, start + msg.length + 10, msgType, 0, 2);
            System.arraycopy(incoming, start + msg.length + 12, seqNum, 0, 4);
            byte[] expectedMac = this.getHMAC(this.peerKi, seqNum, msg, 0, msg.length);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$3(DI_CLASS_NAME, "unwrap", "DIGEST18:incoming: ", msg);
                DigestMD5Base.access$3(DI_CLASS_NAME, "unwrap", "DIGEST19:MAC: ", mac);
                DigestMD5Base.access$3(DI_CLASS_NAME, "unwrap", "DIGEST20:messageType: ", msgType);
                DigestMD5Base.access$3(DI_CLASS_NAME, "unwrap", "DIGEST21:sequenceNum: ", seqNum);
                DigestMD5Base.access$3(DI_CLASS_NAME, "unwrap", "DIGEST22:expectedMAC: ", expectedMac);
            }
            if (!Arrays.equals(mac, expectedMac)) {
                DigestMD5Base.access$1().log(Level.INFO, "DIGEST23:Unmatched MACs");
                return EMPTY_BYTE_ARRAY;
            }
            if (this.peerSeqNum != DigestMD5Base.access$5(seqNum, 0, 4)) {
                throw new SaslException("DIGEST-MD5: Out of order sequencing of messages from server. Got: " + DigestMD5Base.access$5(seqNum, 0, 4) + " Expected: " + this.peerSeqNum);
            }
            if (!Arrays.equals(this.messageType, msgType)) {
                throw new SaslException("DIGEST-MD5: invalid message type: " + DigestMD5Base.access$5(msgType, 0, 2));
            }
            ++this.peerSeqNum;
            return msg;
        }

        protected byte[] getHMAC(byte[] Ki, byte[] seqnum, byte[] msg, int start, int len) throws SaslException {
            byte[] seqAndMsg = new byte[4 + len];
            System.arraycopy(seqnum, 0, seqAndMsg, 0, 4);
            System.arraycopy(msg, start, seqAndMsg, 4, len);
            try {
                SecretKeySpec keyKi = new SecretKeySpec(Ki, "HmacMD5");
                Mac m = Mac.getInstance("HmacMD5");
                m.init(keyKi);
                m.update(seqAndMsg);
                byte[] hMAC_MD5 = m.doFinal();
                byte[] macBuffer = new byte[10];
                System.arraycopy(hMAC_MD5, 0, macBuffer, 0, 10);
                return macBuffer;
            }
            catch (InvalidKeyException e) {
                throw new SaslException("DIGEST-MD5: Invalid bytes used for key of HMAC-MD5 hash.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("DIGEST-MD5: Error creating instance of MD5 digest algorithm", e);
            }
        }

        protected void incrementSeqNum() {
            DigestMD5Base.access$0(this.mySeqNum++, this.sequenceNum, 0, 4);
        }
    }

    final class DigestPrivacy
    extends DigestIntegrity
    implements SecurityCtx {
        private static final String CLIENT_CONF_MAGIC = "Digest H(A1) to client-to-server sealing key magic constant";
        private static final String SVR_CONF_MAGIC = "Digest H(A1) to server-to-client sealing key magic constant";
        private Cipher encCipher;
        private Cipher decCipher;

        DigestPrivacy(boolean clientMode) throws SaslException {
            super(clientMode);
            try {
                this.generatePrivacyKeyPair(clientMode);
            }
            catch (SaslException e) {
                throw e;
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("DIGEST-MD5: Error encoding string value into UTF-8", e);
            }
            catch (IOException e) {
                throw new SaslException("DIGEST-MD5: Error accessing buffers required to generate cipher keys", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("DIGEST-MD5: Error creating instance of required cipher or digest", e);
            }
        }

        private void generatePrivacyKeyPair(boolean clientMode) throws IOException, UnsupportedEncodingException, NoSuchAlgorithmException, SaslException {
            byte[] peerKc;
            byte[] myKc;
            byte[] ccmagic = CLIENT_CONF_MAGIC.getBytes(DigestMD5Base.this.encoding);
            byte[] scmagic = SVR_CONF_MAGIC.getBytes(DigestMD5Base.this.encoding);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            int n = DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[4]) ? 5 : (DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[3]) ? 7 : 16);
            byte[] keyBuffer = new byte[n + ccmagic.length];
            System.arraycopy(DigestMD5Base.this.H_A1, 0, keyBuffer, 0, n);
            System.arraycopy(ccmagic, 0, keyBuffer, n, ccmagic.length);
            md5.update(keyBuffer);
            byte[] Kcc = md5.digest();
            System.arraycopy(scmagic, 0, keyBuffer, n, scmagic.length);
            md5.update(keyBuffer);
            byte[] Kcs = md5.digest();
            if (DigestMD5Base.access$1().isLoggable(Level.FINER)) {
                DigestMD5Base.access$3(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST24:Kcc: ", Kcc);
                DigestMD5Base.access$3(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST25:Kcs: ", Kcs);
            }
            if (clientMode) {
                myKc = Kcc;
                peerKc = Kcs;
            } else {
                myKc = Kcs;
                peerKc = Kcc;
            }
            try {
                if (DigestMD5Base.this.negotiatedCipher.indexOf(CIPHER_TOKENS[1]) > -1) {
                    this.encCipher = Cipher.getInstance("RC4");
                    this.decCipher = Cipher.getInstance("RC4");
                    SecretKeySpec encKey = new SecretKeySpec(myKc, "RC4");
                    SecretKeySpec decKey = new SecretKeySpec(peerKc, "RC4");
                    this.encCipher.init(1, encKey);
                    this.decCipher.init(2, decKey);
                } else if (DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[2]) || DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[0])) {
                    String cipherShortname;
                    String cipherFullname;
                    if (DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[2])) {
                        cipherFullname = "DES/CBC/NoPadding";
                        cipherShortname = "des";
                    } else {
                        cipherFullname = "DESede/CBC/NoPadding";
                        cipherShortname = "desede";
                    }
                    this.encCipher = Cipher.getInstance(cipherFullname);
                    this.decCipher = Cipher.getInstance(cipherFullname);
                    SecretKey encKey = DigestMD5Base.makeDesKeys(myKc, cipherShortname);
                    SecretKey decKey = DigestMD5Base.makeDesKeys(peerKc, cipherShortname);
                    IvParameterSpec encIv = new IvParameterSpec(myKc, 8, 8);
                    IvParameterSpec decIv = new IvParameterSpec(peerKc, 8, 8);
                    this.encCipher.init(1, (Key)encKey, encIv);
                    this.decCipher.init(2, (Key)decKey, decIv);
                    if (DigestMD5Base.access$1().isLoggable(Level.FINER)) {
                        DigestMD5Base.access$3(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST26:" + DigestMD5Base.this.negotiatedCipher + " IVcc: ", encIv.getIV());
                        DigestMD5Base.access$3(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST27:" + DigestMD5Base.this.negotiatedCipher + " IVcs: ", decIv.getIV());
                        DigestMD5Base.access$3(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST28:" + DigestMD5Base.this.negotiatedCipher + " encryption key: ", encKey.getEncoded());
                        DigestMD5Base.access$3(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST29:" + DigestMD5Base.this.negotiatedCipher + " decryption key: ", decKey.getEncoded());
                    }
                }
            }
            catch (InvalidKeySpecException e) {
                throw new SaslException("DIGEST-MD5: Unsupported key specification used.", e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new SaslException("DIGEST-MD5: Invalid cipher algorithem parameter used to create cipher instance", e);
            }
            catch (NoSuchPaddingException e) {
                throw new SaslException("DIGEST-MD5: Unsupported padding used for chosen cipher", e);
            }
            catch (InvalidKeyException e) {
                throw new SaslException("DIGEST-MD5: Invalid data used to initialize keys", e);
            }
        }

        @Override
        public byte[] wrap(byte[] outgoing, int start, int len) throws SaslException {
            byte[] cipherBlock;
            byte[] padding;
            int bs;
            if (len == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            this.incrementSeqNum();
            byte[] mac = this.getHMAC(this.myKi, this.sequenceNum, outgoing, start, len);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$4(DP_CLASS_NAME, "wrap", "DIGEST30:Outgoing: ", outgoing, start, len);
                DigestMD5Base.access$3(DP_CLASS_NAME, "wrap", "seqNum: ", this.sequenceNum);
                DigestMD5Base.access$3(DP_CLASS_NAME, "wrap", "MAC: ", mac);
            }
            if ((bs = this.encCipher.getBlockSize()) > 1) {
                int pad = bs - (len + 10) % bs;
                padding = new byte[pad];
                int i = 0;
                while (i < pad) {
                    padding[i] = (byte)pad;
                    ++i;
                }
            } else {
                padding = EMPTY_BYTE_ARRAY;
            }
            byte[] toBeEncrypted = new byte[len + padding.length + 10];
            System.arraycopy(outgoing, start, toBeEncrypted, 0, len);
            System.arraycopy(padding, 0, toBeEncrypted, len, padding.length);
            System.arraycopy(mac, 0, toBeEncrypted, len + padding.length, 10);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$3(DP_CLASS_NAME, "wrap", "DIGEST31:{msg, pad, KicMAC}: ", toBeEncrypted);
            }
            try {
                cipherBlock = this.encCipher.update(toBeEncrypted);
                if (cipherBlock == null) {
                    throw new IllegalBlockSizeException("" + toBeEncrypted.length);
                }
            }
            catch (IllegalBlockSizeException e) {
                throw new SaslException("DIGEST-MD5: Invalid block size for cipher", e);
            }
            byte[] wrapped = new byte[cipherBlock.length + 2 + 4];
            System.arraycopy(cipherBlock, 0, wrapped, 0, cipherBlock.length);
            System.arraycopy(this.messageType, 0, wrapped, cipherBlock.length, 2);
            System.arraycopy(this.sequenceNum, 0, wrapped, cipherBlock.length + 2, 4);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$3(DP_CLASS_NAME, "wrap", "DIGEST32:Wrapped: ", wrapped);
            }
            return wrapped;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int start, int len) throws SaslException {
            byte[] decryptedMsg;
            if (len == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] encryptedMsg = new byte[len - 6];
            byte[] msgType = new byte[2];
            byte[] seqNum = new byte[4];
            System.arraycopy(incoming, start, encryptedMsg, 0, encryptedMsg.length);
            System.arraycopy(incoming, start + encryptedMsg.length, msgType, 0, 2);
            System.arraycopy(incoming, start + encryptedMsg.length + 2, seqNum, 0, 4);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$1().log(Level.FINEST, "DIGEST33:Expecting sequence num: {0}", new Integer(this.peerSeqNum));
                DigestMD5Base.access$3(DP_CLASS_NAME, "unwrap", "DIGEST34:incoming: ", encryptedMsg);
            }
            try {
                decryptedMsg = this.decCipher.update(encryptedMsg);
                if (decryptedMsg == null) {
                    throw new IllegalBlockSizeException("" + encryptedMsg.length);
                }
            }
            catch (IllegalBlockSizeException e) {
                throw new SaslException("DIGEST-MD5: Illegal block sizes used with chosen cipher", e);
            }
            byte[] msgWithPadding = new byte[decryptedMsg.length - 10];
            byte[] mac = new byte[10];
            System.arraycopy(decryptedMsg, 0, msgWithPadding, 0, msgWithPadding.length);
            System.arraycopy(decryptedMsg, msgWithPadding.length, mac, 0, 10);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$3(DP_CLASS_NAME, "unwrap", "DIGEST35:Unwrapped (w/padding): ", msgWithPadding);
                DigestMD5Base.access$3(DP_CLASS_NAME, "unwrap", "DIGEST36:MAC: ", mac);
                DigestMD5Base.access$3(DP_CLASS_NAME, "unwrap", "DIGEST37:messageType: ", msgType);
                DigestMD5Base.access$3(DP_CLASS_NAME, "unwrap", "DIGEST38:sequenceNum: ", seqNum);
            }
            int msgLength = msgWithPadding.length;
            int blockSize = this.decCipher.getBlockSize();
            if (blockSize > 1 && (msgLength -= msgWithPadding[msgWithPadding.length - 1]) < 0) {
                if (DigestMD5Base.access$1().isLoggable(Level.INFO)) {
                    DigestMD5Base.access$1().log(Level.INFO, "DIGEST39:Incorrect padding: {0}", new Byte(msgWithPadding[msgWithPadding.length - 1]));
                }
                return EMPTY_BYTE_ARRAY;
            }
            byte[] expectedMac = this.getHMAC(this.peerKi, seqNum, msgWithPadding, 0, msgLength);
            if (DigestMD5Base.access$1().isLoggable(Level.FINEST)) {
                DigestMD5Base.access$3(DP_CLASS_NAME, "unwrap", "DIGEST40:KisMAC: ", expectedMac);
            }
            if (!Arrays.equals(mac, expectedMac)) {
                DigestMD5Base.access$1().log(Level.INFO, "DIGEST41:Unmatched MACs");
                return EMPTY_BYTE_ARRAY;
            }
            if (this.peerSeqNum != DigestMD5Base.access$5(seqNum, 0, 4)) {
                throw new SaslException("DIGEST-MD5: Out of order sequencing of messages from server. Got: " + DigestMD5Base.access$5(seqNum, 0, 4) + " Expected: " + this.peerSeqNum);
            }
            if (!Arrays.equals(this.messageType, msgType)) {
                throw new SaslException("DIGEST-MD5: invalid message type: " + DigestMD5Base.access$5(msgType, 0, 2));
            }
            ++this.peerSeqNum;
            if (msgLength == msgWithPadding.length) {
                return msgWithPadding;
            }
            byte[] clearMsg = new byte[msgLength];
            System.arraycopy(msgWithPadding, 0, clearMsg, 0, msgLength);
            return clearMsg;
        }
    }
}

