/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.AttrAccept;
import com.kenai.jbosh.BOSHClientConfig;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.CMSessionParams;
import com.kenai.jbosh.GZIPCodec;
import com.kenai.jbosh.HTTPResponse;
import com.kenai.jbosh.StaticBody;
import com.kenai.jbosh.ZLIBCodec;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

final class ApacheHTTPResponse
implements HTTPResponse {
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ACCEPT_ENCODING_VAL = ZLIBCodec.getID() + ", " + GZIPCodec.getID();
    private static final String CHARSET = "UTF-8";
    private static final String CONTENT_TYPE = "text/xml; charset=utf-8";
    private final Lock lock = new ReentrantLock();
    private final HttpContext context;
    private final HttpClient client;
    private final HttpPost post;
    private boolean sent;
    private BOSHException toThrow;
    private AbstractBody body;
    private int statusCode;

    ApacheHTTPResponse(HttpClient httpClient, BOSHClientConfig bOSHClientConfig, CMSessionParams cMSessionParams, AbstractBody abstractBody) {
        this.client = httpClient;
        this.context = new BasicHttpContext();
        this.post = new HttpPost(bOSHClientConfig.getURI().toString());
        this.sent = false;
        try {
            AttrAccept attrAccept;
            String string = abstractBody.toXML();
            byte[] byArray = string.getBytes(CHARSET);
            String string2 = null;
            if (bOSHClientConfig.isCompressionEnabled() && cMSessionParams != null && (attrAccept = cMSessionParams.getAccept()) != null) {
                if (attrAccept.isAccepted(ZLIBCodec.getID())) {
                    string2 = ZLIBCodec.getID();
                    byArray = ZLIBCodec.encode(byArray);
                } else if (attrAccept.isAccepted(GZIPCodec.getID())) {
                    string2 = GZIPCodec.getID();
                    byArray = GZIPCodec.encode(byArray);
                }
            }
            attrAccept = new ByteArrayEntity(byArray);
            attrAccept.setContentType(CONTENT_TYPE);
            if (string2 != null) {
                attrAccept.setContentEncoding(string2);
            }
            this.post.setEntity((HttpEntity)attrAccept);
            if (bOSHClientConfig.isCompressionEnabled()) {
                this.post.setHeader(ACCEPT_ENCODING, ACCEPT_ENCODING_VAL);
            }
        }
        catch (Exception exception) {
            this.toThrow = new BOSHException("Could not generate request", exception);
        }
    }

    public void abort() {
        if (this.post != null) {
            this.post.abort();
            this.toThrow = new BOSHException("HTTP request aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBody getBody() throws InterruptedException, BOSHException {
        if (this.toThrow != null) {
            throw this.toThrow;
        }
        this.lock.lock();
        try {
            if (!this.sent) {
                this.awaitResponse();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHTTPStatus() throws InterruptedException, BOSHException {
        if (this.toThrow != null) {
            throw this.toThrow;
        }
        this.lock.lock();
        try {
            if (!this.sent) {
                this.awaitResponse();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.statusCode;
    }

    private synchronized void awaitResponse() throws BOSHException {
        HttpEntity httpEntity = null;
        try {
            String string;
            HttpResponse httpResponse = this.client.execute((HttpUriRequest)this.post, this.context);
            httpEntity = httpResponse.getEntity();
            byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
            String string2 = string = httpEntity.getContentEncoding() != null ? httpEntity.getContentEncoding().getValue() : null;
            if (ZLIBCodec.getID().equalsIgnoreCase(string)) {
                byArray = ZLIBCodec.decode(byArray);
            } else if (GZIPCodec.getID().equalsIgnoreCase(string)) {
                byArray = GZIPCodec.decode(byArray);
            }
            this.body = StaticBody.fromString(new String(byArray, CHARSET));
            this.statusCode = httpResponse.getStatusLine().getStatusCode();
            this.sent = true;
        }
        catch (IOException iOException) {
            this.abort();
            this.toThrow = new BOSHException("Could not obtain response", iOException);
            throw this.toThrow;
        }
        catch (RuntimeException runtimeException) {
            this.abort();
            throw runtimeException;
        }
    }
}

