/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Gateway;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class GatewayManager {
    private static Map<Connection, GatewayManager> instances = new HashMap<Connection, GatewayManager>();
    private ServiceDiscoveryManager sdManager;
    private Map<String, Gateway> localGateways = new HashMap<String, Gateway>();
    private Map<String, Gateway> nonLocalGateways = new HashMap<String, Gateway>();
    private Map<String, Gateway> gateways = new HashMap<String, Gateway>();
    private Connection connection;
    private Roster roster;

    private GatewayManager() {
    }

    private GatewayManager(Connection connection) throws XMPPException {
        this.connection = connection;
        this.roster = connection.getRoster();
        this.sdManager = ServiceDiscoveryManager.getInstanceFor(connection);
    }

    private void loadLocalGateways() throws XMPPException {
        DiscoverItems discoverItems = this.sdManager.discoverItems(this.connection.getHost());
        Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
        while (iterator.hasNext()) {
            String string = iterator.next().getEntityID();
            this.discoverGateway(string);
        }
    }

    private void discoverGateway(String string) throws XMPPException {
        DiscoverInfo discoverInfo = this.sdManager.discoverInfo(string);
        Iterator<DiscoverInfo.Identity> iterator = discoverInfo.getIdentities();
        while (iterator.hasNext()) {
            DiscoverInfo.Identity identity = iterator.next();
            String string2 = identity.getCategory();
            if (!string2.toLowerCase().equals("gateway")) continue;
            this.gateways.put(string, new Gateway(this.connection, string));
            if (string.contains(this.connection.getHost())) {
                this.localGateways.put(string, new Gateway(this.connection, string, discoverInfo, identity));
                break;
            }
            this.nonLocalGateways.put(string, new Gateway(this.connection, string, discoverInfo, identity));
            break;
        }
    }

    private void loadNonLocalGateways() throws XMPPException {
        if (this.roster != null) {
            for (RosterEntry rosterEntry : this.roster.getEntries()) {
                if (!rosterEntry.getUser().equalsIgnoreCase(StringUtils.parseServer(rosterEntry.getUser())) || rosterEntry.getUser().contains(this.connection.getHost())) continue;
                this.discoverGateway(rosterEntry.getUser());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatewayManager getInstanceFor(Connection connection) throws XMPPException {
        Map<Connection, GatewayManager> map = instances;
        synchronized (map) {
            if (instances.containsKey(connection)) {
                return instances.get(connection);
            }
            GatewayManager gatewayManager = new GatewayManager(connection);
            instances.put(connection, gatewayManager);
            return gatewayManager;
        }
    }

    public List<Gateway> getLocalGateways() throws XMPPException {
        if (this.localGateways.size() == 0) {
            this.loadLocalGateways();
        }
        return new ArrayList<Gateway>(this.localGateways.values());
    }

    public List<Gateway> getNonLocalGateways() throws XMPPException {
        if (this.nonLocalGateways.size() == 0) {
            this.loadNonLocalGateways();
        }
        return new ArrayList<Gateway>(this.nonLocalGateways.values());
    }

    public void refreshNonLocalGateways() throws XMPPException {
        this.loadNonLocalGateways();
    }

    public Gateway getGateway(String string) {
        if (this.localGateways.containsKey(string)) {
            return this.localGateways.get(string);
        }
        if (this.nonLocalGateways.containsKey(string)) {
            return this.nonLocalGateways.get(string);
        }
        if (this.gateways.containsKey(string)) {
            return this.gateways.get(string);
        }
        Gateway gateway = new Gateway(this.connection, string);
        if (string.contains(this.connection.getHost())) {
            this.localGateways.put(string, gateway);
        } else {
            this.nonLocalGateways.put(string, gateway);
        }
        this.gateways.put(string, gateway);
        return gateway;
    }
}

