package com.beem.project.beem.service.auth;

import android.content.Context;
import com.beem.project.beem.utils.EncryptionManager;
import org.jivesoftware.smack.util.Base64;

/**
 * Created by darisk on 07/01/16.
 */
public class EncryptedPasswordPreferenceAuthenticator extends PreferenceAuthenticator {
    private final String encryptionKeyAlias;
    private final String base64Iv;
    private final EncryptionManager encryptionManager;

    /**
     * Create a PreferenceAuthenticator.
     *
     * @param context the Android context.
     */
    public EncryptedPasswordPreferenceAuthenticator(Context context, String encryptionKeyAlias, String base64Iv) {
        super(context);
        this.encryptionKeyAlias = encryptionKeyAlias;
        this.base64Iv = base64Iv;
        encryptionManager = new EncryptionManager();
    }

    @Override
    protected String getPassword() {
        String password = super.getPassword();
        byte[] encryptionIv = Base64.decode(base64Iv);
        return encryptionManager.decryptString(password, encryptionKeyAlias, encryptionIv);
    }
}
