/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.workgroup.MetaData;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitation;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitationListener;
import org.jivesoftware.smackx.workgroup.ext.forms.WorkgroupForm;
import org.jivesoftware.smackx.workgroup.packet.DepartQueuePacket;
import org.jivesoftware.smackx.workgroup.packet.QueueUpdate;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.UserID;
import org.jivesoftware.smackx.workgroup.settings.ChatSetting;
import org.jivesoftware.smackx.workgroup.settings.ChatSettings;
import org.jivesoftware.smackx.workgroup.settings.OfflineSettings;
import org.jivesoftware.smackx.workgroup.settings.SoundSettings;
import org.jivesoftware.smackx.workgroup.settings.WorkgroupProperties;
import org.jivesoftware.smackx.workgroup.user.QueueListener;

public class Workgroup {
    private String workgroupJID;
    private XMPPConnection connection;
    private boolean inQueue;
    private List invitationListeners;
    private List queueListeners;
    private List siteInviteListeners;
    private int queuePosition = -1;
    private int queueRemainingTime = -1;

    public Workgroup(String workgroupJID, XMPPConnection connection) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must login to server before creating workgroup.");
        }
        this.workgroupJID = workgroupJID;
        this.connection = connection;
        this.inQueue = false;
        this.invitationListeners = new ArrayList();
        this.queueListeners = new ArrayList();
        this.siteInviteListeners = new ArrayList();
        this.addQueueListener(new QueueListener(){

            public void joinedQueue() {
                Workgroup.this.inQueue = true;
            }

            public void departedQueue() {
                Workgroup.this.inQueue = false;
                Workgroup.this.queuePosition = -1;
                Workgroup.this.queueRemainingTime = -1;
            }

            public void queuePositionUpdated(int currentPosition) {
                Workgroup.this.queuePosition = currentPosition;
            }

            public void queueWaitTimeUpdated(int secondsRemaining) {
                Workgroup.this.queueRemainingTime = secondsRemaining;
            }
        });
        MultiUserChat.addInvitationListener(connection, new InvitationListener(){

            public void invitationReceived(XMPPConnection conn, String room, String inviter, String reason, String password, Message message) {
                Workgroup.this.inQueue = false;
                Workgroup.this.queuePosition = -1;
                Workgroup.this.queueRemainingTime = -1;
            }
        });
        PacketTypeFilter typeFilter = new PacketTypeFilter(Message.class);
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Workgroup.this.handlePacket(packet);
            }
        }, typeFilter);
    }

    public String getWorkgroupJID() {
        return this.workgroupJID;
    }

    public boolean isInQueue() {
        return this.inQueue;
    }

    public boolean isAvailable() {
        Presence directedPresence = new Presence(Presence.Type.available);
        directedPresence.setTo(this.workgroupJID);
        PacketTypeFilter typeFilter = new PacketTypeFilter(Presence.class);
        FromContainsFilter fromFilter = new FromContainsFilter(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector(new AndFilter(fromFilter, typeFilter));
        this.connection.sendPacket(directedPresence);
        Presence response = (Presence)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            return false;
        }
        if (response.getError() != null) {
            return false;
        }
        return Presence.Type.available == response.getType();
    }

    public int getQueuePosition() {
        return this.queuePosition;
    }

    public int getQueueRemainingTime() {
        return this.queueRemainingTime;
    }

    public void joinQueue() throws XMPPException {
        this.joinQueue(null);
    }

    public void joinQueue(Form answerForm) throws XMPPException {
        this.joinQueue(answerForm, null);
    }

    public void joinQueue(Form answerForm, String userID) throws XMPPException {
        if (this.inQueue) {
            throw new IllegalStateException("Already in queue " + this.workgroupJID);
        }
        JoinQueuePacket joinPacket = new JoinQueuePacket(this.workgroupJID, answerForm, userID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(joinPacket.getPacketID()));
        this.connection.sendPacket(joinPacket);
        IQ response = (IQ)collector.nextResult(10000L);
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        this.fireQueueJoinedEvent();
    }

    public void joinQueue(Map metadata, String userID) throws XMPPException {
        if (this.inQueue) {
            throw new IllegalStateException("Already in queue " + this.workgroupJID);
        }
        Form form = new Form("submit");
        for (String name : metadata.keySet()) {
            String value = metadata.get(name).toString();
            String escapedName = StringUtils.escapeForXML(name);
            String escapedValue = StringUtils.escapeForXML(value);
            FormField field = new FormField(escapedName);
            field.setType("text-single");
            form.addField(field);
            form.setAnswer(escapedName, escapedValue);
        }
        this.joinQueue(form, userID);
    }

    public void departQueue() throws XMPPException {
        if (!this.inQueue) {
            return;
        }
        DepartQueuePacket departPacket = new DepartQueuePacket(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(departPacket.getPacketID()));
        this.connection.sendPacket(departPacket);
        IQ response = (IQ)collector.nextResult(5000L);
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        this.fireQueueDepartedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueListener(QueueListener queueListener) {
        List list = this.queueListeners;
        synchronized (list) {
            if (!this.queueListeners.contains(queueListener)) {
                this.queueListeners.add(queueListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(QueueListener queueListener) {
        List list = this.queueListeners;
        synchronized (list) {
            this.queueListeners.remove(queueListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(WorkgroupInvitationListener invitationListener) {
        List list = this.invitationListeners;
        synchronized (list) {
            if (!this.invitationListeners.contains(invitationListener)) {
                this.invitationListeners.add(invitationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(WorkgroupInvitationListener invitationListener) {
        List list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.remove(invitationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationEvent(WorkgroupInvitation invitation) {
        List list = this.invitationListeners;
        synchronized (list) {
            for (WorkgroupInvitationListener listener : this.invitationListeners) {
                listener.invitationReceived(invitation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueJoinedEvent() {
        List list = this.queueListeners;
        synchronized (list) {
            for (QueueListener listener : this.queueListeners) {
                listener.joinedQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueDepartedEvent() {
        List list = this.queueListeners;
        synchronized (list) {
            for (QueueListener listener : this.queueListeners) {
                listener.departedQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueuePositionEvent(int currentPosition) {
        List list = this.queueListeners;
        synchronized (list) {
            for (QueueListener listener : this.queueListeners) {
                listener.queuePositionUpdated(currentPosition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueTimeEvent(int secondsRemaining) {
        List list = this.queueListeners;
        synchronized (list) {
            for (QueueListener listener : this.queueListeners) {
                listener.queueWaitTimeUpdated(secondsRemaining);
            }
        }
    }

    private void handlePacket(Packet packet) {
        if (packet instanceof Message) {
            Message msg = (Message)packet;
            PacketExtension pe = msg.getExtension("depart-queue", "http://jabber.org/protocol/workgroup");
            PacketExtension queueStatus = msg.getExtension("queue-status", "http://jabber.org/protocol/workgroup");
            if (pe != null) {
                this.fireQueueDepartedEvent();
            } else if (queueStatus != null) {
                QueueUpdate queueUpdate = (QueueUpdate)queueStatus;
                if (queueUpdate.getPosition() != -1) {
                    this.fireQueuePositionEvent(queueUpdate.getPosition());
                }
                if (queueUpdate.getRemaingTime() != -1) {
                    this.fireQueueTimeEvent(queueUpdate.getRemaingTime());
                }
            } else {
                MUCUser.Invite invite;
                MUCUser mucUser = (MUCUser)msg.getExtension("x", "http://jabber.org/protocol/muc#user");
                MUCUser.Invite invite2 = invite = mucUser != null ? mucUser.getInvite() : null;
                if (invite != null && this.workgroupJID.equals(invite.getFrom())) {
                    String sessionID = null;
                    Map metaData = null;
                    pe = msg.getExtension("session", "http://jivesoftware.com/protocol/workgroup");
                    if (pe != null) {
                        sessionID = ((SessionID)pe).getSessionID();
                    }
                    if ((pe = msg.getExtension("metadata", "http://jivesoftware.com/protocol/workgroup")) != null) {
                        metaData = ((MetaData)pe).getMetaData();
                    }
                    WorkgroupInvitation inv = new WorkgroupInvitation(this.connection.getUser(), msg.getFrom(), this.workgroupJID, sessionID, msg.getBody(), msg.getFrom(), metaData);
                    this.fireInvitationEvent(inv);
                }
            }
        }
    }

    public ChatSetting getChatSetting(String key) throws XMPPException {
        ChatSettings chatSettings = this.getChatSettings(key, -1);
        return chatSettings.getFirstEntry();
    }

    public ChatSettings getChatSettings(int type) throws XMPPException {
        return this.getChatSettings(null, type);
    }

    public ChatSettings getChatSettings() throws XMPPException {
        return this.getChatSettings(null, -1);
    }

    private ChatSettings getChatSettings(String key, int type) throws XMPPException {
        ChatSettings request = new ChatSettings();
        if (key != null) {
            request.setKey(key);
        }
        if (type != -1) {
            request.setType(type);
        }
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket(request);
        ChatSettings response = (ChatSettings)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public boolean isEmailAvailable() {
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        try {
            String workgroupService = StringUtils.parseServer(this.workgroupJID);
            DiscoverInfo infoResult = discoManager.discoverInfo(workgroupService);
            return infoResult.containsFeature("jive:email:provider");
        }
        catch (XMPPException e) {
            return false;
        }
    }

    public OfflineSettings getOfflineSettings() throws XMPPException {
        OfflineSettings request = new OfflineSettings();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket(request);
        OfflineSettings response = (OfflineSettings)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public SoundSettings getSoundSettings() throws XMPPException {
        SoundSettings request = new SoundSettings();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket(request);
        SoundSettings response = (SoundSettings)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public WorkgroupProperties getWorkgroupProperties() throws XMPPException {
        WorkgroupProperties request = new WorkgroupProperties();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket(request);
        WorkgroupProperties response = (WorkgroupProperties)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public WorkgroupProperties getWorkgroupProperties(String jid) throws XMPPException {
        WorkgroupProperties request = new WorkgroupProperties();
        request.setJid(jid);
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket(request);
        WorkgroupProperties response = (WorkgroupProperties)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public Form getWorkgroupForm() throws XMPPException {
        WorkgroupForm workgroupForm = new WorkgroupForm();
        workgroupForm.setType(IQ.Type.GET);
        workgroupForm.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(workgroupForm.getPacketID()));
        this.connection.sendPacket(workgroupForm);
        WorkgroupForm response = (WorkgroupForm)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return Form.getFormFrom(response);
    }

    private class JoinQueuePacket
    extends IQ {
        private String userID = null;
        private DataForm form;

        public JoinQueuePacket(String workgroup2, Form answerForm, String userID) {
            this.userID = userID;
            this.setTo(workgroup2);
            this.setType(IQ.Type.SET);
            this.form = answerForm.getDataFormToSend();
            this.addExtension(this.form);
        }

        public String getChildElementXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<join-queue xmlns=\"http://jabber.org/protocol/workgroup\">");
            buf.append("<queue-notifications/>");
            if (Workgroup.this.connection.isAnonymous()) {
                buf.append(new UserID(this.userID).toXML());
            }
            buf.append(this.form.toXML());
            buf.append("</join-queue>");
            return buf.toString();
        }
    }
}

