/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketParserUtils {
    private static final String PROPERTIES_NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";

    public static Packet parseMessage(XmlPullParser xmlPullParser) throws Exception {
        Message message = new Message();
        String string = xmlPullParser.getAttributeValue("", "id");
        message.setPacketID(string == null ? "ID_NOT_AVAILABLE" : string);
        message.setTo(xmlPullParser.getAttributeValue("", "to"));
        message.setFrom(xmlPullParser.getAttributeValue("", "from"));
        message.setType(Message.Type.fromString(xmlPullParser.getAttributeValue("", "type")));
        String string2 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
        if (string2 != null && !"".equals(string2.trim())) {
            message.setLanguage(string2);
        }
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        Map<String, Object> map = null;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string5 = xmlPullParser.getName();
                String string6 = xmlPullParser.getNamespace();
                if (string5.equals("subject")) {
                    if (string3 != null) continue;
                    string3 = xmlPullParser.nextText();
                    continue;
                }
                if (string5.equals("body")) {
                    String string7 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
                    String string8 = xmlPullParser.nextText();
                    message.addBody(string7, string8);
                    continue;
                }
                if (string5.equals("thread")) {
                    if (string4 != null) continue;
                    string4 = xmlPullParser.nextText();
                    continue;
                }
                if (string5.equals("error")) {
                    message.setError(PacketParserUtils.parseError(xmlPullParser));
                    continue;
                }
                if (string5.equals("properties") && string6.equals(PROPERTIES_NAMESPACE)) {
                    map = PacketParserUtils.parseProperties(xmlPullParser);
                    continue;
                }
                message.addExtension(PacketParserUtils.parsePacketExtension(string5, string6, xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("message")) continue;
            bl = true;
        }
        message.setSubject(string3);
        message.setThread(string4);
        if (map != null) {
            for (String string5 : map.keySet()) {
                message.setProperty(string5, map.get(string5));
            }
        }
        return message;
    }

    public static Presence parsePresence(XmlPullParser xmlPullParser) throws Exception {
        Presence.Type type = Presence.Type.available;
        String string = xmlPullParser.getAttributeValue("", "type");
        if (string != null && !string.equals("")) {
            try {
                type = Presence.Type.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Found invalid presence type " + string);
            }
        }
        Presence presence = new Presence(type);
        presence.setTo(xmlPullParser.getAttributeValue("", "to"));
        presence.setFrom(xmlPullParser.getAttributeValue("", "from"));
        String string2 = xmlPullParser.getAttributeValue("", "id");
        presence.setPacketID(string2 == null ? "ID_NOT_AVAILABLE" : string2);
        String string3 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
        if (string3 != null && !"".equals(string3.trim())) {
            presence.setLanguage(string3);
        }
        presence.setPacketID(string2 == null ? "ID_NOT_AVAILABLE" : string2);
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string4 = xmlPullParser.getName();
                String string5 = xmlPullParser.getNamespace();
                if (string4.equals("status")) {
                    presence.setStatus(xmlPullParser.nextText());
                    continue;
                }
                if (string4.equals("priority")) {
                    try {
                        int n2 = Integer.parseInt(xmlPullParser.nextText());
                        presence.setPriority(n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        presence.setPriority(0);
                    }
                    continue;
                }
                if (string4.equals("show")) {
                    String string6 = xmlPullParser.nextText();
                    try {
                        presence.setMode(Presence.Mode.valueOf(string6));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("Found invalid presence mode " + string6);
                    }
                    continue;
                }
                if (string4.equals("error")) {
                    presence.setError(PacketParserUtils.parseError(xmlPullParser));
                    continue;
                }
                if (string4.equals("properties") && string5.equals(PROPERTIES_NAMESPACE)) {
                    Map<String, Object> map = PacketParserUtils.parseProperties(xmlPullParser);
                    for (String string7 : map.keySet()) {
                        presence.setProperty(string7, map.get(string7));
                    }
                    continue;
                }
                presence.addExtension(PacketParserUtils.parsePacketExtension(string4, string5, xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("presence")) continue;
            bl = true;
        }
        return presence;
    }

    public static IQ parseIQ(XmlPullParser xmlPullParser, Connection connection) throws Exception {
        Packet packet = null;
        String string = xmlPullParser.getAttributeValue("", "id");
        String string2 = xmlPullParser.getAttributeValue("", "to");
        String string3 = xmlPullParser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(xmlPullParser.getAttributeValue("", "type"));
        XMPPError xMPPError = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string4 = xmlPullParser.getName();
                String string5 = xmlPullParser.getNamespace();
                if (string4.equals("error")) {
                    xMPPError = PacketParserUtils.parseError(xmlPullParser);
                    continue;
                }
                if (string4.equals("query") && string5.equals("jabber:iq:auth")) {
                    packet = PacketParserUtils.parseAuthentication(xmlPullParser);
                    continue;
                }
                if (string4.equals("query") && string5.equals("jabber:iq:roster")) {
                    packet = PacketParserUtils.parseRoster(xmlPullParser);
                    continue;
                }
                if (string4.equals("query") && string5.equals("jabber:iq:register")) {
                    packet = PacketParserUtils.parseRegistration(xmlPullParser);
                    continue;
                }
                if (string4.equals("bind") && string5.equals("urn:ietf:params:xml:ns:xmpp-bind")) {
                    packet = PacketParserUtils.parseResourceBinding(xmlPullParser);
                    continue;
                }
                Object object = ProviderManager.getInstance().getIQProvider(string4, string5);
                if (object == null) continue;
                if (object instanceof IQProvider) {
                    packet = ((IQProvider)object).parseIQ(xmlPullParser);
                    continue;
                }
                if (!(object instanceof Class)) continue;
                packet = (IQ)PacketParserUtils.parseWithIntrospection(string4, (Class)object, xmlPullParser);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("iq")) continue;
            bl = true;
        }
        if (packet == null) {
            if (IQ.Type.GET == type || IQ.Type.SET == type) {
                packet = new IQ(){

                    public String getChildElementXML() {
                        return null;
                    }
                };
                packet.setPacketID(string);
                packet.setTo(string3);
                packet.setFrom(string2);
                ((IQ)packet).setType(IQ.Type.ERROR);
                packet.setError(new XMPPError(XMPPError.Condition.feature_not_implemented));
                connection.sendPacket(packet);
                return null;
            }
            packet = new IQ(){

                public String getChildElementXML() {
                    return null;
                }
            };
        }
        packet.setPacketID(string);
        packet.setTo(string2);
        packet.setFrom(string3);
        ((IQ)packet).setType(type);
        packet.setError(xMPPError);
        return packet;
    }

    private static Authentication parseAuthentication(XmlPullParser xmlPullParser) throws Exception {
        Authentication authentication = new Authentication();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("username")) {
                    authentication.setUsername(xmlPullParser.nextText());
                    continue;
                }
                if (xmlPullParser.getName().equals("password")) {
                    authentication.setPassword(xmlPullParser.nextText());
                    continue;
                }
                if (xmlPullParser.getName().equals("digest")) {
                    authentication.setDigest(xmlPullParser.nextText());
                    continue;
                }
                if (!xmlPullParser.getName().equals("resource")) continue;
                authentication.setResource(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return authentication;
    }

    private static RosterPacket parseRoster(XmlPullParser xmlPullParser) throws Exception {
        RosterPacket rosterPacket = new RosterPacket();
        boolean bl = false;
        RosterPacket.Item item = null;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string;
                if (xmlPullParser.getName().equals("item")) {
                    string = xmlPullParser.getAttributeValue("", "jid");
                    String string2 = xmlPullParser.getAttributeValue("", "name");
                    item = new RosterPacket.Item(string, string2);
                    String string3 = xmlPullParser.getAttributeValue("", "ask");
                    RosterPacket.ItemStatus itemStatus = RosterPacket.ItemStatus.fromString(string3);
                    item.setItemStatus(itemStatus);
                    String string4 = xmlPullParser.getAttributeValue("", "subscription");
                    RosterPacket.ItemType itemType = RosterPacket.ItemType.valueOf(string4 != null ? string4 : "none");
                    item.setItemType(itemType);
                }
                if (!xmlPullParser.getName().equals("group") || item == null || (string = xmlPullParser.nextText()) == null || string.trim().length() <= 0) continue;
                item.addGroupName(string);
                continue;
            }
            if (n != 3) continue;
            if (xmlPullParser.getName().equals("item")) {
                rosterPacket.addRosterItem(item);
            }
            if (!xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return rosterPacket;
    }

    private static Registration parseRegistration(XmlPullParser xmlPullParser) throws Exception {
        Registration registration = new Registration();
        HashMap<String, String> hashMap = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getNamespace().equals("jabber:iq:register")) {
                    String string = xmlPullParser.getName();
                    String string2 = "";
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    if (xmlPullParser.next() == 4) {
                        string2 = xmlPullParser.getText();
                    }
                    if (!string.equals("instructions")) {
                        hashMap.put(string, string2);
                        continue;
                    }
                    registration.setInstructions(string2);
                    continue;
                }
                registration.addExtension(PacketParserUtils.parsePacketExtension(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        registration.setAttributes(hashMap);
        return registration;
    }

    private static Bind parseResourceBinding(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        Bind bind = new Bind();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("resource")) {
                    bind.setResource(xmlPullParser.nextText());
                    continue;
                }
                if (!xmlPullParser.getName().equals("jid")) continue;
                bind.setJid(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("bind")) continue;
            bl = true;
        }
        return bind;
    }

    public static Collection<String> parseMechanisms(XmlPullParser xmlPullParser) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string = xmlPullParser.getName();
                if (!string.equals("mechanism")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("mechanisms")) continue;
            bl = true;
        }
        return arrayList;
    }

    public static Collection<String> parseCompressionMethods(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string = xmlPullParser.getName();
                if (!string.equals("method")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("compression")) continue;
            bl = true;
        }
        return arrayList;
    }

    public static Map<String, Object> parseProperties(XmlPullParser xmlPullParser) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block2: while (true) {
            int n;
            if ((n = xmlPullParser.next()) == 2 && xmlPullParser.getName().equals("property")) {
                boolean bl = false;
                String string = null;
                String string2 = null;
                String string3 = null;
                Object object = null;
                while (true) {
                    Object object2;
                    if (bl) continue block2;
                    n = xmlPullParser.next();
                    if (n == 2) {
                        object2 = xmlPullParser.getName();
                        if (((String)object2).equals("name")) {
                            string = xmlPullParser.nextText();
                            continue;
                        }
                        if (!((String)object2).equals("value")) continue;
                        string2 = xmlPullParser.getAttributeValue("", "type");
                        string3 = xmlPullParser.nextText();
                        continue;
                    }
                    if (n != 3 || !xmlPullParser.getName().equals("property")) continue;
                    if ("integer".equals(string2)) {
                        object = Integer.valueOf(string3);
                    } else if ("long".equals(string2)) {
                        object = Long.valueOf(string3);
                    } else if ("float".equals(string2)) {
                        object = Float.valueOf(string3);
                    } else if ("double".equals(string2)) {
                        object = Double.valueOf(string3);
                    } else if ("boolean".equals(string2)) {
                        object = Boolean.valueOf(string3);
                    } else if ("string".equals(string2)) {
                        object = string3;
                    } else if ("java-object".equals(string2)) {
                        try {
                            object2 = StringUtils.decodeBase64(string3);
                            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object2));
                            object = objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (string != null && object != null) {
                        hashMap.put(string, object);
                    }
                    bl = true;
                }
            }
            if (n == 3 && xmlPullParser.getName().equals("properties")) break;
        }
        return hashMap;
    }

    public static SASLMechanism.Failure parseSASLFailure(XmlPullParser xmlPullParser) throws Exception {
        String string = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("failure")) continue;
                string = xmlPullParser.getName();
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("failure")) continue;
            bl = true;
        }
        return new SASLMechanism.Failure(string);
    }

    public static StreamError parseStreamError(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        StreamError streamError = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                streamError = new StreamError(xmlPullParser.getName());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("error")) continue;
            bl = true;
        }
        return streamError;
    }

    public static XMPPError parseError(XmlPullParser xmlPullParser) throws Exception {
        int n;
        String string = "-1";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ArrayList<PacketExtension> arrayList = new ArrayList<PacketExtension>();
        for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
            if (xmlPullParser.getAttributeName(n).equals("code")) {
                string = xmlPullParser.getAttributeValue("", "code");
            }
            if (!xmlPullParser.getAttributeName(n).equals("type")) continue;
            string2 = xmlPullParser.getAttributeValue("", "type");
        }
        n = 0;
        while (n == 0) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getName().equals("text")) {
                    string3 = xmlPullParser.nextText();
                    continue;
                }
                String string5 = xmlPullParser.getName();
                String string6 = xmlPullParser.getNamespace();
                if ("urn:ietf:params:xml:ns:xmpp-stanzas".equals(string6)) {
                    string4 = string5;
                    continue;
                }
                arrayList.add(PacketParserUtils.parsePacketExtension(string5, string6, xmlPullParser));
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("error")) continue;
            n = 1;
        }
        XMPPError.Type type = XMPPError.Type.CANCEL;
        try {
            if (string2 != null) {
                type = XMPPError.Type.valueOf(string2.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return new XMPPError(Integer.parseInt(string), type, string4, string3, arrayList);
    }

    public static PacketExtension parsePacketExtension(String string, String string2, XmlPullParser xmlPullParser) throws Exception {
        Object object = ProviderManager.getInstance().getExtensionProvider(string, string2);
        if (object != null) {
            if (object instanceof PacketExtensionProvider) {
                return ((PacketExtensionProvider)object).parseExtension(xmlPullParser);
            }
            if (object instanceof Class) {
                return (PacketExtension)PacketParserUtils.parseWithIntrospection(string, (Class)object, xmlPullParser);
            }
        }
        DefaultPacketExtension defaultPacketExtension = new DefaultPacketExtension(string, string2);
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string3 = xmlPullParser.getName();
                if (xmlPullParser.isEmptyElementTag()) {
                    defaultPacketExtension.setValue(string3, "");
                    continue;
                }
                n = xmlPullParser.next();
                if (n != 4) continue;
                String string4 = xmlPullParser.getText();
                defaultPacketExtension.setValue(string3, string4);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals(string)) continue;
            bl = true;
        }
        return defaultPacketExtension;
    }

    private static String getLanguageAttribute(XmlPullParser xmlPullParser) {
        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
            String string = xmlPullParser.getAttributeName(i);
            if (!"xml:lang".equals(string) && (!"lang".equals(string) || !"xml".equals(xmlPullParser.getAttributePrefix(i)))) continue;
            return xmlPullParser.getAttributeValue(i);
        }
        return null;
    }

    public static Object parseWithIntrospection(String string, Class clazz, XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        Object t = clazz.newInstance();
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string2 = xmlPullParser.getName();
                String string3 = xmlPullParser.nextText();
                Class<?> clazz2 = t.getClass().getMethod("get" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1), new Class[0]).getReturnType();
                Object object = PacketParserUtils.decode(clazz2, string3);
                t.getClass().getMethod("set" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1), clazz2).invoke(t, object);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals(string)) continue;
            bl = true;
        }
        return t;
    }

    private static Object decode(Class clazz, String string) throws Exception {
        if (clazz.getName().equals("java.lang.String")) {
            return string;
        }
        if (clazz.getName().equals("boolean")) {
            return Boolean.valueOf(string);
        }
        if (clazz.getName().equals("int")) {
            return Integer.valueOf(string);
        }
        if (clazz.getName().equals("long")) {
            return Long.valueOf(string);
        }
        if (clazz.getName().equals("float")) {
            return Float.valueOf(string);
        }
        if (clazz.getName().equals("double")) {
            return Double.valueOf(string);
        }
        if (clazz.getName().equals("java.lang.Class")) {
            return Class.forName(string);
        }
        return null;
    }
}

