/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolverListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportResolver {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(TransportResolver.class);
    public Type type = Type.rawupd;
    public static final int CHECK_TIMEOUT = 3000;
    private final ArrayList<TransportResolverListener> listeners = new ArrayList();
    private boolean resolving = false;
    private boolean resolved = false;
    private boolean initialized = false;
    protected final List<TransportCandidate> candidates = new ArrayList<TransportCandidate>();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    protected TransportResolver() {
    }

    public abstract void initialize() throws XMPPException;

    public abstract void resolve(JingleSession var1) throws XMPPException;

    public void clear() throws XMPPException {
        this.cancel();
        this.candidates.clear();
    }

    public abstract void cancel() throws XMPPException;

    public boolean isResolving() {
        return this.resolving;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public synchronized void setInitialized() {
        this.initialized = true;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    protected synchronized void setResolveInit() {
        this.resolved = false;
        this.resolving = true;
        this.triggerResolveInit();
    }

    protected synchronized void setResolveEnd() {
        this.resolved = true;
        this.resolving = false;
        this.triggerResolveEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TransportResolverListener li) {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TransportResolverListener li) {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getListenersList() {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<TransportResolverListener>(this.listeners);
        }
    }

    protected void triggerCandidateAdded(TransportCandidate cand) {
        for (TransportResolverListener trl : this.getListenersList()) {
            if (!(trl instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver li = (TransportResolverListener.Resolver)trl;
            LOGGER.debug("triggerCandidateAdded : " + cand.getLocalIp());
            li.candidateAdded(cand);
        }
    }

    private void triggerResolveInit() {
        for (TransportResolverListener trl : this.getListenersList()) {
            if (!(trl instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver li = (TransportResolverListener.Resolver)trl;
            li.init();
        }
    }

    private void triggerResolveEnd() {
        for (TransportResolverListener trl : this.getListenersList()) {
            if (!(trl instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver li = (TransportResolverListener.Resolver)trl;
            li.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCandidates() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            this.candidates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCandidate(TransportCandidate cand) {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            if (!this.candidates.contains(cand)) {
                this.candidates.add(cand);
            }
        }
        this.triggerCandidateAdded(cand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCandidates() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<TransportCandidate>(this.candidates)).iterator();
        }
    }

    public TransportCandidate getPreferredCandidate() {
        TransportCandidate result = null;
        ArrayList cands = (ArrayList)this.getCandidatesList();
        if (cands.size() > 0) {
            Collections.sort(cands);
            result = (TransportCandidate)cands.get(cands.size() - 1);
            LOGGER.debug("Result: " + result.getIp());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCandidateCount() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            return this.candidates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransportCandidate> getCandidatesList() {
        ArrayList<TransportCandidate> result = null;
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            result = new ArrayList<TransportCandidate>(this.candidates);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportCandidate getCandidate(int i) {
        TransportCandidate cand;
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            cand = this.candidates.get(i);
        }
        return cand;
    }

    public void initializeAndWait() throws XMPPException {
        this.initialize();
        try {
            LOGGER.debug("Initializing transport resolver...");
            while (!this.isInitialized()) {
                LOGGER.debug("Resolver init still pending");
                Thread.sleep(1000L);
            }
            LOGGER.debug("Transport resolved\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getFreePort() {
        int freePort = 0;
        for (int i = 0; i < 10; ++i) {
            freePort = (int)(10000L + Math.round(Math.random() * 10000.0));
            freePort = freePort % 2 == 0 ? freePort : freePort + 1;
            try {
                ServerSocket ss = new ServerSocket(freePort);
                freePort = ss.getLocalPort();
                ss.close();
                return freePort;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
        }
        try {
            ServerSocket ss = new ServerSocket(0);
            freePort = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return freePort;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        rawupd,
        ice;

    }
}

