/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import org.umlgraph.doclet.ClassMatcher;
import org.umlgraph.doclet.OptionProvider;
import org.umlgraph.doclet.Options;
import org.umlgraph.doclet.PackageMatcher;

public class PackageView
implements OptionProvider {
    private PackageDoc pd;
    private OptionProvider parent;
    private ClassMatcher matcher;
    private String outputPath;

    public PackageView(String outputFolder, PackageDoc pd, RootDoc root, OptionProvider parent) {
        this.parent = parent;
        this.pd = pd;
        this.matcher = new PackageMatcher(pd);
        this.outputPath = pd.name().replace('.', '/') + "/" + pd.name() + ".dot";
    }

    @Override
    public String getDisplayName() {
        return "Package view for package " + this.pd;
    }

    @Override
    public Options getGlobalOptions() {
        Options go = this.parent.getGlobalOptions();
        go.setOption(new String[]{"-output", this.outputPath});
        go.setOption(new String[]{"-hide"});
        return go;
    }

    @Override
    public Options getOptionsFor(ClassDoc cd) {
        Options go = this.parent.getGlobalOptions();
        this.overrideForClass(go, cd);
        return go;
    }

    @Override
    public Options getOptionsFor(String name) {
        Options go = this.parent.getGlobalOptions();
        this.overrideForClass(go, name);
        return go;
    }

    @Override
    public void overrideForClass(Options opt, ClassDoc cd) {
        opt.showQualified = false;
        if (!this.matcher.matches(cd) || this.parent.getGlobalOptions().matchesHideExpression(cd.name())) {
            opt.setOption(new String[]{"-hide"});
        }
    }

    @Override
    public void overrideForClass(Options opt, String className) {
        opt.showQualified = false;
        if (!this.matcher.matches(className)) {
            opt.setOption(new String[]{"-hide"});
        }
    }
}

