/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transcripts
extends IQ {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private String userID;
    private List<TranscriptSummary> summaries;

    public Transcripts(String string) {
        this.userID = string;
        this.summaries = new ArrayList<TranscriptSummary>();
    }

    public Transcripts(String string, List<TranscriptSummary> list) {
        this.userID = string;
        this.summaries = list;
    }

    public String getUserID() {
        return this.userID;
    }

    public List<TranscriptSummary> getSummaries() {
        return Collections.unmodifiableList(this.summaries);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<transcripts xmlns=\"http://jivesoftware.com/protocol/workgroup\" userID=\"").append(this.userID).append("\">");
        for (TranscriptSummary transcriptSummary : this.summaries) {
            stringBuilder.append(transcriptSummary.toXML());
        }
        stringBuilder.append("</transcripts>");
        return stringBuilder.toString();
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }

    public static class AgentDetail {
        private String agentJID;
        private Date joinTime;
        private Date leftTime;

        public AgentDetail(String string, Date date, Date date2) {
            this.agentJID = string;
            this.joinTime = date;
            this.leftTime = date2;
        }

        public String getAgentJID() {
            return this.agentJID;
        }

        public Date getJoinTime() {
            return this.joinTime;
        }

        public Date getLeftTime() {
            return this.leftTime;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<agent>");
            if (this.agentJID != null) {
                stringBuilder.append("<agentJID>").append(this.agentJID).append("</agentJID>");
            }
            if (this.joinTime != null) {
                stringBuilder.append("<joinTime>").append(UTC_FORMAT.format(this.joinTime)).append("</joinTime>");
            }
            if (this.leftTime != null) {
                stringBuilder.append("<leftTime>").append(UTC_FORMAT.format(this.leftTime)).append("</leftTime>");
            }
            stringBuilder.append("</agent>");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TranscriptSummary {
        private String sessionID;
        private Date joinTime;
        private Date leftTime;
        private List<AgentDetail> agentDetails;

        public TranscriptSummary(String string, Date date, Date date2, List<AgentDetail> list) {
            this.sessionID = string;
            this.joinTime = date;
            this.leftTime = date2;
            this.agentDetails = list;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public Date getJoinTime() {
            return this.joinTime;
        }

        public Date getLeftTime() {
            return this.leftTime;
        }

        public List<AgentDetail> getAgentDetails() {
            return this.agentDetails;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<transcript sessionID=\"").append(this.sessionID).append("\">");
            if (this.joinTime != null) {
                stringBuilder.append("<joinTime>").append(UTC_FORMAT.format(this.joinTime)).append("</joinTime>");
            }
            if (this.leftTime != null) {
                stringBuilder.append("<leftTime>").append(UTC_FORMAT.format(this.leftTime)).append("</leftTime>");
            }
            stringBuilder.append("<agents>");
            for (AgentDetail agentDetail : this.agentDetails) {
                stringBuilder.append(agentDetail.toXML());
            }
            stringBuilder.append("</agents></transcript>");
            return stringBuilder.toString();
        }
    }
}

