/**
 * 
 */
package com.beem.project.beem.service;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

import android.os.RemoteException;

import com.beem.project.beem.BeemException;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXMPPConnection;

/**
 * @author darisk
 *
 */
public class XMPPConnectionAdapter extends IXMPPConnection.Stub {
  
    private XMPPConnection adaptee;
    private BeemException lastException;
    
    public XMPPConnectionAdapter(XMPPConnection con) {
	adaptee = con;
    }

    public XMPPConnectionAdapter(String serviceName) {
	adaptee = new XMPPConnection(serviceName);
    }
    
    public XMPPConnectionAdapter(ConnectionConfiguration config) { 
    	adaptee = new XMPPConnection(config);
    }

    public boolean connect() {
	try {
	    adaptee.connect();
	    lastException = null;
	    return true;
	} catch (XMPPException e) {
	    lastException = new BeemException(e);
	}
	return false;
    }
    
    public boolean disconnect() {
	adaptee.disconnect();
	lastException = null;
	return true;
    }

    public boolean login(String username, String password, String resource) {
	try {
	    adaptee.login(username, password, resource);
	    lastException = null;
	    return true;
	} catch (XMPPException e) {
	    lastException = new BeemException(e);
	}
	return false;
    }

    @Override
    public IRoster getRoster() throws RemoteException {
	return new RosterAdapter(adaptee.getRoster());
    }
}
