/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import org.xbill.DNS.ClientSubnetOption;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.GenericEDNSOption;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.NSIDOption;
import org.xbill.DNS.Record;
import org.xbill.DNS.WireParseException;

public abstract class EDNSOption {
    private final int code;

    public EDNSOption(int n) {
        this.code = Record.checkU16("code", n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(Code.string(this.code));
        stringBuffer.append(": ");
        stringBuffer.append(this.optionToString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int getCode() {
        return this.code;
    }

    byte[] getData() {
        DNSOutput dNSOutput = new DNSOutput();
        this.optionToWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    abstract void optionFromWire(DNSInput var1) throws IOException;

    static EDNSOption fromWire(DNSInput dNSInput) throws IOException {
        EDNSOption eDNSOption;
        int n = dNSInput.readU16();
        int n2 = dNSInput.readU16();
        if (dNSInput.remaining() < n2) {
            throw new WireParseException("truncated option");
        }
        int n3 = dNSInput.saveActive();
        dNSInput.setActive(n2);
        switch (n) {
            case 3: {
                eDNSOption = new NSIDOption();
                break;
            }
            case 20730: {
                eDNSOption = new ClientSubnetOption();
                break;
            }
            default: {
                eDNSOption = new GenericEDNSOption(n);
            }
        }
        eDNSOption.optionFromWire(dNSInput);
        dNSInput.restoreActive(n3);
        return eDNSOption;
    }

    public static EDNSOption fromWire(byte[] byArray) throws IOException {
        return EDNSOption.fromWire(new DNSInput(byArray));
    }

    abstract void optionToWire(DNSOutput var1);

    void toWire(DNSOutput dNSOutput) {
        dNSOutput.writeU16(this.code);
        int n = dNSOutput.current();
        dNSOutput.writeU16(0);
        this.optionToWire(dNSOutput);
        int n2 = dNSOutput.current() - n - 2;
        dNSOutput.writeU16At(n2, n);
    }

    public byte[] toWire() throws IOException {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EDNSOption)) {
            return false;
        }
        EDNSOption eDNSOption = (EDNSOption)object;
        if (this.code != eDNSOption.code) {
            return false;
        }
        return Arrays.equals(this.getData(), eDNSOption.getData());
    }

    public int hashCode() {
        byte[] byArray = this.getData();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += (n << 3) + (byArray[i] & 0xFF);
        }
        return n;
    }

    abstract String optionToString();

    public static class Code {
        public static final int NSID = 3;
        public static final int CLIENT_SUBNET = 20730;
        private static Mnemonic codes = new Mnemonic("EDNS Option Codes", 2);

        private Code() {
        }

        public static String string(int n) {
            return codes.getText(n);
        }

        public static int value(String string) {
            return codes.getValue(string);
        }

        static {
            codes.setMaximum(65535);
            codes.setPrefix("CODE");
            codes.setNumericAllowed(true);
            codes.add(3, "NSID");
            codes.add(20730, "CLIENT_SUBNET");
        }
    }
}

