/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.entitycaps;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.entitycaps.Base64Encoder;
import org.jivesoftware.smackx.entitycaps.EntityCapsManager;
import org.jivesoftware.smackx.entitycaps.EntityCapsPersistentCache;
import org.jivesoftware.smackx.entitycaps.StringEncoder;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private File cacheDir;
    private StringEncoder stringEncoder;

    public SimpleDirectoryPersistentCache(File file) {
        this(file, new Base64Encoder());
    }

    public SimpleDirectoryPersistentCache(File file, StringEncoder stringEncoder) {
        if (!file.exists()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" is not a directory");
        }
        this.cacheDir = file;
        this.stringEncoder = stringEncoder;
    }

    @Override
    public void addDiscoverInfoByNodePersistent(String string, DiscoverInfo discoverInfo) {
        String string2 = this.stringEncoder.encode(string);
        File file = new File(this.cacheDir, string2);
        try {
            if (file.createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile(file, discoverInfo);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void replay() throws IOException {
        File[] fileArray;
        for (File file : fileArray = this.cacheDir.listFiles()) {
            String string = this.stringEncoder.decode(file.getName());
            DiscoverInfo discoverInfo = SimpleDirectoryPersistentCache.restoreInfoFromFile(file);
            if (discoverInfo == null) continue;
            EntityCapsManager.addDiscoverInfoByNode(string, discoverInfo);
        }
    }

    @Override
    public void emptyCache() {
        File[] fileArray;
        for (File file : fileArray = this.cacheDir.listFiles()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInfoToFile(File file, DiscoverInfo discoverInfo) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        try {
            dataOutputStream.writeUTF(discoverInfo.toXML());
        }
        finally {
            dataOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DiscoverInfo restoreInfoFromFile(File file) throws IOException {
        DiscoverInfo discoverInfo;
        XmlPullParser xmlPullParser;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        String string = null;
        try {
            string = dataInputStream.readUTF();
        }
        finally {
            dataInputStream.close();
        }
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        try {
            xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xmlPullParser.setInput((Reader)stringReader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            return null;
        }
        IQProvider iQProvider = (IQProvider)ProviderManager.getInstance().getIQProvider("query", "http://jabber.org/protocol/disco#info");
        try {
            xmlPullParser.next();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            return null;
        }
        try {
            xmlPullParser.next();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            return null;
        }
        try {
            discoverInfo = (DiscoverInfo)iQProvider.parseIQ(xmlPullParser);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return discoverInfo;
    }
}

