package com.beem.project.beem.service;
import android.os.RemoteException;

import com.beem.project.beem.service.aidl.IChatManager;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXmppConnection;
import com.beem.project.beem.service.aidl.IXMPPFacade;

/**
 * This class is a facade for the Beem Service.
 * @author darisk
 */
public class XMPPFacade extends IXMPPFacade.Stub {

    private XMPPConnectionAdapter mConnexion;

    /**
     * Constructor for XMPPFacade.
     * @param connection the connection use by the facade
     */
    public XMPPFacade(final XMPPConnectionAdapter connection) {
	this.mConnexion = connection;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void connectAsync() throws RemoteException {
	mConnexion.connectAsync();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void connectSync() throws RemoteException {
	mConnexion.connectSync();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IXmppConnection createConnection() throws RemoteException {
	return mConnexion;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void disconnect() throws RemoteException {
	mConnexion.disconnect();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IRoster getRoster() throws RemoteException {
	return mConnexion.getRoster();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IChatManager getChatManager() throws RemoteException {
	return mConnexion.getChatManager();
    }

}
