/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.TextParseException;

public class ResolverConfig {
    private String[] servers = null;
    private Name[] searchlist = null;
    private static ResolverConfig currentConfig;

    public ResolverConfig() {
        if (this.findProperty()) {
            return;
        }
        if (this.findSunJVM()) {
            return;
        }
        if (this.servers == null || this.searchlist == null) {
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("java.vendor");
            if (string.indexOf("Windows") != -1) {
                if (string.indexOf("95") != -1 || string.indexOf("98") != -1 || string.indexOf("ME") != -1) {
                    this.find95();
                } else {
                    this.findNT();
                }
            } else if (string.indexOf("NetWare") != -1) {
                this.findNetware();
            } else if (string2.indexOf("Android") != -1) {
                this.findAndroid();
            } else {
                this.findUnix();
            }
        }
    }

    private void addServer(String string, List list) {
        if (list.contains(string)) {
            return;
        }
        if (Options.check("verbose")) {
            System.out.println("adding server " + string);
        }
        list.add(string);
    }

    private void addSearch(String string, List list) {
        Name name;
        if (Options.check("verbose")) {
            System.out.println("adding search " + string);
        }
        try {
            name = Name.fromString(string, Name.root);
        }
        catch (TextParseException textParseException) {
            return;
        }
        if (list.contains(name)) {
            return;
        }
        list.add(name);
    }

    private void configureFromLists(List list, List list2) {
        if (this.servers == null && list.size() > 0) {
            this.servers = list.toArray(new String[0]);
        }
        if (this.searchlist == null && list2.size() > 0) {
            this.searchlist = list2.toArray(new Name[0]);
        }
    }

    private boolean findProperty() {
        StringTokenizer stringTokenizer;
        ArrayList arrayList = new ArrayList(0);
        ArrayList arrayList2 = new ArrayList(0);
        String string = System.getProperty("dns.server");
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.addServer(stringTokenizer.nextToken(), arrayList);
            }
        }
        if ((string = System.getProperty("dns.search")) != null) {
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.addSearch(stringTokenizer.nextToken(), arrayList2);
            }
        }
        this.configureFromLists(arrayList, arrayList2);
        return this.servers != null && this.searchlist != null;
    }

    private boolean findSunJVM() {
        List list;
        List list2;
        Object object;
        ArrayList arrayList = new ArrayList(0);
        ArrayList arrayList2 = new ArrayList(0);
        try {
            object = new Class[]{};
            Object[] objectArray = new Object[]{};
            String string = "sun.net.dns.ResolverConfiguration";
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getDeclaredMethod("open", (Class<?>)object);
            Object object2 = method.invoke(null, objectArray);
            Method method2 = clazz.getMethod("nameservers", (Class<?>)object);
            list2 = (List)method2.invoke(object2, objectArray);
            Method method3 = clazz.getMethod("searchlist", (Class<?>)object);
            list = (List)method3.invoke(object2, objectArray);
        }
        catch (Exception exception) {
            return false;
        }
        if (list2.size() == 0) {
            return false;
        }
        if (list2.size() > 0) {
            object = list2.iterator();
            while (object.hasNext()) {
                this.addServer((String)object.next(), arrayList);
            }
        }
        if (list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                this.addSearch((String)object.next(), arrayList2);
            }
        }
        this.configureFromLists(arrayList, arrayList2);
        return true;
    }

    private void findResolvConf(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ArrayList arrayList = new ArrayList(0);
        ArrayList arrayList2 = new ArrayList(0);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if (string2.startsWith("nameserver")) {
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    this.addServer(stringTokenizer.nextToken(), arrayList);
                    continue;
                }
                if (string2.startsWith("domain")) {
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens() || !arrayList2.isEmpty()) continue;
                    this.addSearch(stringTokenizer.nextToken(), arrayList2);
                    continue;
                }
                if (!string2.startsWith("search")) continue;
                if (!arrayList2.isEmpty()) {
                    arrayList2.clear();
                }
                stringTokenizer = new StringTokenizer(string2);
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    this.addSearch(stringTokenizer.nextToken(), arrayList2);
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.configureFromLists(arrayList, arrayList2);
    }

    private void findUnix() {
        this.findResolvConf("/etc/resolv.conf");
    }

    private void findNetware() {
        this.findResolvConf("sys:/etc/resolv.cfg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findWin(InputStream inputStream) {
        String string = ResolverConfig.class.getPackage().getName();
        String string2 = string + ".windows.DNSServer";
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string2);
        String string3 = resourceBundle.getString("host_name");
        String string4 = resourceBundle.getString("primary_dns_suffix");
        String string5 = resourceBundle.getString("dns_suffix");
        String string6 = resourceBundle.getString("dns_servers");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            String string7 = null;
            boolean bl = false;
            boolean bl2 = false;
            while ((string7 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string7);
                if (!stringTokenizer.hasMoreTokens()) {
                    bl = false;
                    bl2 = false;
                    continue;
                }
                String string8 = stringTokenizer.nextToken();
                if (string7.indexOf(":") != -1) {
                    bl = false;
                    bl2 = false;
                }
                if (string7.indexOf(string3) != -1) {
                    Name name;
                    while (stringTokenizer.hasMoreTokens()) {
                        string8 = stringTokenizer.nextToken();
                    }
                    try {
                        name = Name.fromString(string8, null);
                    }
                    catch (TextParseException textParseException) {
                        continue;
                    }
                    if (name.labels() == 1) continue;
                    this.addSearch(string8, arrayList2);
                    continue;
                }
                if (string7.indexOf(string4) != -1) {
                    while (stringTokenizer.hasMoreTokens()) {
                        string8 = stringTokenizer.nextToken();
                    }
                    if (string8.equals(":")) continue;
                    this.addSearch(string8, arrayList2);
                    bl2 = true;
                    continue;
                }
                if (bl2 || string7.indexOf(string5) != -1) {
                    while (stringTokenizer.hasMoreTokens()) {
                        string8 = stringTokenizer.nextToken();
                    }
                    if (string8.equals(":")) continue;
                    this.addSearch(string8, arrayList2);
                    bl2 = true;
                    continue;
                }
                if (!bl && string7.indexOf(string6) == -1) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    string8 = stringTokenizer.nextToken();
                }
                if (string8.equals(":")) continue;
                this.addServer(string8, arrayList);
                bl = true;
            }
            this.configureFromLists(arrayList, arrayList2);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void find95() {
        String string = "winipcfg.out";
        try {
            Process process = Runtime.getRuntime().exec("winipcfg /all /batch " + string);
            process.waitFor();
            File file = new File(string);
            this.findWin(new FileInputStream(file));
            new File(string).delete();
        }
        catch (Exception exception) {
            return;
        }
    }

    private void findNT() {
        try {
            Process process = Runtime.getRuntime().exec("ipconfig /all");
            this.findWin(process.getInputStream());
            process.destroy();
        }
        catch (Exception exception) {
            return;
        }
    }

    private void findAndroid() {
        String string = "^\\d+(\\.\\d+){3}$";
        String string2 = "^[0-9a-f]+(:[0-9a-f]*)+:[0-9a-f]+$";
        try {
            String string3;
            ArrayList<String> arrayList = new ArrayList<String>();
            Process process = Runtime.getRuntime().exec("getprop");
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                String string4 = stringTokenizer.nextToken();
                if (string4.indexOf(".dns") <= -1) continue;
                String string5 = stringTokenizer.nextToken();
                if (!(string5 = string5.replaceAll("[ \\[\\]]", "")).matches(string) && !string5.matches(string2) || arrayList.contains(string5)) continue;
                arrayList.add(string5);
            }
            this.configureFromLists(arrayList, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] servers() {
        return this.servers;
    }

    public String server() {
        if (this.servers == null) {
            return null;
        }
        return this.servers[0];
    }

    public Name[] searchPath() {
        return this.searchlist;
    }

    public static synchronized ResolverConfig getCurrentConfig() {
        return currentConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        ResolverConfig resolverConfig = new ResolverConfig();
        Class<ResolverConfig> clazz = ResolverConfig.class;
        synchronized (ResolverConfig.class) {
            currentConfig = resolverConfig;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        ResolverConfig.refresh();
    }
}

