package com.beem.project.beem.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;

import com.beem.project.beem.R;

/**
 * This class is the main Activity for the Beem project.
 * @author Da Risk <darisk972@gmai.com>
 */
public class Login extends Activity {

    private SharedPreferences mSettings;
    private TextView mTextView;
    private boolean mIsConfigured;
    private boolean mIsResult;

    /**
     * Constructor.
     */
    public Login() {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.login);
	mTextView = (TextView) findViewById(R.id.log_as_msg);
	mSettings = PreferenceManager.getDefaultSharedPreferences(this);
    }

    @Override
    protected void onStart() {
	super.onStart();
	mIsConfigured = mSettings.getBoolean("PreferenceIsConfigured", false);
	// TODO utiliser une options des preference plutot.
	if (mIsConfigured && !mIsResult) {
	    mTextView.setText("");
	    Intent i = new Intent(this, LoginAnim.class);
	    startActivityForResult(i, 42);
	    mIsResult = false;
	}
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
	if (requestCode == 42) {
	    mIsResult = true;
	    if (resultCode == Activity.RESULT_OK) {
		startActivity(new Intent(this, ContactList.class));
		finish();
	    } else if (resultCode == Activity.RESULT_CANCELED) {
		if (data != null) {
		    String tmp = data.getExtras().getString("message");
		    Toast.makeText(Login.this, tmp, Toast.LENGTH_SHORT).show();
		    mTextView.setText(tmp);
		}
	    }
	}
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
	super.onCreateOptionsMenu(menu);
	MenuInflater inflater = getMenuInflater();
	inflater.inflate(R.menu.login, menu);
	return true;
    }

    @Override
    public final boolean onOptionsItemSelected(MenuItem item) {
	switch (item.getItemId()) {
	    case R.id.login_menu_settings:
		mTextView.setText("");
		startActivity(new Intent(Login.this, Settings.class));
		return true;
	    case R.id.login_menu_about:
		createAboutDialog();
		return true;
	    case R.id.login_menu_login:
		Intent i = new Intent(this, LoginAnim.class);
		startActivityForResult(i, 42);
		return true;
	    default:
		return false;
	}
    }

    /**
     * Create an about "BEEM" dialog.
     */
    private void createAboutDialog() {
	AlertDialog.Builder builder = new AlertDialog.Builder(this);
	builder.setTitle(R.string.login_about_title).setMessage(R.string.login_about_msg).setCancelable(false);
	builder.setNeutralButton(R.string.login_about_button, new DialogInterface.OnClickListener() {

	    public void onClick(DialogInterface dialog, int whichButton) {
		dialog.cancel();
	    }
	});
	AlertDialog aboutDialog = builder.create();
	aboutDialog.show();
    }
}
